/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.util.concurrent;

import com.timevale.guava.common.annotations.Beta;
import com.timevale.guava.common.util.concurrent.CheckedFuture;
import com.timevale.guava.common.util.concurrent.ForwardingListenableFuture;
import com.timevale.guava.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@Beta
public abstract class AbstractCheckedFuture<V, X extends Exception>
extends ForwardingListenableFuture.SimpleForwardingListenableFuture<V>
implements CheckedFuture<V, X> {
    protected AbstractCheckedFuture(ListenableFuture<V> delegate) {
        super(delegate);
    }

    protected abstract X mapException(Exception var1);

    @Override
    public V checkedGet() throws X {
        try {
            return this.get();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw this.mapException(interruptedException);
        }
        catch (CancellationException cancellationException) {
            throw this.mapException(cancellationException);
        }
        catch (ExecutionException executionException) {
            throw this.mapException(executionException);
        }
    }

    @Override
    public V checkedGet(long timeout, TimeUnit unit) throws TimeoutException, X {
        try {
            return this.get(timeout, unit);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw this.mapException(interruptedException);
        }
        catch (CancellationException cancellationException) {
            throw this.mapException(cancellationException);
        }
        catch (ExecutionException executionException) {
            throw this.mapException(executionException);
        }
    }
}

