/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OutputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1String;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.StreamUtil;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import com.timevale.tgtext.bouncycastle.util.Strings;
import java.io.IOException;

public class DERGraphicString
extends ASN1Primitive
implements ASN1String {
    private final byte[] string;

    public static DERGraphicString getInstance(Object object) {
        if (object == null || object instanceof DERGraphicString) {
            return (DERGraphicString)object;
        }
        if (object instanceof byte[]) {
            try {
                return (DERGraphicString)DERGraphicString.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERGraphicString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
        if (bl2 || aSN1Primitive instanceof DERGraphicString) {
            return DERGraphicString.getInstance(aSN1Primitive);
        }
        return new DERGraphicString(((ASN1OctetString)aSN1Primitive).getOctets());
    }

    public DERGraphicString(byte[] byArray) {
        this.string = Arrays.clone(byArray);
    }

    public byte[] getOctets() {
        return Arrays.clone(this.string);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.string.length) + this.string.length;
    }

    @Override
    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        aSN1OutputStream.writeEncoded(25, this.string);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.string);
    }

    @Override
    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERGraphicString)) {
            return false;
        }
        DERGraphicString dERGraphicString = (DERGraphicString)aSN1Primitive;
        return Arrays.areEqual(this.string, dERGraphicString.string);
    }

    @Override
    public String getString() {
        return Strings.fromByteArray(this.string);
    }
}

