/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.cms.CMSRuntimeException;
import com.timevale.tgtext.bouncycastle.cms.CMSTypedStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PKCS7TypedStream
extends CMSTypedStream {
    private final ASN1Encodable content;

    public PKCS7TypedStream(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) throws IOException {
        super(aSN1ObjectIdentifier);
        this.content = aSN1Encodable;
    }

    public ASN1Encodable getContent() {
        return this.content;
    }

    @Override
    public InputStream getContentStream() {
        try {
            return this.getContentStream(this.content);
        }
        catch (IOException iOException) {
            throw new CMSRuntimeException("unable to convert content to stream: " + iOException.getMessage(), iOException);
        }
    }

    @Override
    public void drain() throws IOException {
        this.getContentStream(this.content);
    }

    private InputStream getContentStream(ASN1Encodable aSN1Encodable) throws IOException {
        byte[] byArray = aSN1Encodable.toASN1Primitive().getEncoded("DER");
        int n2 = 1;
        while ((byArray[n2] & 0xFF) > 127) {
            ++n2;
        }
        return new ByteArrayInputStream(byArray, ++n2, byArray.length - n2);
    }
}

