/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.modes.gcm;

import com.timevale.tgtext.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import com.timevale.tgtext.bouncycastle.crypto.modes.gcm.GCMUtil;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.util.Vector;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    private Vector lookupPowX2;

    @Override
    public void init(byte[] byArray) {
        long[] lArray = GCMUtil.asLongs(byArray);
        if (this.lookupPowX2 != null && Arrays.areEqual(lArray, (long[])this.lookupPowX2.elementAt(0))) {
            return;
        }
        this.lookupPowX2 = new Vector(8);
        this.lookupPowX2.addElement(lArray);
    }

    @Override
    public void exponentiateX(long l2, byte[] byArray) {
        long[] lArray = GCMUtil.oneAsLongs();
        int n2 = 0;
        while (l2 > 0L) {
            if ((l2 & 1L) != 0L) {
                this.ensureAvailable(n2);
                GCMUtil.multiply(lArray, (long[])this.lookupPowX2.elementAt(n2));
            }
            ++n2;
            l2 >>>= 1;
        }
        GCMUtil.asBytes(lArray, byArray);
    }

    private void ensureAvailable(int n2) {
        int n3 = this.lookupPowX2.size();
        if (n3 <= n2) {
            long[] lArray = (long[])this.lookupPowX2.elementAt(n3 - 1);
            do {
                lArray = Arrays.clone(lArray);
                GCMUtil.square(lArray, lArray);
                this.lookupPowX2.addElement(lArray);
            } while (++n3 <= n2);
        }
    }
}

