/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

class DTLSReplayWindow {
    private static final long VALID_SEQ_MASK = 0xFFFFFFFFFFFFL;
    private static final long WINDOW_SIZE = 64L;
    private long latestConfirmedSeq = -1L;
    private long bitmap = 0L;

    DTLSReplayWindow() {
    }

    boolean shouldDiscard(long l2) {
        if ((l2 & 0xFFFFFFFFFFFFL) != l2) {
            return true;
        }
        if (l2 <= this.latestConfirmedSeq) {
            long l3 = this.latestConfirmedSeq - l2;
            if (l3 >= 64L) {
                return true;
            }
            if ((this.bitmap & 1L << (int)l3) != 0L) {
                return true;
            }
        }
        return false;
    }

    void reportAuthenticated(long l2) {
        if ((l2 & 0xFFFFFFFFFFFFL) != l2) {
            throw new IllegalArgumentException("'seq' out of range");
        }
        if (l2 <= this.latestConfirmedSeq) {
            long l3 = this.latestConfirmedSeq - l2;
            if (l3 < 64L) {
                this.bitmap |= 1L << (int)l3;
            }
        } else {
            long l4 = l2 - this.latestConfirmedSeq;
            if (l4 >= 64L) {
                this.bitmap = 1L;
            } else {
                this.bitmap <<= (int)l4;
                this.bitmap |= 1L;
            }
            this.latestConfirmedSeq = l2;
        }
    }

    void reset() {
        this.latestConfirmedSeq = -1L;
        this.bitmap = 0L;
    }
}

