/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.text;

import com.timevale.tgtext.text.pdf.draw.DrawInterface;

public class TabStop {
    protected float abb;
    protected Alignment abc = Alignment.LEFT;
    protected DrawInterface abd;
    protected char abe = (char)46;

    public static TabStop l(float f2, float f3) {
        f2 = (float)Math.round(f2 * 1000.0f) / 1000.0f;
        f3 = (float)Math.round(f3 * 1000.0f) / 1000.0f;
        TabStop tabStop = new TabStop(f2 + f3 - f2 % f3);
        return tabStop;
    }

    public TabStop(float position) {
        this(position, Alignment.LEFT);
    }

    public TabStop(float position, DrawInterface leader) {
        this(position, leader, Alignment.LEFT);
    }

    public TabStop(float position, Alignment alignment) {
        this(position, null, alignment);
    }

    public TabStop(float position, Alignment alignment, char anchorChar) {
        this(position, null, alignment, anchorChar);
    }

    public TabStop(float position, DrawInterface leader, Alignment alignment) {
        this(position, leader, alignment, '.');
    }

    public TabStop(float position, DrawInterface leader, Alignment alignment, char anchorChar) {
        this.abb = position;
        this.abd = leader;
        this.abc = alignment;
        this.abe = anchorChar;
    }

    public TabStop(TabStop tabStop) {
        this(tabStop.DP(), tabStop.DR(), tabStop.DQ(), tabStop.DS());
    }

    public float DP() {
        return this.abb;
    }

    public void an(float f2) {
        this.abb = f2;
    }

    public Alignment DQ() {
        return this.abc;
    }

    public void a(Alignment alignment) {
        this.abc = alignment;
    }

    public DrawInterface DR() {
        return this.abd;
    }

    public void a(DrawInterface drawInterface) {
        this.abd = drawInterface;
    }

    public char DS() {
        return this.abe;
    }

    public void k(char c2) {
        this.abe = c2;
    }

    public float a(float f2, float f3, float f4) {
        float f5 = this.abb;
        float f6 = f3 - f2;
        switch (this.abc) {
            case RIGHT: {
                if (f2 + f6 < this.abb) {
                    f5 = this.abb - f6;
                    break;
                }
                f5 = f2;
                break;
            }
            case CENTER: {
                if (f2 + f6 / 2.0f < this.abb) {
                    f5 = this.abb - f6 / 2.0f;
                    break;
                }
                f5 = f2;
                break;
            }
            case ANCHOR: {
                if (!Float.isNaN(f4)) {
                    if (f4 < this.abb) {
                        f5 = this.abb - (f4 - f2);
                        break;
                    }
                    f5 = f2;
                    break;
                }
                f5 = f2 + f6 < this.abb ? this.abb - f6 : f2;
            }
        }
        return f5;
    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER,
        ANCHOR;

    }
}

