/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.modeladapter.model;

import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import esign.utils.modeladapter.model.SuperModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelFactory.class);
    private String key;
    private String url;
    private SuperException e;
    private Class<? extends SuperModel> cls;

    public SuperModel createModel() throws SuperException {
        SuperModel superModel = this.createRawModel(this.cls);
        if (null != superModel.getUrl()) {
            LOGGER.debug("use the default url. url:{}", (Object)superModel.getUrl());
            return superModel;
        }
        if (null == this.url || this.url.isEmpty()) {
            LOGGER.error("this model of api has no url. api:{}", (Object)this.key);
            throw ErrorsDiscriptor.UrlAuthority.e(this.key);
        }
        superModel.setUrl(this.url);
        return superModel;
    }

    public ModelFactory(Class<? extends SuperModel> cls) {
        this.cls = cls;
        SuperModel superModel = this.createRawModel(cls);
        if (null == superModel) {
            return;
        }
        this.key = superModel.getKey();
    }

    private SuperModel createRawModel(Class<? extends SuperModel> cls) {
        try {
            return cls.newInstance();
        }
        catch (Exception exception) {
            LOGGER.error("create model failed. cls:{}", cls);
            this.e = ErrorsDiscriptor.InternalService.e(exception);
            return null;
        }
    }

    public String getKey() throws SuperException {
        if (null == this.key && null != this.e) {
            throw this.e;
        }
        return this.key;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

