/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.client;

import com.google.gson.JsonObject;
import com.timevale.esign.paas.tech.a.a;
import com.timevale.esign.paas.tech.bean.model.GetViewSignDetailUrlModel;
import com.timevale.esign.paas.tech.bean.result.GetViewSignDetailUrlResult;
import com.timevale.esign.paas.tech.client.ServiceClient;
import com.timevale.esign.paas.tech.client.context.InterfaceKey;
import com.timevale.esign.paas.tech.client.context.b;
import com.timevale.esign.paas.tech.service.AccountService;
import com.timevale.esign.paas.tech.service.AuthService;
import com.timevale.esign.paas.tech.service.EviService;
import com.timevale.esign.paas.tech.service.PdfDocumentService;
import com.timevale.esign.paas.tech.service.PlatformSignService;
import com.timevale.esign.paas.tech.service.SignVerifyService;
import com.timevale.esign.paas.tech.service.TemplateSealService;
import com.timevale.esign.paas.tech.service.UserSignService;
import com.timevale.esign.paas.tech.service.a.c;
import com.timevale.esign.paas.tech.service.a.f;
import com.timevale.esign.paas.tech.service.a.g;
import com.timevale.esign.paas.tech.service.a.h;
import com.timevale.esign.paas.tech.service.a.i;
import com.timevale.esign.paas.tech.service.a.j;
import com.timevale.esign.paas.tech.service.a.k;
import com.timevale.esign.paas.tech.util.ExceptionUtil;
import com.timevale.esign.paas.tech.util.RandomUtil;
import com.timevale.tech.sdk.bean.HttpConnectionConfig;
import com.timevale.tech.sdk.bean.ProjectConfig;
import com.timevale.tech.sdk.bean.SignatureConfig;
import com.timevale.tech.sdk.constants.HttpType;
import com.timevale.tech.sdk.oss.d;
import esign.utils.JsonHelper;
import esign.utils.asserts.AssertSupport;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import esign.utils.httpclient.HttpConfig;
import esign.utils.modeladapter.model.SuperModel;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceClient<R>
implements ServiceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServiceClient.class);
    protected static final String SCHEME_HTTP = HttpType.HTTP.type();
    private static final byte INTERFACE_REFRESH_INTERVAL = 2;
    private static final byte SCHEDULED_THREAD_NUMBER = 1;
    private b context;
    private a httpRunner;
    private d ossProvider;
    private String viewSignDetailUrl;
    private String serviceIdSeed;
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r2) {
            Thread thread = new Thread(r2);
            thread.setDaemon(true);
            return thread;
        }
    });
    private volatile AccountService accountService;
    private volatile PlatformSignService platformSignService;
    private volatile UserSignService userSignService;
    private volatile PdfDocumentService pdfDocumentService;
    private volatile TemplateSealService templateSealService;
    private volatile SignVerifyService signVerifyService;
    private volatile AuthService authService;
    private volatile EviService eviService;

    public AbstractServiceClient(ProjectConfig projectConfig, HttpConnectionConfig httpConfig, SignatureConfig signatureConfig) throws SuperException {
        this.validate(projectConfig, signatureConfig);
        this.context = new b(projectConfig, signatureConfig);
        this.httpRunner = new a(projectConfig, httpConfig, signatureConfig);
        this.ossProvider = new d(httpConfig);
        this.serviceIdSeed = projectConfig.getProjectId() + RandomUtil.getRandomCode(6);
        LOGGER.info("sign service id seed: {}", (Object)this.serviceIdSeed);
        this.initConfigBeforeRefresh();
        this.refreshContext();
        this.scheduler.scheduleWithFixedDelay(this.refreshTask(), 2L, 2L, TimeUnit.HOURS);
    }

    public void refreshContext() throws SuperException {
        LOGGER.info("refresh sdk client context. projectid:{}, url:{}, interval:{}h", new Object[]{this.context.up().getProjectId(), this.context.up().getItsmApiUrl(), (byte)2});
        R r2 = this.transExternalExceptionRequest();
        this.refreshTsa(r2);
        this.refreshInterface(r2);
        this.refreshViewSignDetailUrl();
    }

    private R transExternalExceptionRequest() throws SuperException {
        try {
            return this.requestInterfaceInfo();
        }
        catch (SuperException superException) {
            SuperException superException2 = ErrorsDiscriptor.ExternalService.e();
            if (superException2.getCode() == superException.getCode()) {
                throw ErrorsDiscriptor.REQUEST_INIT_INTERFACE_ERROR.e();
            }
            throw superException;
        }
    }

    protected Runnable refreshTask() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractServiceClient.this.refreshContext();
                }
                catch (SuperException superException) {
                    LOGGER.error("refresh client context failed. code: {}, msg:{}", (Object)superException.getCode(), (Object)superException.getMessage());
                }
            }
        };
    }

    protected abstract void initConfigBeforeRefresh();

    protected abstract R requestInterfaceInfo() throws SuperException;

    protected abstract void refreshTsa(R var1);

    protected abstract void refreshInterface(R var1) throws SuperException;

    private void refreshViewSignDetailUrl() throws SuperException {
        JsonObject jsonObject;
        GetViewSignDetailUrlModel getViewSignDetailUrlModel = (GetViewSignDetailUrlModel)this.getContext().a(InterfaceKey.GET_VIEW_SIGN_DETAIL_URL);
        try {
            jsonObject = this.request(getViewSignDetailUrlModel);
        }
        catch (SuperException superException) {
            throw ExceptionUtil.externalExceptionWithUrl(superException, getViewSignDetailUrlModel);
        }
        GetViewSignDetailUrlResult getViewSignDetailUrlResult = JsonHelper.fromJson(jsonObject, GetViewSignDetailUrlResult.class);
        if (0 != getViewSignDetailUrlResult.getErrCode()) {
            throw ErrorsDiscriptor.direct(getViewSignDetailUrlResult.getErrCode(), getViewSignDetailUrlResult.getMsg());
        }
        this.viewSignDetailUrl = getViewSignDetailUrlResult.getViewSignDetailUrl();
    }

    HttpConfig networkConfig() {
        return this.httpRunner.getConfig();
    }

    protected HttpConfig noSignCheckNetworkConfig() {
        return this.httpRunner.uv();
    }

    public b getContext() {
        return this.context;
    }

    JsonObject request(SuperModel model) throws SuperException {
        return this.httpRunner.a(model);
    }

    void aliOssUpload(String url, String content) throws SuperException {
        this.ossProvider.ws().upload(url, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccountService accountService() {
        if (this.accountService == null) {
            AbstractServiceClient abstractServiceClient = this;
            synchronized (abstractServiceClient) {
                if (this.accountService == null) {
                    this.accountService = new c(this);
                }
            }
        }
        return this.accountService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlatformSignService platformSignService() {
        if (this.platformSignService == null) {
            AbstractServiceClient abstractServiceClient = this;
            synchronized (abstractServiceClient) {
                if (this.platformSignService == null) {
                    this.platformSignService = new h(this);
                }
            }
        }
        return this.platformSignService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserSignService userSignService() {
        if (this.userSignService == null) {
            AbstractServiceClient abstractServiceClient = this;
            synchronized (abstractServiceClient) {
                if (this.userSignService == null) {
                    this.userSignService = new k(this);
                }
            }
        }
        return this.userSignService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PdfDocumentService pdfDocumentService() {
        if (this.pdfDocumentService == null) {
            AbstractServiceClient abstractServiceClient = this;
            synchronized (abstractServiceClient) {
                if (this.pdfDocumentService == null) {
                    this.pdfDocumentService = new g(this);
                }
            }
        }
        return this.pdfDocumentService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TemplateSealService templateSealService() {
        if (this.templateSealService == null) {
            AbstractServiceClient abstractServiceClient = this;
            synchronized (abstractServiceClient) {
                if (this.templateSealService == null) {
                    this.templateSealService = new j(this);
                }
            }
        }
        return this.templateSealService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SignVerifyService signVerifyService() {
        if (this.signVerifyService == null) {
            AbstractServiceClient abstractServiceClient = this;
            synchronized (abstractServiceClient) {
                if (this.signVerifyService == null) {
                    this.signVerifyService = new i(this);
                }
            }
        }
        return this.signVerifyService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthService authService() {
        if (this.authService == null) {
            AbstractServiceClient abstractServiceClient = this;
            synchronized (abstractServiceClient) {
                if (this.authService == null) {
                    this.authService = new com.timevale.esign.paas.tech.service.a.d(this);
                }
            }
        }
        return this.authService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EviService eviService() {
        if (this.eviService == null) {
            AbstractServiceClient abstractServiceClient = this;
            synchronized (abstractServiceClient) {
                if (this.eviService == null) {
                    this.eviService = new f(this);
                }
            }
        }
        return this.eviService;
    }

    @Override
    public boolean isWar() {
        if (this.context != null) {
            return this.context.up().isWar();
        }
        return false;
    }

    @Override
    public void shutdown() {
        if (!this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
        }
        this.httpRunner.shutdown();
    }

    public String getViewSignDetailUrl() {
        return this.viewSignDetailUrl;
    }

    String getServiceIdSeed() {
        return this.serviceIdSeed;
    }

    private void validate(ProjectConfig projectConfig, SignatureConfig signConfig) throws SuperException {
        AssertSupport.assertNotnull(projectConfig, ErrorsDiscriptor.SPEC_EMPTY_INPUT.e("projectConfig"));
        projectConfig.validate();
        if (signConfig != null) {
            signConfig.validate();
        }
    }
}

