/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.enums;

import com.timevale.guava.common.collect.Maps;
import java.util.Map;

public enum AccountTypeEnum {
    PERSON(1),
    ORGAN(2);

    private Integer type;
    private static Map<Integer, AccountTypeEnum> valueItems;
    private static Map<String, AccountTypeEnum> items;

    private AccountTypeEnum(Integer type) {
        this.type = type;
    }

    public Integer type() {
        return this.type;
    }

    public static boolean valid(String name) {
        return items.containsKey(name);
    }

    public static boolean isPerson(Integer type) {
        return PERSON.type().equals(type);
    }

    public static AccountTypeEnum getByType(Integer type) {
        return valueItems.get(type);
    }

    public static AccountTypeEnum getByName(String name) {
        return items.get(name);
    }

    static {
        items = Maps.newHashMap();
        valueItems = Maps.newHashMap();
        for (AccountTypeEnum accountTypeEnum : AccountTypeEnum.values()) {
            items.put(accountTypeEnum.name(), accountTypeEnum);
            valueItems.put(accountTypeEnum.type(), accountTypeEnum);
        }
    }
}

