/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.enums;

import com.timevale.esign.paas.tech.enums.ITemplateType;
import com.timevale.guava.common.collect.Maps;
import com.timevale.seal.sdk.util.StringUtils;
import com.timevale.tech.sdk.seal.PersonalSealTemplate;
import esign.utils.constant.type.Template;
import java.util.Map;

public enum PersonTemplateType implements ITemplateType
{
    SQUARE(PersonalSealTemplate.SQUARE, "simsun"),
    RECTANGLE(PersonalSealTemplate.RECTANGLE, "simsun"),
    BORDERLESS(PersonalSealTemplate.BORDERLESS, "simfang");

    private PersonalSealTemplate template;
    private String fontName;
    static Map<String, PersonTemplateType> items;

    private PersonTemplateType(PersonalSealTemplate template, String fontName) {
        this.template = template;
        this.fontName = fontName;
    }

    @Override
    public Template template() {
        switch (this) {
            case SQUARE: {
                return Template.SQUARE;
            }
            case RECTANGLE: {
                return Template.RECTANGLE;
            }
            case BORDERLESS: {
                return Template.BORDERLESS;
            }
        }
        return null;
    }

    public String getFontName() {
        return this.fontName;
    }

    public PersonalSealTemplate templateType() {
        return this.template;
    }

    public static boolean valid(String type) {
        if (StringUtils.isBlank(type)) {
            return true;
        }
        return items.containsKey(type);
    }

    public static PersonTemplateType getByName(String type) {
        return items.get(type);
    }

    static {
        items = Maps.newHashMap();
        for (PersonTemplateType personTemplateType : PersonTemplateType.values()) {
            items.put(personTemplateType.name(), personTemplateType);
        }
    }
}

