/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.enums;

import com.timevale.guava.common.collect.Maps;
import com.timevale.tgpdfsign.sign.SignPolicy;
import java.util.Map;

public enum SignType {
    Single(1, SignPolicy.Single),
    Multi(2, SignPolicy.Multi),
    Edges(3, SignPolicy.Edges),
    Key(4, SignPolicy.Key);

    static Map<String, SignType> items;
    private int val;
    private SignPolicy policy;

    private SignType(int val, SignPolicy policy) {
        this.val = val;
    }

    public int val() {
        return this.val;
    }

    public SignPolicy policy() {
        return this.policy;
    }

    public static SignType from(int val) {
        for (SignType signType : SignType.values()) {
            if (signType.val() != val) continue;
            return signType;
        }
        return Single;
    }

    public static SignType getByName(String name) {
        return items.get(name);
    }

    static {
        items = Maps.newHashMap();
        for (SignType signType : SignType.values()) {
            items.put(signType.name(), signType);
        }
    }
}

