/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.util;

import com.timevale.o;
import com.timevale.tgpdfsign.e.h;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import com.timevale.tgtext.bouncycastle.cms.CMSSignedData;
import com.timevale.tgtext.bouncycastle.cms.SignerInformation;
import com.timevale.tgtext.bouncycastle.cms.SignerInformationStore;
import com.timevale.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import com.timevale.tgtext.bouncycastle.util.CollectionStore;
import com.timevale.timestamp.utils.d;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class SignatureVerifyUtils {
    public static Map<String, String> SIGNATURE_ALGO_PROVIDER_MAP = null;
    private static final String SIGNATURE_ALGO_SPLIT_PATTERN = "with";
    private static final String SIGNATURE_ALGO_SPLIT_PATTERN_CAPTIAL = "With";
    private static final String SIGNATURE_SM3_WITH_SM2_ALGO = "SM3withSM2";
    private static final String SIGNATURE_SHA256_WITH_RSA_ALGO = "SHA256WithRSA";

    public static boolean verify(String text, String signatureAlgo, byte[] signature, byte[] cert, byte[] timestampSignature) throws Exception {
        String string = null;
        string = signatureAlgo.contains(SIGNATURE_ALGO_SPLIT_PATTERN) ? signatureAlgo.split(SIGNATURE_ALGO_SPLIT_PATTERN)[0] : signatureAlgo.split(SIGNATURE_ALGO_SPLIT_PATTERN_CAPTIAL)[0];
        byte[] byArray = SignatureVerifyUtils.calculateHash(text, string);
        Certificate certificate = null;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cert);
        while (((InputStream)byteArrayInputStream).available() > 0) {
            certificate = certificateFactory.generateCertificate(byteArrayInputStream);
        }
        if (certificate == null) {
            throw new RuntimeException("\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25");
        }
        PublicKey publicKey = null;
        Signature signature2 = Signature.getInstance(signatureAlgo, SIGNATURE_ALGO_PROVIDER_MAP.get(signatureAlgo));
        publicKey = SIGNATURE_SM3_WITH_SM2_ALGO.equals(signatureAlgo) ? h.getPublicKeyByCert((X509Certificate)certificate) : certificate.getPublicKey();
        signature2.initVerify(publicKey);
        signature2.update(byArray);
        boolean bl2 = signature2.verify(signature);
        return bl2 &= d.n(signature, timestampSignature);
    }

    public static boolean verify(String text, byte[] signedData) throws Exception {
        byte[] byArray = null;
        String string = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(signedData);
        CMSSignedData cMSSignedData = new CMSSignedData(byteArrayInputStream);
        SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
        Collection<SignerInformation> collection = signerInformationStore.getSigners();
        for (SignerInformation object2 : collection) {
            byArray = object2.getSignature();
            if (StringUtils.equals((String)"1.2.156.10197.1.401", (String)object2.getDigestAlgOID())) {
                string = SIGNATURE_SM3_WITH_SM2_ALGO;
                continue;
            }
            string = SIGNATURE_SHA256_WITH_RSA_ALGO;
        }
        CollectionStore collectionStore = (CollectionStore)cMSSignedData.getCertificates();
        X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)collectionStore.iterator().next();
        X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider(new BouncyCastleProvider()).getCertificate(x509CertificateHolder);
        byte[] byArray2 = x509Certificate.getEncoded();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        Certificate certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(byArray2));
        assert (string != null);
        String string2 = null;
        string2 = string.contains(SIGNATURE_ALGO_SPLIT_PATTERN) ? string.split(SIGNATURE_ALGO_SPLIT_PATTERN)[0] : string.split(SIGNATURE_ALGO_SPLIT_PATTERN_CAPTIAL)[0];
        byte[] byArray3 = SignatureVerifyUtils.calculateHash(text, string2);
        Signature signature = Signature.getInstance(string, SIGNATURE_ALGO_PROVIDER_MAP.get(string));
        PublicKey publicKey = null;
        publicKey = SIGNATURE_SM3_WITH_SM2_ALGO.equals(string) ? h.getPublicKeyByCert((X509Certificate)certificate) : certificate.getPublicKey();
        signature.initVerify(publicKey);
        signature.update(byArray3);
        return signature.verify(byArray);
    }

    private static byte[] calculateHash(String text, String hashAlgo) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance(hashAlgo);
        byte[] byArray = text.getBytes("utf-8");
        messageDigest.update(byArray, 0, byArray.length);
        return messageDigest.digest();
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(SIGNATURE_SM3_WITH_SM2_ALGO, "SM");
        hashMap.put(SIGNATURE_SHA256_WITH_RSA_ALGO, "BC");
        SIGNATURE_ALGO_PROVIDER_MAP = Collections.unmodifiableMap(hashMap);
        Security.addProvider(new BouncyCastleProvider());
        Security.addProvider(new o());
    }
}

