/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.net;

import com.timevale.guava.common.annotations.Beta;
import com.timevale.guava.common.base.Objects;
import com.timevale.guava.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Beta
public final class HostAndPort {
    private static final int NO_PORT = -1;
    private final String host;
    private final int port;
    private final boolean hasBracketlessColons;
    private static final Pattern BRACKET_PATTERN = Pattern.compile("^\\[(.*:.*)\\](?::(\\d*))?$");

    private HostAndPort(String host, int port, boolean hasBracketlessColons) {
        this.host = host;
        this.port = port;
        this.hasBracketlessColons = hasBracketlessColons;
    }

    public String getHostText() {
        return this.host;
    }

    public boolean hasPort() {
        return this.port >= 0;
    }

    public int getPort() {
        Preconditions.checkState(this.hasPort());
        return this.port;
    }

    public int getPortOrDefault(int defaultPort) {
        return this.hasPort() ? this.port : defaultPort;
    }

    public static HostAndPort fromParts(String host, int port) {
        Preconditions.checkArgument(HostAndPort.isValidPort(port));
        HostAndPort hostAndPort = HostAndPort.fromString(host);
        Preconditions.checkArgument(!hostAndPort.hasPort());
        return new HostAndPort(hostAndPort.host, port, hostAndPort.hasBracketlessColons);
    }

    public static HostAndPort fromString(String hostPortString) {
        String string;
        Preconditions.checkNotNull(hostPortString);
        String string2 = null;
        boolean bl2 = false;
        if (hostPortString.startsWith("[")) {
            Matcher matcher = BRACKET_PATTERN.matcher(hostPortString);
            Preconditions.checkArgument(matcher.matches(), "Invalid bracketed host/port: %s", hostPortString);
            string = matcher.group(1);
            string2 = matcher.group(2);
        } else {
            int n2 = hostPortString.indexOf(58);
            if (n2 >= 0 && hostPortString.indexOf(58, n2 + 1) == -1) {
                string = hostPortString.substring(0, n2);
                string2 = hostPortString.substring(n2 + 1);
            } else {
                string = hostPortString;
                bl2 = n2 >= 0;
            }
        }
        int n3 = -1;
        if (string2 != null) {
            try {
                n3 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Unparseable port number: " + hostPortString);
            }
            Preconditions.checkArgument(HostAndPort.isValidPort(n3), "Port number out of range: %s", hostPortString);
        }
        return new HostAndPort(string, n3, bl2);
    }

    public HostAndPort withDefaultPort(int defaultPort) {
        Preconditions.checkArgument(HostAndPort.isValidPort(defaultPort));
        if (this.hasPort() || this.port == defaultPort) {
            return this;
        }
        return new HostAndPort(this.host, defaultPort, this.hasBracketlessColons);
    }

    public HostAndPort requireBracketsForIPv6() {
        Preconditions.checkArgument(!this.hasBracketlessColons, "Possible bracketless IPv6 literal: %s", this.host);
        return this;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HostAndPort) {
            HostAndPort hostAndPort = (HostAndPort)other;
            return Objects.equal(this.host, hostAndPort.host) && this.port == hostAndPort.port && this.hasBracketlessColons == hostAndPort.hasBracketlessColons;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.host, this.port, this.hasBracketlessColons);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.host.length() + 7);
        if (this.host.indexOf(58) >= 0) {
            stringBuilder.append('[').append(this.host).append(']');
        } else {
            stringBuilder.append(this.host);
        }
        if (this.hasPort()) {
            stringBuilder.append(':').append(this.port);
        }
        return stringBuilder.toString();
    }

    private static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }
}

