/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.seal.sdk.drawer;

import com.timevale.seal.sdk.drawer.ImageDrawer;
import com.timevale.seal.sdk.drawer.request.InnerRequest;
import com.timevale.seal.sdk.enums.SealColor;
import com.timevale.seal.sdk.exception.SealSdkException;
import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;

public abstract class AbstractImageDrawer
implements ImageDrawer {
    private static final int[] PALETTE = new int[]{0xFFFFFF, SealColor.RED.getColor().getRGB(), SealColor.BLUE.getColor().getRGB(), SealColor.BLACK.getColor().getRGB(), SealColor.PURPLE.getColor().getRGB()};
    private static final IndexColorModel ICM = new IndexColorModel(8, PALETTE.length, PALETTE, 0, true, 0, 0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends InnerRequest> BufferedImage draw(T request) {
        this.checkRequest(request);
        BufferedImage bufferedImage = new BufferedImage(request.getWidth(), request.getHeight(), request.getBufferedImageType(), ICM);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(request.getSealColor().getColor());
        this.drawBoundary(request.getWidth(), request.getHeight(), request.getBorderWidth(), graphics2D);
        try {
            this.customDraw(request, graphics2D);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    private void drawBoundary(int width, int height, Integer borderWidth, Graphics2D g2d) {
        if (borderWidth == null || 0 == borderWidth) {
            return;
        }
        int n2 = borderWidth >>> 1;
        int n3 = width - borderWidth;
        int n4 = height - borderWidth;
        Stroke stroke = g2d.getStroke();
        g2d.setStroke(new BasicStroke(borderWidth.intValue()));
        this.customDrawBoundary(n2, n2, n3, n4, g2d);
        g2d.setStroke(stroke);
    }

    protected abstract void customDrawBoundary(int var1, int var2, int var3, int var4, Graphics2D var5);

    public abstract <T extends InnerRequest> void customDraw(T var1, Graphics2D var2);

    private <T extends InnerRequest> void checkRequest(T request) {
        if (request == null) {
            throw new SealSdkException("ImageRequest request is null");
        }
        if (request.getWidth() <= 0) {
            throw new SealSdkException("ImageRequest weight <= 0");
        }
        if (request.getHeight() <= 0) {
            throw new SealSdkException("ImageRequest height <= 0");
        }
        if (request.getDpi() <= 0) {
            throw new SealSdkException("ImageRequest dip <= 0");
        }
        if (request.getSealColor() == null) {
            throw new SealSdkException("ImageRequest sealColor is null");
        }
        this.validateRequest(request);
    }

    protected abstract <T extends InnerRequest> void validateRequest(T var1);

    protected int getMaxWordWidth(char[] chars, FontMetrics fm2) {
        if (chars == null || chars.length == 0 || fm2 == null) {
            return 0;
        }
        int n2 = 0;
        for (char c2 : chars) {
            int n3 = fm2.charWidth(c2);
            if (n3 < 0) {
                n3 = -n3;
            }
            n2 = Math.max(n2, n3);
        }
        return n2;
    }

    protected int getTotalWordWidth(char[] chars, FontMetrics fm2) {
        if (chars == null || chars.length == 0 || fm2 == null) {
            return 0;
        }
        int n2 = 0;
        for (char c2 : chars) {
            n2 += fm2.charWidth(c2);
        }
        return n2;
    }

    protected int getInnerLen(int value, Integer borderWidth) {
        if (borderWidth != null && borderWidth != 0) {
            value -= borderWidth << 1;
        }
        return value;
    }
}

