/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tech.sdk.utils;

import com.timevale.tech.sdk.utils.Base64Util;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageUtil {
    private ImageUtil() {
    }

    public static BufferedImage hyalinizeImage(BufferedImage originalImage, float alpha) {
        int n2 = originalImage.getWidth();
        int n3 = originalImage.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 6);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(3, alpha));
        graphics2D.drawImage(originalImage, 0, 0, n2, n3, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static String imageToBase64(BufferedImage image, String format) throws IOException {
        return ImageUtil.imageToBase64(ImageUtil.bufferedImageTobytes(image, format));
    }

    public static String imageToBase64(byte[] image) {
        return Base64Util.encode(image);
    }

    public static byte[] base64ToImageBytes(String data) throws IOException {
        return Base64Util.decode(data);
    }

    public static BufferedImage bytesToBufferedImage(byte[] bytes) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        return ImageIO.read(byteArrayInputStream);
    }

    public static BufferedImage base64ToBufferedImage(String data) throws IOException {
        return ImageUtil.bytesToBufferedImage(ImageUtil.base64ToImageBytes(data));
    }

    public static byte[] bufferedImageTobytes(BufferedImage image, String format) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, format, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

