/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.ocsp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.ResponseData;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.SingleResponse;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.Certificate;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extension;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extensions;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.ocsp.OCSPException;
import com.timevale.tgtext.bouncycastle.cert.ocsp.OCSPUtils;
import com.timevale.tgtext.bouncycastle.cert.ocsp.RespID;
import com.timevale.tgtext.bouncycastle.cert.ocsp.SingleResp;
import com.timevale.tgtext.bouncycastle.operator.ContentVerifier;
import com.timevale.tgtext.bouncycastle.operator.ContentVerifierProvider;
import com.timevale.tgtext.bouncycastle.util.Encodable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class BasicOCSPResp
implements Encodable {
    private BasicOCSPResponse resp;
    private ResponseData data;
    private Extensions extensions;

    public BasicOCSPResp(BasicOCSPResponse basicOCSPResponse) {
        this.resp = basicOCSPResponse;
        this.data = basicOCSPResponse.getTbsResponseData();
        this.extensions = Extensions.getInstance(basicOCSPResponse.getTbsResponseData().getResponseExtensions());
    }

    public byte[] getTBSResponseData() {
        try {
            return this.resp.getTbsResponseData().getEncoded("DER");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public AlgorithmIdentifier getSignatureAlgorithmID() {
        return this.resp.getSignatureAlgorithm();
    }

    public int getVersion() {
        return this.data.getVersion().getValue().intValue() + 1;
    }

    public RespID getResponderId() {
        return new RespID(this.data.getResponderID());
    }

    public Date getProducedAt() {
        return OCSPUtils.extractDate(this.data.getProducedAt());
    }

    public SingleResp[] getResponses() {
        ASN1Sequence aSN1Sequence = this.data.getResponses();
        SingleResp[] singleRespArray = new SingleResp[aSN1Sequence.size()];
        for (int i2 = 0; i2 != singleRespArray.length; ++i2) {
            singleRespArray[i2] = new SingleResp(SingleResponse.getInstance(aSN1Sequence.getObjectAt(i2)));
        }
        return singleRespArray;
    }

    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public Extension getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (this.extensions != null) {
            return this.extensions.getExtension(aSN1ObjectIdentifier);
        }
        return null;
    }

    public List getExtensionOIDs() {
        return OCSPUtils.getExtensionOIDs(this.extensions);
    }

    public Set getCriticalExtensionOIDs() {
        return OCSPUtils.getCriticalExtensionOIDs(this.extensions);
    }

    public Set getNonCriticalExtensionOIDs() {
        return OCSPUtils.getNonCriticalExtensionOIDs(this.extensions);
    }

    public ASN1ObjectIdentifier getSignatureAlgOID() {
        return this.resp.getSignatureAlgorithm().getAlgorithm();
    }

    public byte[] getSignature() {
        return this.resp.getSignature().getOctets();
    }

    public X509CertificateHolder[] getCerts() {
        if (this.resp.getCerts() != null) {
            ASN1Sequence aSN1Sequence = this.resp.getCerts();
            if (aSN1Sequence != null) {
                X509CertificateHolder[] x509CertificateHolderArray = new X509CertificateHolder[aSN1Sequence.size()];
                for (int i2 = 0; i2 != x509CertificateHolderArray.length; ++i2) {
                    x509CertificateHolderArray[i2] = new X509CertificateHolder(Certificate.getInstance(aSN1Sequence.getObjectAt(i2)));
                }
                return x509CertificateHolderArray;
            }
            return OCSPUtils.EMPTY_CERTS;
        }
        return OCSPUtils.EMPTY_CERTS;
    }

    public boolean isSignatureValid(ContentVerifierProvider contentVerifierProvider) throws OCSPException {
        try {
            ContentVerifier contentVerifier = contentVerifierProvider.get(this.resp.getSignatureAlgorithm());
            OutputStream outputStream = contentVerifier.getOutputStream();
            outputStream.write(this.resp.getTbsResponseData().getEncoded("DER"));
            outputStream.close();
            return contentVerifier.verify(this.getSignature());
        }
        catch (Exception exception) {
            throw new OCSPException("exception processing sig: " + exception, exception);
        }
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.resp.getEncoded();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BasicOCSPResp)) {
            return false;
        }
        BasicOCSPResp basicOCSPResp = (BasicOCSPResp)object;
        return this.resp.equals(basicOCSPResp.resp);
    }

    public int hashCode() {
        return this.resp.hashCode();
    }
}

