/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.path.validations;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extension;
import com.timevale.tgtext.bouncycastle.asn1.x509.PolicyConstraints;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.path.CertPathValidation;
import com.timevale.tgtext.bouncycastle.cert.path.CertPathValidationContext;
import com.timevale.tgtext.bouncycastle.cert.path.CertPathValidationException;
import com.timevale.tgtext.bouncycastle.cert.path.validations.ValidationUtils;
import com.timevale.tgtext.bouncycastle.util.Memoable;
import java.math.BigInteger;

public class CertificatePoliciesValidation
implements CertPathValidation {
    private int explicitPolicy;
    private int policyMapping;
    private int inhibitAnyPolicy;

    CertificatePoliciesValidation(int n2) {
        this(n2, false, false, false);
    }

    CertificatePoliciesValidation(int n2, boolean bl2, boolean bl3, boolean bl4) {
        this.explicitPolicy = bl2 ? 0 : n2 + 1;
        this.inhibitAnyPolicy = bl3 ? 0 : n2 + 1;
        this.policyMapping = bl4 ? 0 : n2 + 1;
    }

    @Override
    public void validate(CertPathValidationContext certPathValidationContext, X509CertificateHolder x509CertificateHolder) throws CertPathValidationException {
        certPathValidationContext.addHandledExtension(Extension.policyConstraints);
        certPathValidationContext.addHandledExtension(Extension.inhibitAnyPolicy);
        if (!certPathValidationContext.isEndEntity() && !ValidationUtils.isSelfIssued(x509CertificateHolder)) {
            int n2;
            Object object;
            this.explicitPolicy = this.countDown(this.explicitPolicy);
            this.policyMapping = this.countDown(this.policyMapping);
            this.inhibitAnyPolicy = this.countDown(this.inhibitAnyPolicy);
            PolicyConstraints policyConstraints = PolicyConstraints.fromExtensions(x509CertificateHolder.getExtensions());
            if (policyConstraints != null) {
                BigInteger bigInteger;
                object = policyConstraints.getRequireExplicitPolicyMapping();
                if (object != null && ((BigInteger)object).intValue() < this.explicitPolicy) {
                    this.explicitPolicy = ((BigInteger)object).intValue();
                }
                if ((bigInteger = policyConstraints.getInhibitPolicyMapping()) != null && bigInteger.intValue() < this.policyMapping) {
                    this.policyMapping = bigInteger.intValue();
                }
            }
            if ((object = x509CertificateHolder.getExtension(Extension.inhibitAnyPolicy)) != null && (n2 = ASN1Integer.getInstance(((Extension)object).getParsedValue()).getValue().intValue()) < this.inhibitAnyPolicy) {
                this.inhibitAnyPolicy = n2;
            }
        }
    }

    private int countDown(int n2) {
        if (n2 != 0) {
            return n2 - 1;
        }
        return 0;
    }

    @Override
    public Memoable copy() {
        return new CertificatePoliciesValidation(0);
    }

    @Override
    public void reset(Memoable memoable) {
        CertificatePoliciesValidation certificatePoliciesValidation = (CertificatePoliciesValidation)memoable;
    }
}

