/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.bean;

import esign.a.a.c;
import esign.utils.bean.IResult;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import esign.utils.exception.collector.meta.ErrorMeta;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResultUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(ResultUtil.class);

    public static <T extends IResult> T failed(int code, String msg, boolean show, Class<T> cls) {
        LOGGER.error("failed for code: {}, msg: {}", (Object)code, (Object)msg);
        try {
            IResult iResult = (IResult)cls.newInstance();
            return (T)ResultUtil.initResult(iResult, code, msg, show);
        }
        catch (Exception exception) {
            LOGGER.error("create result failed. exception:{}", (Throwable)exception);
            return null;
        }
    }

    public static <T extends IResult> T failed(ErrorMeta disc, Class<T> cls) {
        LOGGER.error("failed for code: {}, msg: {}", (Object)disc.code(), (Object)disc.message());
        try {
            IResult iResult = (IResult)cls.newInstance();
            return (T)ResultUtil.initResult(iResult, disc.code(), disc.message(), false);
        }
        catch (Exception exception) {
            LOGGER.error("create result failed. exception:{}", (Throwable)exception);
            return null;
        }
    }

    public static <T extends IResult> T failedMaybe(Exception se, Class<T> cls) {
        if (se instanceof SuperException) {
            return ResultUtil.failed((SuperException)se, cls);
        }
        return ResultUtil.failed(se, cls);
    }

    public static <T extends IResult> T failed(Exception se, Class<T> cls) {
        String string = null == se.getMessage() ? se.getClass().getName() : se.getMessage();
        LOGGER.error("exception:", (Throwable)se);
        return ResultUtil.failed(ErrorsDiscriptor.InternalServiceTaken.e(se, string), cls);
    }

    public static <T extends IResult> T failed(SuperException se, Class<T> cls) {
        LOGGER.error("failed for code: {}, msg: {}", (Object)se.getCode(), (Object)se.getMessage());
        LOGGER.error("exception:", (Throwable)se);
        try {
            IResult iResult = (IResult)cls.newInstance();
            return (T)ResultUtil.initResult(iResult, se.getCode(), se.getMessage(), false);
        }
        catch (Exception exception) {
            LOGGER.error("create result failed. exception:", (Throwable)exception);
            return null;
        }
    }

    public static <T extends IResult> T failed(IResult bean, Class<T> cls) {
        LOGGER.error("failed for code: {}, msg: {}", (Object)bean.getErrCode(), (Object)bean.getMsg());
        try {
            IResult iResult = (IResult)cls.newInstance();
            return (T)ResultUtil.initResult(iResult, bean);
        }
        catch (Exception exception) {
            LOGGER.error("create result failed. exception:", (Throwable)exception);
            return null;
        }
    }

    public static String success() {
        return ResultUtil.returnStringResult(0);
    }

    public static String returnStringResult(int code) {
        return ResultUtil.returnStringResult(code, null, true);
    }

    public static String returnStringResult(int code, String msg) {
        return ResultUtil.returnStringResult(code, msg, true);
    }

    public static String returnStringResult(int code, String msg, boolean show) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"errShow", (Object)show);
        jSONObject.put((Object)"errCode", (Object)code);
        if (0 == code) {
            if (null == msg) {
                jSONObject.put((Object)"msg", (Object)"");
            } else {
                jSONObject.put((Object)"msg", (Object)msg);
            }
        } else if (null == msg) {
            jSONObject.put((Object)"msg", (Object)c.jY(code));
        } else {
            jSONObject.put((Object)"msg", (Object)msg);
        }
        return jSONObject.toString();
    }

    private static <T extends IResult> T initResult(T result, IResult bean) {
        return ResultUtil.initResult(result, bean.getErrCode(), bean.getMsg(), bean.isErrShow());
    }

    private static <T extends IResult> T initResult(T result, int code, String msg, boolean show) {
        result.setErrCode(code);
        result.setErrShow(show);
        result.setMsg(msg);
        return result;
    }

    public static <T extends IResult> T failed(int code, Class<T> cls) {
        try {
            IResult iResult = (IResult)cls.newInstance();
            return (T)ResultUtil.initResult(iResult, code, c.jY(code), true);
        }
        catch (Exception exception) {
            LOGGER.error("create result failed. exception:", (Throwable)exception);
            return null;
        }
    }
}

