/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.configuration;

import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationReloadable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationReloadable.class);
    private String path;
    private PropertiesConfiguration configure;

    public ConfigurationReloadable(String path) {
        this.path = path;
    }

    public <T> T get(String key, Class<T> valueClass) throws SuperException {
        Object object;
        Object object2 = object = this.get().getProperty(key);
        return (T)object2;
    }

    public String getString(String key) throws SuperException {
        return this.get().getString(key);
    }

    public int getInt(String key) throws SuperException {
        return this.get().getInt(key);
    }

    public boolean getBoolean(String key) throws SuperException {
        return this.get().getBoolean(key);
    }

    public List<String> getList(String key) throws SuperException {
        return this.get().getList(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertiesConfiguration get() throws SuperException {
        if (null != this.configure) {
            return this.configure;
        }
        ConfigurationReloadable configurationReloadable = this;
        synchronized (configurationReloadable) {
            if (null != this.configure) {
                return this.configure;
            }
            this.configure = this.create(this.path);
            return this.configure;
        }
    }

    private PropertiesConfiguration create(String path) throws SuperException {
        PropertiesConfiguration propertiesConfiguration;
        try {
            propertiesConfiguration = new PropertiesConfiguration(path);
        }
        catch (ConfigurationException configurationException) {
            LOGGER.error("read configuration file failed. path:{}", (Object)path);
            LOGGER.error("exception:", (Throwable)configurationException);
            throw ErrorsDiscriptor.InternalService.e(configurationException);
        }
        propertiesConfiguration.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
        return propertiesConfiguration;
    }
}

