/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.modeladapter.adapter;

import esign.utils.exception.SuperException;
import esign.utils.modeladapter.adapter.ModelsInitializerConfig;
import esign.utils.modeladapter.impl.RefreshModels;
import esign.utils.modeladapter.impl.RefreshModelsTask;
import java.util.Timer;
import org.apache.http.annotation.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public enum ModelsInitializer {
    INSTANCE;

    private static final Logger LOGGER;
    private static volatile Timer updateTimer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Enum<T>> void refresh(Class<T> modelsEnumClass, ModelsInitializerConfig config) throws SuperException {
        LOGGER.info("refresh the models. url:{}", (Object)config.getUrl());
        LOGGER.info("refresh the models. interval:{}", (Object)config.getRefreshInterval());
        RefreshModels.refresh(modelsEnumClass, config);
        if (null != updateTimer) {
            return;
        }
        ModelsInitializer modelsInitializer = this;
        synchronized (modelsInitializer) {
            if (null != updateTimer) {
                return;
            }
            updateTimer = new Timer(true);
            updateTimer.schedule(new RefreshModelsTask<T>(modelsEnumClass, config), config.getRefreshInterval(), config.getRefreshInterval());
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(ModelsInitializer.class);
        updateTimer = null;
    }
}

