/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.modeladapter.model;

import com.google.gson.JsonObject;
import esign.utils.http.HttpExtend;
import esign.utils.http.HttpExtendType;
import esign.utils.httpclient.Method;
import esign.utils.httpclient.Optional;
import java.util.ArrayList;
import java.util.List;

public class SuperModel {
    private String url;
    private String key;
    private Method method;
    private Optional optional;
    private JsonObject json = new JsonObject();
    private List<HttpExtend> extend = new ArrayList<HttpExtend>();
    private List<HttpExtend> paths = new ArrayList<HttpExtend>();
    private List<HttpExtend> params = new ArrayList<HttpExtend>();

    public SuperModel(String key, Method method) {
        this.key = key;
        this.method = method;
        this.optional = Optional.BODY;
    }

    public SuperModel(String key, Method method, Optional optional) {
        this.key = key;
        this.method = method;
        this.optional = optional;
    }

    public JsonObject getJson() {
        return this.json;
    }

    public void setJson(JsonObject json) {
        this.json = json;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getKey() {
        return this.key;
    }

    public Method getMethod() {
        return this.method;
    }

    public Optional getOptional() {
        return this.optional;
    }

    public void addPathParam(String name, Object value) {
        this.paths.add(new HttpExtend(HttpExtendType.NORMAL, name, value));
    }

    public void addQueryParam(String name, Object value) {
        this.params.add(new HttpExtend(HttpExtendType.NORMAL, name, value));
    }

    public void addBodyParam(String name, String value) {
        if (null == value) {
            return;
        }
        this.json.addProperty(this.key, value);
    }

    public boolean has(String key) {
        return this.json.has(key) || this.paths.contains(key) || this.params.contains(key);
    }

    public void addParamOptional(String key, Object val) {
        switch (this.optional) {
            case PATH: {
                this.addPathParam(key, val);
                break;
            }
            case QUERY: {
                this.addQueryParam(key, val);
                break;
            }
            case BODY: {
                this.addBodyParam(key, (String)val);
                break;
            }
        }
    }

    protected void addExtend(HttpExtendType type, String name, Object value) {
        this.extend.add(new HttpExtend(type, name, value));
    }

    public List<HttpExtend> getExtends() {
        return this.extend;
    }

    public List<HttpExtend> getPaths() {
        return this.paths;
    }

    public List<HttpExtend> getParams() {
        return this.params;
    }
}

