/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.reflect;

import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import java.lang.reflect.Field;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReflectUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectUtil.class);

    public static <T> T helperFieldGet(String field, Object target) throws SuperException {
        return ReflectUtil.helperFieldGet(field, target, null);
    }

    public static <T> T helperFieldGet(Field field, Object target) throws SuperException {
        return ReflectUtil.helperFieldGet(field, target, null);
    }

    public static <T> T helperFieldGet(String field, Object target, Class<T> fieldClass) throws SuperException {
        Field field2;
        if (StringUtils.isEmpty((String)field) || null == target) {
            return null;
        }
        try {
            field2 = target.getClass().getDeclaredField(field);
        }
        catch (Exception exception) {
            LOGGER.error("can not inject the field. name:{}", (Object)field);
            LOGGER.error("exception:", (Throwable)exception);
            throw ErrorsDiscriptor.InternalService.e(exception);
        }
        return ReflectUtil.helperFieldGet(field2, target, fieldClass);
    }

    public static <T> T helperFieldGet(Field field, Object target, Class<T> fieldClass) throws SuperException {
        if (null == field || null == target) {
            return null;
        }
        boolean bl2 = field.isAccessible();
        if (!bl2) {
            field.setAccessible(true);
        }
        try {
            Object object;
            Object object2 = field.get(target);
            if (null == object2) {
                T t2 = null;
                return t2;
            }
            if (null != fieldClass && !fieldClass.isAssignableFrom(object2.getClass())) {
                LOGGER.error("argument type not matched. type:{}, need:{}", object2.getClass(), fieldClass);
                throw ErrorsDiscriptor.NotmatchArgumentType.e();
            }
            Object object3 = object = object2;
            return (T)object3;
        }
        catch (Exception exception) {
            LOGGER.error("can not inject the field. name:{}", (Object)field.getName());
            LOGGER.error("exception:", (Throwable)exception);
            throw ErrorsDiscriptor.InternalService.e(exception);
        }
        finally {
            field.setAccessible(bl2);
        }
    }
}

