/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.security.cipher;

import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import esign.utils.security.cipher.impl.ISignerProviderFactory;
import esign.utils.security.cipher.impl.ISimSignerProvider;
import esign.utils.security.cipher.impl.adapter.DigestModelAdapter;
import esign.utils.security.cipher.impl.adapter.SignModelAdapter;
import esign.utils.security.cipher.impl.sign.rsa.RSASignerProvider;
import esign.utils.security.model.AsymmetricAlgorithmModel;
import esign.utils.security.model.DigestAlgorithmModel;

public enum AsymmetricSignerProviderFactory {
    RSA(AsymmetricAlgorithmModel.RSA){

        @Override
        protected ISimSignerProvider create(String algorithm, String algorithmFully) throws SuperException {
            return new RSASignerProvider(algorithm, algorithmFully);
        }
    }
    ,
    DSA(AsymmetricAlgorithmModel.DSA){

        @Override
        protected ISimSignerProvider create(String algorithm, String algorithmFully) throws SuperException {
            throw ErrorsDiscriptor.NotImplement.e();
        }
    }
    ,
    ECDSA(null){

        @Override
        protected ISimSignerProvider create(String algorithm, String algorithmFully) throws SuperException {
            throw ErrorsDiscriptor.NotImplement.e();
        }
    };

    private AsymmetricAlgorithmModel algorithmModel;

    private AsymmetricSignerProviderFactory(AsymmetricAlgorithmModel algorithmModel) {
        this.algorithmModel = algorithmModel;
    }

    protected abstract ISimSignerProvider create(String var1, String var2) throws SuperException;

    public ISignerProviderFactory factory(DigestAlgorithmModel digestAlg) {
        String string = SignModelAdapter.from(this.algorithmModel).algorithm();
        String string2 = this.discription(digestAlg);
        return new SignerProviderFactory(this, string, string2);
    }

    private String discription(DigestAlgorithmModel digestAlg) {
        return DigestModelAdapter.from(digestAlg).algorithm() + "with" + SignModelAdapter.from(this.algorithmModel).algorithm();
    }

    private class SignerProviderFactory
    implements ISignerProviderFactory {
        private String algorithmFully;
        private String algorithm;
        private AsymmetricSignerProviderFactory factory;

        protected SignerProviderFactory(AsymmetricSignerProviderFactory factory, String algorithm, String algorithmFully) {
            this.algorithmFully = algorithmFully;
            this.algorithm = algorithm;
            this.factory = factory;
        }

        @Override
        public ISimSignerProvider create() throws SuperException {
            return this.factory.create(this.algorithm, this.algorithmFully);
        }
    }
}

