/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.base;

import com.timevale.guava.common.annotations.Beta;
import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.annotations.GwtIncompatible;
import com.timevale.guava.common.base.CharMatcher;
import com.timevale.guava.common.base.Preconditions;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;

@GwtCompatible(emulated=true)
public final class Splitter {
    private final CharMatcher trimmer;
    private final boolean omitEmptyStrings;
    private final Strategy strategy;
    private final int limit;

    private Splitter(Strategy strategy) {
        this(strategy, false, CharMatcher.NONE, Integer.MAX_VALUE);
    }

    private Splitter(Strategy strategy, boolean omitEmptyStrings, CharMatcher trimmer, int limit) {
        this.strategy = strategy;
        this.omitEmptyStrings = omitEmptyStrings;
        this.trimmer = trimmer;
        this.limit = limit;
    }

    public static Splitter on(char separator) {
        return Splitter.on(CharMatcher.is(separator));
    }

    public static Splitter on(final CharMatcher separatorMatcher) {
        Preconditions.checkNotNull(separatorMatcher);
        return new Splitter(new Strategy(){

            public SplittingIterator iterator(Splitter splitter, CharSequence toSplit) {
                return new SplittingIterator(splitter, toSplit){

                    @Override
                    int separatorStart(int start) {
                        return separatorMatcher.indexIn(this.toSplit, start);
                    }

                    @Override
                    int separatorEnd(int separatorPosition) {
                        return separatorPosition + 1;
                    }
                };
            }
        });
    }

    public static Splitter on(final String separator) {
        Preconditions.checkArgument(separator.length() != 0, "The separator may not be the empty string.");
        return new Splitter(new Strategy(){

            public SplittingIterator iterator(Splitter splitter, CharSequence toSplit) {
                return new SplittingIterator(splitter, toSplit){

                    @Override
                    public int separatorStart(int start) {
                        int n2 = separator.length();
                        int n3 = this.toSplit.length() - n2;
                        block0: for (int i2 = start; i2 <= n3; ++i2) {
                            for (int i3 = 0; i3 < n2; ++i3) {
                                if (this.toSplit.charAt(i3 + i2) != separator.charAt(i3)) continue block0;
                            }
                            return i2;
                        }
                        return -1;
                    }

                    @Override
                    public int separatorEnd(int separatorPosition) {
                        return separatorPosition + separator.length();
                    }
                };
            }
        });
    }

    @GwtIncompatible(value="java.util.regex")
    public static Splitter on(final Pattern separatorPattern) {
        Preconditions.checkNotNull(separatorPattern);
        Preconditions.checkArgument(!separatorPattern.matcher("").matches(), "The pattern may not match the empty string: %s", separatorPattern);
        return new Splitter(new Strategy(){

            public SplittingIterator iterator(Splitter splitter, CharSequence toSplit) {
                final Matcher matcher = separatorPattern.matcher(toSplit);
                return new SplittingIterator(splitter, toSplit){

                    @Override
                    public int separatorStart(int start) {
                        return matcher.find(start) ? matcher.start() : -1;
                    }

                    @Override
                    public int separatorEnd(int separatorPosition) {
                        return matcher.end();
                    }
                };
            }
        });
    }

    @GwtIncompatible(value="java.util.regex")
    public static Splitter onPattern(String separatorPattern) {
        return Splitter.on(Pattern.compile(separatorPattern));
    }

    public static Splitter fixedLength(final int length) {
        Preconditions.checkArgument(length > 0, "The length may not be less than 1");
        return new Splitter(new Strategy(){

            public SplittingIterator iterator(Splitter splitter, CharSequence toSplit) {
                return new SplittingIterator(splitter, toSplit){

                    @Override
                    public int separatorStart(int start) {
                        int n2 = start + length;
                        return n2 < this.toSplit.length() ? n2 : -1;
                    }

                    @Override
                    public int separatorEnd(int separatorPosition) {
                        return separatorPosition;
                    }
                };
            }
        });
    }

    @CheckReturnValue
    public Splitter omitEmptyStrings() {
        return new Splitter(this.strategy, true, this.trimmer, this.limit);
    }

    @CheckReturnValue
    public Splitter limit(int limit) {
        Preconditions.checkArgument(limit > 0, "must be greater then zero: %s", limit);
        return new Splitter(this.strategy, this.omitEmptyStrings, this.trimmer, limit);
    }

    @CheckReturnValue
    public Splitter trimResults() {
        return this.trimResults(CharMatcher.WHITESPACE);
    }

    @CheckReturnValue
    public Splitter trimResults(CharMatcher trimmer) {
        Preconditions.checkNotNull(trimmer);
        return new Splitter(this.strategy, this.omitEmptyStrings, trimmer, this.limit);
    }

    public Iterable<String> split(final CharSequence sequence) {
        Preconditions.checkNotNull(sequence);
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return Splitter.this.spliterator(sequence);
            }
        };
    }

    private Iterator<String> spliterator(CharSequence sequence) {
        return this.strategy.iterator(this, sequence);
    }

    @CheckReturnValue
    @Beta
    public MapSplitter withKeyValueSeparator(String separator) {
        return this.withKeyValueSeparator(Splitter.on(separator));
    }

    @CheckReturnValue
    @Beta
    public MapSplitter withKeyValueSeparator(Splitter keyValueSplitter) {
        return new MapSplitter(this, keyValueSplitter);
    }

    private static abstract class AbstractIterator<T>
    implements Iterator<T> {
        State state = State.NOT_READY;
        T next;

        private AbstractIterator() {
        }

        protected abstract T computeNext();

        protected final T endOfData() {
            this.state = State.DONE;
            return null;
        }

        @Override
        public final boolean hasNext() {
            Preconditions.checkState(this.state != State.FAILED);
            switch (this.state) {
                case DONE: {
                    return false;
                }
                case READY: {
                    return true;
                }
            }
            return this.tryToComputeNext();
        }

        boolean tryToComputeNext() {
            this.state = State.FAILED;
            this.next = this.computeNext();
            if (this.state != State.DONE) {
                this.state = State.READY;
                return true;
            }
            return false;
        }

        @Override
        public final T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.state = State.NOT_READY;
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        static enum State {
            READY,
            NOT_READY,
            DONE,
            FAILED;

        }
    }

    private static abstract class SplittingIterator
    extends AbstractIterator<String> {
        final CharSequence toSplit;
        final CharMatcher trimmer;
        final boolean omitEmptyStrings;
        int offset = 0;
        int limit;

        abstract int separatorStart(int var1);

        abstract int separatorEnd(int var1);

        protected SplittingIterator(Splitter splitter, CharSequence toSplit) {
            this.trimmer = splitter.trimmer;
            this.omitEmptyStrings = splitter.omitEmptyStrings;
            this.limit = splitter.limit;
            this.toSplit = toSplit;
        }

        @Override
        protected String computeNext() {
            while (this.offset != -1) {
                int n2;
                int n3 = this.offset;
                int n4 = this.separatorStart(this.offset);
                if (n4 == -1) {
                    n2 = this.toSplit.length();
                    this.offset = -1;
                } else {
                    n2 = n4;
                    this.offset = this.separatorEnd(n4);
                }
                while (n3 < n2 && this.trimmer.matches(this.toSplit.charAt(n3))) {
                    ++n3;
                }
                while (n2 > n3 && this.trimmer.matches(this.toSplit.charAt(n2 - 1))) {
                    --n2;
                }
                if (this.omitEmptyStrings && n3 == n2) continue;
                if (this.limit == 1) {
                    this.offset = -1;
                    for (n2 = this.toSplit.length(); n2 > n3 && this.trimmer.matches(this.toSplit.charAt(n2 - 1)); --n2) {
                    }
                } else {
                    --this.limit;
                }
                return ((Object)this.toSplit.subSequence(n3, n2)).toString();
            }
            return (String)this.endOfData();
        }
    }

    private static interface Strategy {
        public Iterator<String> iterator(Splitter var1, CharSequence var2);
    }

    @Beta
    public static final class MapSplitter {
        private static final String INVALID_ENTRY_MESSAGE = "Chunk [%s] is not a valid entry";
        private final Splitter outerSplitter;
        private final Splitter entrySplitter;

        private MapSplitter(Splitter outerSplitter, Splitter entrySplitter) {
            this.outerSplitter = outerSplitter;
            this.entrySplitter = Preconditions.checkNotNull(entrySplitter);
        }

        public Map<String, String> split(CharSequence sequence) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (String string : this.outerSplitter.split(sequence)) {
                Iterator iterator = this.entrySplitter.spliterator(string);
                Preconditions.checkArgument(iterator.hasNext(), INVALID_ENTRY_MESSAGE, string);
                String string2 = (String)iterator.next();
                Preconditions.checkArgument(!linkedHashMap.containsKey(string2), "Duplicate key [%s] found.", string2);
                Preconditions.checkArgument(iterator.hasNext(), INVALID_ENTRY_MESSAGE, string);
                String string3 = (String)iterator.next();
                linkedHashMap.put(string2, string3);
                Preconditions.checkArgument(!iterator.hasNext(), INVALID_ENTRY_MESSAGE, string);
            }
            return Collections.unmodifiableMap(linkedHashMap);
        }
    }
}

