/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.service.a;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import com.timevale.service.CertOptService;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERIA5String;
import com.timevale.tgtext.bouncycastle.asn1.DERObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.CRLDistPoint;
import com.timevale.tgtext.bouncycastle.asn1.x509.DistributionPoint;
import com.timevale.tgtext.bouncycastle.asn1.x509.DistributionPointName;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralNames;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509CertificateStructure;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509Extension;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509Extensions;
import com.timevale.utils.CertUtil;
import com.timevale.utils.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;

public class a
implements CertOptService {
    private static final String LW = "1.2.840.113549.1.1";
    private static final String LX = "SM2";
    private static final String LY = "RSA";
    private static final String LZ = "ZJCA";
    private static final String Ma = "HBCA";
    private static final String Mb = "1.2.86.11.7.4";
    private static final String Mc = "1.2.156.112578.1";
    private static final String Md = "1.2.156.10260.4.1.1";

    @Override
    public com.timevale.a.a.a getCertInfo(String certBase64) {
        com.timevale.a.a.a a2 = new com.timevale.a.a.a();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.decode(certBase64));
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            X509CertificateStructure x509CertificateStructure = new X509CertificateStructure(aSN1Sequence);
            a2.setSerialNumber(x509CertificateStructure.getSerialNumber().getValue().toString(16));
            a2.setVersion(x509CertificateStructure.getVersion() + "");
            a2.setIssue(x509CertificateStructure.getIssuer().toString());
            a2.setSubject(x509CertificateStructure.getSubject().toString());
            a2.setStartTime(x509CertificateStructure.getStartDate().getDate());
            a2.setEndTime(x509CertificateStructure.getEndDate().getDate());
            Map<String, String> map = CertUtil.getMapFromDn(x509CertificateStructure.getIssuer().toString());
            a2.setIssue_cn(map.get("CN") == null ? "" : map.get("CN"));
            a2.setIssue_email(map.get("EMAIL") == null ? "" : map.get("EMAIL"));
            a2.setIssue_givenname(map.get("GIVENNAME") == null ? "" : map.get("GIVENNAME"));
            a2.setIssue_ou(map.get("OU") == null ? "" : map.get("OU"));
            a2.setIssue_c(map.get("C") == null ? "" : map.get("C"));
            a2.setIssue_o(map.get("O") == null ? "" : map.get("O"));
            a2.setIssue_l(map.get("L") == null ? "" : map.get("L"));
            a2.setIssue_s(map.get("ST") == null ? "" : map.get("ST"));
            Map<String, String> map2 = CertUtil.getMapFromDn(x509CertificateStructure.getSubject().toString());
            a2.setSubject_cn(map2.get("CN"));
            a2.setSubject_email(map2.get("EMAIL") == null ? "" : map2.get("EMAIL"));
            a2.setSubject_phone(map2.get("TelephoneNumber") == null ? "" : map2.get("TelephoneNumber"));
            a2.setSubject_givenname(map2.get("GIVENNAME") == null ? "" : map2.get("GIVENNAME"));
            a2.setSubject_ou(map2.get("OU") == null ? "" : map2.get("OU"));
            a2.setSubject_c(map2.get("C") == null ? "" : map2.get("C"));
            a2.setSubject_o(map2.get("O") == null ? "" : map2.get("O"));
            a2.setSubject_l(map2.get("L") == null ? "" : map2.get("L"));
            a2.setSubject_s(map2.get("ST") == null ? "" : map2.get("ST"));
            a2.setSignalg(x509CertificateStructure.getSignatureAlgorithm().getAlgorithm().getId());
            if (a2.getSignalg().indexOf(LW) < 0) {
                a2.setAlgorithm(LX);
            }
            a2.setPubkey(Base64.encode(x509CertificateStructure.getSubjectPublicKeyInfo().getPublicKeyData().getBytes()));
            X509Extensions x509Extensions = x509CertificateStructure.getTBSCertificate().getExtensions();
            a2.setExt_crldistributionpo(a.getCrlDistributionPoints(x509Extensions));
            a2.setHash(this.a(x509Extensions, a2));
            return a2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private String a(X509Extensions x509Extensions, com.timevale.a.a.a a2) {
        String string = "";
        if (a2.getIssue_cn().indexOf(Ma) >= 0 && a2.getAlgorithm().equals(LY)) {
            string = new String(a.getExtensionBytes(Mb, x509Extensions));
        } else if (a2.getIssue_cn().indexOf(Ma) >= 0 && a2.getAlgorithm().equals(LX)) {
            string = new String(a.getExtensionBytes(Md, x509Extensions));
        } else if (a2.getIssue_cn().indexOf(LZ) >= 0) {
            string = new String(a.getExtensionBytes(Mc, x509Extensions));
        }
        return string;
    }

    private static String getCrlDistributionPoints(X509Extensions ext) throws IOException {
        String string = "";
        byte[] byArray = a.getExtensionBytes(X509Extensions.CRLDistributionPoints.getId(), ext);
        if (byArray == null || StringUtil.isNull(new String(byArray))) {
            return string;
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byArray));
        byte[] byArray2 = aSN1InputStream.readObject().getEncoded();
        ASN1InputStream aSN1InputStream2 = new ASN1InputStream(new ByteArrayInputStream(byArray2));
        CRLDistPoint cRLDistPoint = CRLDistPoint.getInstance(aSN1InputStream2.readObject());
        for (DistributionPoint distributionPoint : cRLDistPoint.getDistributionPoints()) {
            DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
            if (distributionPointName == null || distributionPointName.getType() != 0) continue;
            GeneralName[] generalNameArray = GeneralNames.getInstance(distributionPointName.getName()).getNames();
            for (int i2 = 0; i2 < generalNameArray.length; ++i2) {
                if (generalNameArray[i2].getTagNo() != 6) continue;
                String string2 = DERIA5String.getInstance(generalNameArray[i2].getName()).getString();
                string = string + string2;
            }
        }
        return string;
    }

    private static byte[] getExtensionBytes(String oid, X509Extensions exts) {
        X509Extension x509Extension;
        if (exts != null && (x509Extension = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
            return x509Extension.getValue().getOctets();
        }
        return "".getBytes();
    }
}

