/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tech.sdk.utils;

import com.timevale.tech.sdk.seal.DefaultFontLoader;
import com.timevale.tech.sdk.seal.IFontsLoader;
import esign.utils.JsonHelper;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontUtil {
    private static final Logger LOGGER;
    private static final String EXT_FONTMANAGER_CLASS = "com.timevale.esign.ext.sdk.seal.ExtFontLoader";
    private static boolean isExtFont;
    private static Class<? extends IFontsLoader> concretLoader;
    private static final Set<String> avaliableFontsSet;

    public static boolean existExtFontJar() {
        return isExtFont;
    }

    public static Font getFont(String fontName, int style, float size) {
        try {
            IFontsLoader iFontsLoader = concretLoader.newInstance();
            return iFontsLoader.getFont(fontName, style, size);
        }
        catch (Exception exception) {
            LOGGER.error("get font laoder failed. exception:", (Throwable)exception);
            Font font = new JLabel().getFont().deriveFont(style, size);
            return font;
        }
    }

    public static byte[] getFontBytes(String fontName) {
        try {
            IFontsLoader iFontsLoader = concretLoader.newInstance();
            byte[] byArray = iFontsLoader.getFontBytes(fontName);
            if (byArray == null || byArray.length == 0) {
                LOGGER.error("font:{} byte array is empty", (Object)fontName);
            }
            return byArray;
        }
        catch (Exception exception) {
            LOGGER.error("get font byte array failed. exception:", (Throwable)exception);
            return null;
        }
    }

    public static boolean isFontAvilable(String fontName) {
        return avaliableFontsSet.contains(fontName.toLowerCase());
    }

    public static byte[] fontBytes(String uri) throws SuperException {
        InputStream inputStream = null;
        try {
            inputStream = FontUtil.class.getResourceAsStream(uri);
            byte[] byArray = FontUtil.read(inputStream);
            return byArray;
        }
        catch (Exception exception) {
            LOGGER.error("\u5b57\u4f53\u5305\u52a0\u8f7d\u5f02\u5e38,uri {}", (Object)uri);
            throw ErrorsDiscriptor.direct(40001, "\u5b57\u4f53\u5305\u52a0\u8f7d\u5931\u8d25");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static byte[] read(InputStream stream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(stream);
        byte[] byArray = new byte[bufferedInputStream.available()];
        bufferedInputStream.read(byArray);
        return byArray;
    }

    static {
        Object[] objectArray;
        Object object;
        LOGGER = LoggerFactory.getLogger(FontUtil.class);
        isExtFont = false;
        avaliableFontsSet = new HashSet<String>();
        try {
            object = Class.forName(EXT_FONTMANAGER_CLASS);
            objectArray = ((Class)object).getInterfaces();
            for (Class<?> clazz : objectArray) {
                if (!clazz.equals(IFontsLoader.class)) continue;
                concretLoader = object;
                isExtFont = true;
                break;
            }
            if (null == concretLoader) {
                concretLoader = DefaultFontLoader.class;
                isExtFont = false;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.warn("no class found named: {} ", (Object)EXT_FONTMANAGER_CLASS);
            concretLoader = DefaultFontLoader.class;
            isExtFont = false;
        }
        object = GraphicsEnvironment.getLocalGraphicsEnvironment();
        objectArray = ((GraphicsEnvironment)object).getAvailableFontFamilyNames();
        LOGGER.info("find system preset avaliable fonts: {} ", (Object)JsonHelper.toJson(objectArray));
        for (Object object2 : objectArray) {
            avaliableFontsSet.add(((String)object2).toLowerCase());
        }
    }
}

