/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ApplicationSpecific;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OutputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ParsingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class BERApplicationSpecific
extends ASN1ApplicationSpecific {
    BERApplicationSpecific(boolean bl2, int n2, byte[] byArray) {
        super(bl2, n2, byArray);
    }

    public BERApplicationSpecific(int n2, ASN1Encodable aSN1Encodable) throws IOException {
        this(true, n2, aSN1Encodable);
    }

    public BERApplicationSpecific(boolean bl2, int n2, ASN1Encodable aSN1Encodable) throws IOException {
        super(bl2 || aSN1Encodable.toASN1Primitive().isConstructed(), n2, BERApplicationSpecific.getEncoding(bl2, aSN1Encodable));
    }

    private static byte[] getEncoding(boolean bl2, ASN1Encodable aSN1Encodable) throws IOException {
        byte[] byArray = aSN1Encodable.toASN1Primitive().getEncoded("BER");
        if (bl2) {
            return byArray;
        }
        int n2 = BERApplicationSpecific.getLengthOfHeader(byArray);
        byte[] byArray2 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public BERApplicationSpecific(int n2, ASN1EncodableVector aSN1EncodableVector) {
        super(true, n2, BERApplicationSpecific.getEncodedVector(aSN1EncodableVector));
    }

    private static byte[] getEncodedVector(ASN1EncodableVector aSN1EncodableVector) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 != aSN1EncodableVector.size(); ++i2) {
            try {
                byteArrayOutputStream.write(((ASN1Object)aSN1EncodableVector.get(i2)).getEncoded("BER"));
                continue;
            }
            catch (IOException iOException) {
                throw new ASN1ParsingException("malformed object: " + iOException, iOException);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        int n2 = 64;
        if (this.isConstructed) {
            n2 |= 0x20;
        }
        aSN1OutputStream.writeTag(n2, this.tag);
        aSN1OutputStream.write(128);
        aSN1OutputStream.write(this.octets);
        aSN1OutputStream.write(0);
        aSN1OutputStream.write(0);
    }
}

