/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.text;

import com.timevale.tgtext.text.pdf.draw.DrawInterface;

public class TabStop {
    protected float abj;
    protected Alignment abk = Alignment.LEFT;
    protected DrawInterface abl;
    protected char abm = (char)46;

    public static TabStop l(float f2, float f3) {
        f2 = (float)Math.round(f2 * 1000.0f) / 1000.0f;
        f3 = (float)Math.round(f3 * 1000.0f) / 1000.0f;
        TabStop tabStop = new TabStop(f2 + f3 - f2 % f3);
        return tabStop;
    }

    public TabStop(float position) {
        this(position, Alignment.LEFT);
    }

    public TabStop(float position, DrawInterface leader) {
        this(position, leader, Alignment.LEFT);
    }

    public TabStop(float position, Alignment alignment) {
        this(position, null, alignment);
    }

    public TabStop(float position, Alignment alignment, char anchorChar) {
        this(position, null, alignment, anchorChar);
    }

    public TabStop(float position, DrawInterface leader, Alignment alignment) {
        this(position, leader, alignment, '.');
    }

    public TabStop(float position, DrawInterface leader, Alignment alignment, char anchorChar) {
        this.abj = position;
        this.abl = leader;
        this.abk = alignment;
        this.abm = anchorChar;
    }

    public TabStop(TabStop tabStop) {
        this(tabStop.DR(), tabStop.DT(), tabStop.DS(), tabStop.DU());
    }

    public float DR() {
        return this.abj;
    }

    public void an(float f2) {
        this.abj = f2;
    }

    public Alignment DS() {
        return this.abk;
    }

    public void a(Alignment alignment) {
        this.abk = alignment;
    }

    public DrawInterface DT() {
        return this.abl;
    }

    public void a(DrawInterface drawInterface) {
        this.abl = drawInterface;
    }

    public char DU() {
        return this.abm;
    }

    public void k(char c2) {
        this.abm = c2;
    }

    public float a(float f2, float f3, float f4) {
        float f5 = this.abj;
        float f6 = f3 - f2;
        switch (this.abk) {
            case RIGHT: {
                if (f2 + f6 < this.abj) {
                    f5 = this.abj - f6;
                    break;
                }
                f5 = f2;
                break;
            }
            case CENTER: {
                if (f2 + f6 / 2.0f < this.abj) {
                    f5 = this.abj - f6 / 2.0f;
                    break;
                }
                f5 = f2;
                break;
            }
            case ANCHOR: {
                if (!Float.isNaN(f4)) {
                    if (f4 < this.abj) {
                        f5 = this.abj - (f4 - f2);
                        break;
                    }
                    f5 = f2;
                    break;
                }
                f5 = f2 + f6 < this.abj ? this.abj - f6 : f2;
            }
        }
        return f5;
    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER,
        ANCHOR;

    }
}

