/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.security.cipher.impl.cipher.rsa;

import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import esign.utils.security.cipher.CipherProgress;
import esign.utils.security.cipher.impl.DefaultCipherProgress;
import esign.utils.security.cipher.impl.ICipherProvider;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.interfaces.RSAKey;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSACipherProvider
implements ICipherProvider {
    private Key key;
    private Cipher cipher;
    private static final Logger LOGGER = LoggerFactory.getLogger(RSACipherProvider.class);

    public RSACipherProvider(String algorithm) throws SuperException {
        this.cipher = this.createCipher(algorithm);
    }

    @Override
    public ICipherProvider init(Key key) throws SuperException {
        this.key = key;
        return this;
    }

    @Override
    public ICipherProvider init(byte[] key) throws SuperException {
        return this;
    }

    @Override
    public byte[] encrypt(byte[] plaintext) throws SuperException {
        return this.encrypt(plaintext, new DefaultCipherProgress());
    }

    @Override
    public byte[] decrypt(byte[] ciphertext) throws SuperException {
        return this.decrypt(ciphertext, new DefaultCipherProgress());
    }

    @Override
    public byte[] encrypt(byte[] plaintext, CipherProgress progress) throws SuperException {
        this.initCipher(this.cipher, true);
        int n2 = this.getBlock((RSAKey)((Object)this.key));
        int n3 = n2 - 11;
        int n4 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            while (n4 < plaintext.length) {
                int n5 = plaintext.length - n4 > n3 ? n3 : plaintext.length - n4;
                byte[] byArray = this.cipher.doFinal(plaintext, n4, n5);
                byteArrayOutputStream.write(byArray);
                progress.progress(plaintext.length, n4 += n3);
            }
        }
        catch (Exception exception) {
            LOGGER.error("encyprt failed.", (Throwable)exception);
            throw ErrorsDiscriptor.FailureCipherEncryption.e(exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public byte[] decrypt(byte[] ciphertext, CipherProgress progress) throws SuperException {
        this.initCipher(this.cipher, false);
        int n2 = this.getBlock((RSAKey)((Object)this.key));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        try {
            while (n3 < ciphertext.length) {
                int n4 = ciphertext.length - n3 > n2 ? n2 : ciphertext.length - n3;
                byte[] byArray = this.cipher.doFinal(ciphertext, n3, n4);
                byteArrayOutputStream.write(byArray);
                progress.progress(ciphertext.length, n3 += n4);
            }
        }
        catch (Exception exception) {
            LOGGER.error("decrypt failed.", (Throwable)exception);
            throw ErrorsDiscriptor.FailureCipherEncryption.e(exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private int getBlock(RSAKey key) {
        return key.getModulus().bitLength() / 8;
    }

    private void initCipher(Cipher cipher, boolean encryption) throws SuperException {
        int n2 = encryption ? 1 : 2;
        try {
            cipher.init(n2, this.key);
        }
        catch (InvalidKeyException invalidKeyException) {
            LOGGER.error("init cipher failed.", (Throwable)invalidKeyException);
            throw ErrorsDiscriptor.InvalidCipherKey.e(invalidKeyException);
        }
    }

    private Cipher createCipher(String algorithm) throws SuperException {
        try {
            return Cipher.getInstance(algorithm);
        }
        catch (Exception exception) {
            LOGGER.error("create ciphter failed. algorithm:{}", (Object)algorithm);
            LOGGER.error("exception:", (Throwable)exception);
            throw ErrorsDiscriptor.InvalidCipherAlgorithm.e(exception);
        }
    }
}

