/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.network;

import com.timevale.esign.paas.esign.utils.network.NtmRouteConfig;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NtmPoolConfigManager {
    private Map<String, NtmRouteConfig> routeManager = new ConcurrentHashMap<String, NtmRouteConfig>();
    private Integer maxTotalConnection;
    private Integer defaultMaxPerRouteConnection;

    public NtmPoolConfigManager add(NtmRouteConfig config) {
        String string = config.getHost().toHostURI();
        this.routeManager.put(string, config);
        return this;
    }

    public NtmPoolConfigManager setDefaultMaxPerRouteConnection(Integer defaultMaxPerRouteConnection) {
        this.defaultMaxPerRouteConnection = defaultMaxPerRouteConnection;
        return this;
    }

    public NtmPoolConfigManager setMaxTotalConnection(Integer maxConnection) {
        this.maxTotalConnection = maxConnection;
        return this;
    }

    public Collection<NtmRouteConfig> getAllRoutes() {
        return this.routeManager.values();
    }

    public Integer getMaxTotalConnection() {
        return this.maxTotalConnection;
    }

    public Integer getDefaultMaxPerRouteConnection() {
        return this.defaultMaxPerRouteConnection;
    }

    public String print() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.print("maxTotalConnection", this.maxTotalConnection));
        stringBuilder.append(this.print("defaultMaxPerRouteConnection", this.defaultMaxPerRouteConnection));
        Collection<NtmRouteConfig> collection = this.getAllRoutes();
        stringBuilder.append(this.print("routes", collection.size()));
        for (NtmRouteConfig ntmRouteConfig : collection) {
            stringBuilder.append(this.print("routeConnection", ntmRouteConfig.getHost().toHostURI(), ntmRouteConfig.getMaxConnection()));
        }
        return stringBuilder.toString();
    }

    private String print(String name, int value) {
        return String.format("\r\nset connection pool. [%s] => %d", name, value);
    }

    private String print(String name, String subname, int value) {
        return String.format("\r\nset connection pool. [%s-%s] => %d", name, subname, value);
    }
}

