/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.security;

import com.timevale.esign.paas.esign.utils.Base64;
import com.timevale.esign.paas.esign.utils.ca.fisherman.FMSYS;
import com.timevale.esign.paas.esign.utils.exception.ErrorsDiscriptor;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.esign.utils.security.MessageDigestUtil;
import com.timevale.esign.paas.esign.utils.security.provider.DigestProivder;
import com.timevale.esign.paas.esign.utils.security.provider.Provider;
import com.timevale.esign.paas.esign.utils.security.verify.VerifyResult;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.x509.X509Name;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.jcajce.JcaCertStore;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSAlgorithm;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSEnvelopedData;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSEnvelopedDataGenerator;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSException;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSProcessableByteArray;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSSignedData;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSSignedDataGenerator;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.SignerInformation;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.SignerInformationStore;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import com.timevale.esign.paas.tgtext.bouncycastle.jce.PKCS10CertificationRequest;
import com.timevale.esign.paas.tgtext.bouncycastle.util.Store;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftKeyTool {
    private PrivateKey privateKey = null;
    private PublicKey publicKey = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(SoftKeyTool.class);

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public KeyPairGenerator generateKey() {
        KeyPairGenerator keyPairGenerator = null;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048, new SecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            this.publicKey = keyPair.getPublic();
            this.privateKey = keyPair.getPrivate();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return keyPairGenerator;
    }

    public byte[] generatePKCS10(String cn2, String ou, String o2, String l2, String st, String c2) throws Exception {
        byte[] byArray = null;
        KeyPairGenerator keyPairGenerator = this.generateKey();
        if (null != keyPairGenerator) {
            String string = "CN=" + cn2 + ",OU=" + ou + ",O=" + o2 + ",L=" + l2 + ",ST=" + st + ",C=" + c2;
            PKCS10CertificationRequest pKCS10CertificationRequest = new PKCS10CertificationRequest("MD5WithRSA", new X509Name(string), this.publicKey, null, this.privateKey);
            byArray = pKCS10CertificationRequest.getEncoded();
        }
        return byArray;
    }

    public static Certificate getCertFromFile(String fp2) {
        Certificate certificate = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(fp2);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            while (fileInputStream.available() > 0) {
                certificate = certificateFactory.generateCertificate(fileInputStream);
            }
            return certificate;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return certificate;
        }
    }

    public static String getInfoFromDn(String dn2, String key) {
        String string = "";
        String[] stringArray = dn2.split(",");
        if (stringArray.length > 0) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = stringArray[i2].trim();
                if (!stringArray[i2].contains(key.toUpperCase() + "=")) continue;
                string = stringArray[i2].substring(stringArray[i2].indexOf(key.toUpperCase()) + key.length() + 1, stringArray[i2].length());
            }
        }
        return string;
    }

    public byte[] SymEncrypt(String keyalg, byte[] keybytes, byte[] indata, byte[] iv) {
        byte[] byArray = null;
        try {
            FMSYS fMSYS = new FMSYS("BC");
            SecretKey secretKey = fMSYS.generatekey(keybytes, keyalg);
            if (secretKey != null) {
                byArray = fMSYS.sysenc(secretKey, keyalg.split("/").length >= 2 ? keyalg.split("/")[1] : "CBC", true, indata, iv);
            }
            return byArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public byte[] SymDecrypt(String keyalg, byte[] keybytes, byte[] indata, byte[] iv) {
        byte[] byArray = null;
        try {
            FMSYS fMSYS = new FMSYS("BC");
            SecretKey secretKey = fMSYS.generatekey(keybytes, keyalg);
            if (secretKey != null) {
                byArray = fMSYS.sysdec(secretKey, keyalg.split("/").length >= 2 ? keyalg.split("/")[1] : "CBC", true, indata, iv);
            }
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static VerifyResult verifySignedDataByP7(byte[] signedData) {
        VerifyResult verifyResult = new VerifyResult();
        verifyResult.setVerifies(true);
        try {
            CMSSignedData cMSSignedData = new CMSSignedData(signedData);
            Store<X509CertificateHolder> store = cMSSignedData.getCertificates();
            SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
            Collection<SignerInformation> collection = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection) {
                Collection<X509CertificateHolder> collection2 = store.getMatches(signerInformation.getSID());
                Iterator<X509CertificateHolder> iterator = collection2.iterator();
                X509CertificateHolder x509CertificateHolder = iterator.next();
                boolean bl2 = signerInformation.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(x509CertificateHolder));
                verifyResult.add(x509CertificateHolder, bl2);
            }
        }
        catch (Exception exception) {
            LOGGER.error("verify failed.", (Throwable)exception);
            verifyResult.setVerifies(false);
        }
        return verifyResult;
    }

    @Deprecated
    public static VerifyResult verifySignedDataByP7(byte[] signedData, byte[] orignData, DigestProivder digest) {
        byte[] byArray;
        byte[] byArray2 = MessageDigestUtil.INSTANCE.digest(orignData, digest);
        if (!Arrays.equals(byArray2, byArray = SoftKeyTool.GetP7SignDataInfo(signedData))) {
            LOGGER.debug("orign data is not mathced with data in pkcs7.");
            return new VerifyResult();
        }
        return SoftKeyTool.verifySignedDataByP7(signedData);
    }

    public static VerifyResult verifyPKCS7(byte[] signedData, byte[] orignData, DigestProivder digest) throws SuperException {
        byte[] byArray;
        byte[] byArray2 = MessageDigestUtil.INSTANCE.digest(orignData, digest);
        if (!Arrays.equals(byArray2, byArray = SoftKeyTool.getP7SignDataInfo(signedData))) {
            LOGGER.debug("orign data is not mathced with data in pkcs7.");
            return new VerifyResult();
        }
        return SoftKeyTool.verifySignedDataByP7(signedData);
    }

    private static byte[] GetP7SignDataInfo(byte[] signedData) {
        try {
            CMSSignedData cMSSignedData = new CMSSignedData(signedData);
            CMSProcessableByteArray cMSProcessableByteArray = (CMSProcessableByteArray)cMSSignedData.getSignedContent();
            return (byte[])cMSProcessableByteArray.getContent();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static byte[] getP7SignDataInfo(byte[] signedData) throws SuperException {
        CMSSignedData cMSSignedData;
        try {
            cMSSignedData = new CMSSignedData(signedData);
        }
        catch (CMSException cMSException) {
            LOGGER.error("invalid data for pkcs7.", (Throwable)cMSException);
            throw ErrorsDiscriptor.InvalidSignatureForPKCS7.e();
        }
        CMSProcessableByteArray cMSProcessableByteArray = (CMSProcessableByteArray)cMSSignedData.getSignedContent();
        return (byte[])cMSProcessableByteArray.getContent();
    }

    public byte[] SignDataByP7(byte[] plaintxt, byte[] keybytes, byte[] certbytes, String signalg) {
        try {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(keybytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            Signature signature = Signature.getInstance("RSA");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certbytes);
            Certificate certificate = null;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            while (((InputStream)byteArrayInputStream).available() > 0) {
                certificate = certificateFactory.generateCertificate(byteArrayInputStream);
            }
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
            arrayList.add(certificate);
            JcaCertStore jcaCertStore = new JcaCertStore(arrayList);
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            JcaSimpleSignerInfoGeneratorBuilder jcaSimpleSignerInfoGeneratorBuilder = new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").setDirectSignature(true);
            cMSSignedDataGenerator.addSignerInfoGenerator(jcaSimpleSignerInfoGeneratorBuilder.build(signalg, privateKey, (X509Certificate)certificate));
            cMSSignedDataGenerator.addCertificates(jcaCertStore);
            CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray(plaintxt);
            CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, true);
            return cMSSignedData.getEncoded();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static byte[] pkcs1sign(byte[] keybytes, byte[] plainText, String signalg) {
        try {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(keybytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            Signature signature = Signature.getInstance(signalg);
            signature.initSign(privateKey);
            signature.update(plainText);
            return signature.sign();
        }
        catch (Exception exception) {
            System.out.println("\u7b7e\u540d\u5931\u8d25");
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean pkcs1verify(byte[] certbytes, byte[] plainText, byte[] signText, String signalg) {
        try {
            Signature signature = Signature.getInstance(signalg);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certbytes);
            Certificate certificate = null;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            while (((InputStream)byteArrayInputStream).available() > 0) {
                certificate = certificateFactory.generateCertificate(byteArrayInputStream);
            }
            if (certificate != null) {
                signature.initVerify(certificate.getPublicKey());
                signature.update(plainText);
                return signature.verify(signText);
            }
            return false;
        }
        catch (Throwable throwable) {
            System.out.println("\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
            throwable.printStackTrace();
            return false;
        }
    }

    public static boolean pkcs1verify(String cert, String plaintext, String signText, String signalg) {
        try {
            Signature signature = Signature.getInstance(signalg);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.decode(cert));
            Certificate certificate = null;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            while (((InputStream)byteArrayInputStream).available() > 0) {
                certificate = certificateFactory.generateCertificate(byteArrayInputStream);
            }
            if (cert != null) {
                signature.initVerify(certificate.getPublicKey());
                signature.update(Base64.decode(plaintext));
                return signature.verify(Base64.decode(signText));
            }
            return false;
        }
        catch (Throwable throwable) {
            System.out.println("\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
            throwable.printStackTrace();
            return false;
        }
    }

    public static byte[] PubKeyEncrypt(byte[] certbytes, byte[] data) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certbytes);
            Certificate certificate = null;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            while (((InputStream)byteArrayInputStream).available() > 0) {
                certificate = certificateFactory.generateCertificate(byteArrayInputStream);
            }
            if (null == certificate) {
                return null;
            }
            CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            cMSEnvelopedDataGenerator.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator((X509Certificate)certificate).setProvider("BC"));
            CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray(data);
            CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(cMSProcessableByteArray, new JceCMSContentEncryptorBuilder(CMSAlgorithm.DES_EDE3_CBC).setProvider("BC").build());
            return cMSEnvelopedData.getEncoded();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        SoftKeyTool softKeyTool = new SoftKeyTool();
    }

    static {
        Provider.BC.install();
    }
}

