/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.base;

import com.timevale.esign.paas.guava.common.annotations.Beta;
import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.base.Equivalence;
import com.timevale.esign.paas.guava.common.base.PairwiseEquivalence;
import java.io.Serializable;

@Beta
@GwtCompatible
public final class Equivalences {
    private Equivalences() {
    }

    public static Equivalence<Object> equals() {
        return Equals.INSTANCE;
    }

    public static Equivalence<Object> identity() {
        return Identity.INSTANCE;
    }

    @Deprecated
    @GwtCompatible(serializable=true)
    public static <T> Equivalence<Iterable<T>> pairwise(Equivalence<? super T> elementEquivalence) {
        return new PairwiseEquivalence<T>(elementEquivalence);
    }

    private static final class Identity
    extends Equivalence<Object>
    implements Serializable {
        static final Identity INSTANCE = new Identity();
        private static final long serialVersionUID = 1L;

        private Identity() {
        }

        @Override
        protected boolean doEquivalent(Object a2, Object b2) {
            return false;
        }

        @Override
        protected int doHash(Object o2) {
            return System.identityHashCode(o2);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class Equals
    extends Equivalence<Object>
    implements Serializable {
        static final Equals INSTANCE = new Equals();
        private static final long serialVersionUID = 1L;

        private Equals() {
        }

        @Override
        protected boolean doEquivalent(Object a2, Object b2) {
            return a2.equals(b2);
        }

        @Override
        public int doHash(Object o2) {
            return o2.hashCode();
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

