/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.base;

import com.timevale.esign.paas.guava.common.base.FinalizableReference;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FinalizableReferenceQueue {
    private static final Logger logger = Logger.getLogger(FinalizableReferenceQueue.class.getName());
    private static final String FINALIZER_CLASS_NAME = "com.timevale.esign.paas.guava.common.base.internal.Finalizer";
    private static final Method startFinalizer;
    final ReferenceQueue<Object> queue;
    final boolean threadStarted;

    public FinalizableReferenceQueue() {
        ReferenceQueue referenceQueue;
        boolean bl2 = false;
        try {
            referenceQueue = (ReferenceQueue)startFinalizer.invoke(null, FinalizableReference.class, this);
            bl2 = true;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (Throwable throwable) {
            logger.log(Level.INFO, "Failed to start reference finalizer thread. Reference cleanup will only occur when new references are created.", throwable);
            referenceQueue = new ReferenceQueue();
        }
        this.queue = referenceQueue;
        this.threadStarted = bl2;
    }

    void cleanUp() {
        Reference<Object> reference;
        if (this.threadStarted) {
            return;
        }
        while ((reference = this.queue.poll()) != null) {
            reference.clear();
            try {
                ((FinalizableReference)((Object)reference)).finalizeReferent();
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "Error cleaning up after reference.", throwable);
            }
        }
    }

    private static Class<?> loadFinalizer(FinalizerLoader ... loaders) {
        for (FinalizerLoader finalizerLoader : loaders) {
            Class<?> clazz = finalizerLoader.loadFinalizer();
            if (clazz == null) continue;
            return clazz;
        }
        throw new AssertionError();
    }

    static Method getStartFinalizer(Class<?> finalizer) {
        try {
            return finalizer.getMethod("startFinalizer", Class.class, Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
    }

    static {
        Class<?> clazz = FinalizableReferenceQueue.loadFinalizer(new SystemLoader(), new DecoupledLoader(), new DirectLoader());
        startFinalizer = FinalizableReferenceQueue.getStartFinalizer(clazz);
    }

    static class DirectLoader
    implements FinalizerLoader {
        DirectLoader() {
        }

        @Override
        public Class<?> loadFinalizer() {
            try {
                return Class.forName(FinalizableReferenceQueue.FINALIZER_CLASS_NAME);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)classNotFoundException);
            }
        }
    }

    static class DecoupledLoader
    implements FinalizerLoader {
        private static final String LOADING_ERROR = "Could not load Finalizer in its own class loader.Loading Finalizer in the current class loader instead. As a result, you will not be ableto garbage collect this class loader. To support reclaiming this class loader, eitherresolve the underlying issue, or move Google Collections to your system class path.";

        DecoupledLoader() {
        }

        @Override
        public Class<?> loadFinalizer() {
            try {
                URLClassLoader uRLClassLoader = this.newLoader(this.getBaseUrl());
                return uRLClassLoader.loadClass(FinalizableReferenceQueue.FINALIZER_CLASS_NAME);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, LOADING_ERROR, exception);
                return null;
            }
        }

        URL getBaseUrl() throws IOException {
            String string = FinalizableReferenceQueue.FINALIZER_CLASS_NAME.replace('.', '/') + ".class";
            URL uRL = this.getClass().getClassLoader().getResource(string);
            if (uRL == null) {
                throw new FileNotFoundException(string);
            }
            String string2 = uRL.toString();
            if (!string2.endsWith(string)) {
                throw new IOException("Unsupported path style: " + string2);
            }
            string2 = string2.substring(0, string2.length() - string.length());
            return new URL(uRL, string2);
        }

        URLClassLoader newLoader(URL base) {
            return new URLClassLoader(new URL[]{base});
        }
    }

    static class SystemLoader
    implements FinalizerLoader {
        SystemLoader() {
        }

        @Override
        public Class<?> loadFinalizer() {
            ClassLoader classLoader;
            try {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            catch (SecurityException securityException) {
                logger.info("Not allowed to access system class loader.");
                return null;
            }
            if (classLoader != null) {
                try {
                    return classLoader.loadClass(FinalizableReferenceQueue.FINALIZER_CLASS_NAME);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
            return null;
        }
    }

    static interface FinalizerLoader {
        public Class<?> loadFinalizer();
    }
}

