/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.cache;

import com.timevale.esign.paas.guava.common.annotations.VisibleForTesting;
import com.timevale.esign.paas.guava.common.base.Equivalence;
import com.timevale.esign.paas.guava.common.base.Equivalences;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.base.Supplier;
import com.timevale.esign.paas.guava.common.base.Ticker;
import com.timevale.esign.paas.guava.common.cache.AbstractCache;
import com.timevale.esign.paas.guava.common.cache.Cache;
import com.timevale.esign.paas.guava.common.cache.CacheBuilder;
import com.timevale.esign.paas.guava.common.cache.CacheLoader;
import com.timevale.esign.paas.guava.common.cache.ForwardingCache;
import com.timevale.esign.paas.guava.common.cache.RemovalCause;
import com.timevale.esign.paas.guava.common.cache.RemovalListener;
import com.timevale.esign.paas.guava.common.cache.RemovalNotification;
import com.timevale.esign.paas.guava.common.collect.AbstractLinkedIterator;
import com.timevale.esign.paas.guava.common.collect.Iterators;
import com.timevale.esign.paas.guava.common.primitives.Ints;
import com.timevale.esign.paas.guava.common.util.concurrent.ExecutionError;
import com.timevale.esign.paas.guava.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class CustomConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int CONTAINS_VALUE_RETRIES = 3;
    static final int DRAIN_THRESHOLD = 63;
    static final int DRAIN_MAX = 16;
    private static final Logger logger = Logger.getLogger(CustomConcurrentHashMap.class.getName());
    final int segmentMask;
    final int segmentShift;
    final Segment<K, V>[] segments;
    final CacheLoader<? super K, V> loader;
    final int concurrencyLevel;
    final Equivalence<Object> keyEquivalence;
    final Equivalence<Object> valueEquivalence;
    final Strength keyStrength;
    final Strength valueStrength;
    final int maximumSize;
    final long expireAfterAccessNanos;
    final long expireAfterWriteNanos;
    final Queue<RemovalNotification<K, V>> removalNotificationQueue;
    final RemovalListener<K, V> removalListener;
    final EntryFactory entryFactory;
    final Ticker ticker;
    static final ValueReference<Object, Object> UNSET = new ValueReference<Object, Object>(){

        @Override
        public Object get() {
            return null;
        }

        @Override
        public ReferenceEntry<Object, Object> getEntry() {
            return null;
        }

        @Override
        public ValueReference<Object, Object> copyFor(ReferenceQueue<Object> queue, ReferenceEntry<Object, Object> entry) {
            return this;
        }

        @Override
        public boolean isComputingReference() {
            return false;
        }

        @Override
        public Object waitForValue() {
            return null;
        }

        @Override
        public void notifyNewValue(Object newValue) {
        }
    };
    static final Queue<? extends Object> DISCARDING_QUEUE = new AbstractQueue<Object>(){

        @Override
        public boolean offer(Object o2) {
            return true;
        }

        @Override
        public Object peek() {
            return null;
        }

        @Override
        public Object poll() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<Object> iterator() {
            return Iterators.emptyIterator();
        }
    };
    Set<K> keySet;
    Collection<V> values;
    Set<Map.Entry<K, V>> entrySet;

    CustomConcurrentHashMap(CacheBuilder<? super K, ? super V> builder, Supplier<? extends AbstractCache.StatsCounter> statsCounterSupplier, CacheLoader<? super K, V> loader) {
        int n2;
        int n3;
        this.loader = Preconditions.checkNotNull(loader);
        this.concurrencyLevel = Math.min(builder.getConcurrencyLevel(), 65536);
        this.keyStrength = builder.getKeyStrength();
        this.valueStrength = builder.getValueStrength();
        this.keyEquivalence = builder.getKeyEquivalence();
        this.valueEquivalence = builder.getValueEquivalence();
        this.maximumSize = builder.maximumSize;
        this.expireAfterAccessNanos = builder.getExpireAfterAccessNanos();
        this.expireAfterWriteNanos = builder.getExpireAfterWriteNanos();
        this.entryFactory = EntryFactory.getFactory(this.keyStrength, this.expires(), this.evictsBySize());
        this.ticker = builder.getTicker();
        this.removalListener = builder.getRemovalListener();
        this.removalNotificationQueue = this.removalListener == CacheBuilder.NullListener.INSTANCE ? CustomConcurrentHashMap.discardingQueue() : new ConcurrentLinkedQueue();
        int n4 = Math.min(builder.getInitialCapacity(), 0x40000000);
        if (this.evictsBySize()) {
            n4 = Math.min(n4, this.maximumSize);
        }
        int n5 = 0;
        for (n3 = 1; !(n3 >= this.concurrencyLevel || this.evictsBySize() && n3 * 2 > this.maximumSize); n3 <<= 1) {
            ++n5;
        }
        this.segmentShift = 32 - n5;
        this.segmentMask = n3 - 1;
        this.segments = this.newSegmentArray(n3);
        int n6 = n4 / n3;
        if (n6 * n3 < n4) {
            ++n6;
        }
        for (n2 = 1; n2 < n6; n2 <<= 1) {
        }
        if (this.evictsBySize()) {
            int n7 = this.maximumSize / n3 + 1;
            int n8 = this.maximumSize % n3;
            for (int i2 = 0; i2 < this.segments.length; ++i2) {
                if (i2 == n8) {
                    --n7;
                }
                this.segments[i2] = this.createSegment(n2, n7, statsCounterSupplier.get());
            }
        } else {
            for (int i3 = 0; i3 < this.segments.length; ++i3) {
                this.segments[i3] = this.createSegment(n2, -1, statsCounterSupplier.get());
            }
        }
    }

    boolean evictsBySize() {
        return this.maximumSize != -1;
    }

    boolean expires() {
        return this.expiresAfterWrite() || this.expiresAfterAccess();
    }

    boolean expiresAfterWrite() {
        return this.expireAfterWriteNanos > 0L;
    }

    boolean expiresAfterAccess() {
        return this.expireAfterAccessNanos > 0L;
    }

    boolean usesKeyReferences() {
        return this.keyStrength != Strength.STRONG;
    }

    boolean usesValueReferences() {
        return this.valueStrength != Strength.STRONG;
    }

    static <K, V> ValueReference<K, V> unset() {
        return UNSET;
    }

    static <K, V> ReferenceEntry<K, V> nullEntry() {
        return NullEntry.INSTANCE;
    }

    static <E> Queue<E> discardingQueue() {
        return DISCARDING_QUEUE;
    }

    static int rehash(int h2) {
        h2 += h2 << 15 ^ 0xFFFFCD7D;
        h2 ^= h2 >>> 10;
        h2 += h2 << 3;
        h2 ^= h2 >>> 6;
        h2 += (h2 << 2) + (h2 << 14);
        return h2 ^ h2 >>> 16;
    }

    @GuardedBy(value="Segment.this")
    @VisibleForTesting
    ReferenceEntry<K, V> newEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
        return this.segmentFor(hash).newEntry(key, hash, next);
    }

    @GuardedBy(value="Segment.this")
    @VisibleForTesting
    ReferenceEntry<K, V> copyEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
        int n2 = original.getHash();
        return this.segmentFor(n2).copyEntry(original, newNext);
    }

    @GuardedBy(value="Segment.this")
    @VisibleForTesting
    ValueReference<K, V> newValueReference(ReferenceEntry<K, V> entry, V value) {
        int n2 = entry.getHash();
        return this.valueStrength.referenceValue(this.segmentFor(n2), entry, value);
    }

    int hash(Object key) {
        int n2 = this.keyEquivalence.hash(key);
        return CustomConcurrentHashMap.rehash(n2);
    }

    void reclaimValue(ValueReference<K, V> valueReference) {
        ReferenceEntry<K, V> referenceEntry = valueReference.getEntry();
        int n2 = referenceEntry.getHash();
        this.segmentFor(n2).reclaimValue(referenceEntry.getKey(), n2, valueReference);
    }

    void reclaimKey(ReferenceEntry<K, V> entry) {
        int n2 = entry.getHash();
        this.segmentFor(n2).reclaimKey(entry, n2);
    }

    @VisibleForTesting
    boolean isLive(ReferenceEntry<K, V> entry) {
        return this.segmentFor(entry.getHash()).getLiveValue(entry) != null;
    }

    Segment<K, V> segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    Segment<K, V> createSegment(int initialCapacity, int maxSegmentSize, AbstractCache.StatsCounter statsCounter) {
        return new Segment(this, initialCapacity, maxSegmentSize, statsCounter);
    }

    V getLiveValue(ReferenceEntry<K, V> entry) {
        if (entry.getKey() == null) {
            return null;
        }
        V v2 = entry.getValueReference().get();
        if (v2 == null) {
            return null;
        }
        if (this.expires() && this.isExpired(entry)) {
            return null;
        }
        return v2;
    }

    boolean isExpired(ReferenceEntry<K, V> entry) {
        return this.isExpired(entry, this.ticker.read());
    }

    boolean isExpired(ReferenceEntry<K, V> entry, long now) {
        return now - entry.getExpirationTime() > 0L;
    }

    @GuardedBy(value="Segment.this")
    static <K, V> void connectExpirables(ReferenceEntry<K, V> previous, ReferenceEntry<K, V> next) {
        previous.setNextExpirable(next);
        next.setPreviousExpirable(previous);
    }

    @GuardedBy(value="Segment.this")
    static <K, V> void nullifyExpirable(ReferenceEntry<K, V> nulled) {
        ReferenceEntry<K, V> referenceEntry = CustomConcurrentHashMap.nullEntry();
        nulled.setNextExpirable(referenceEntry);
        nulled.setPreviousExpirable(referenceEntry);
    }

    void processPendingNotifications() {
        RemovalNotification<K, V> removalNotification;
        while ((removalNotification = this.removalNotificationQueue.poll()) != null) {
            try {
                this.removalListener.onRemoval(removalNotification);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Exception thrown by removal listener", exception);
            }
        }
    }

    @GuardedBy(value="Segment.this")
    static <K, V> void connectEvictables(ReferenceEntry<K, V> previous, ReferenceEntry<K, V> next) {
        previous.setNextEvictable(next);
        next.setPreviousEvictable(previous);
    }

    @GuardedBy(value="Segment.this")
    static <K, V> void nullifyEvictable(ReferenceEntry<K, V> nulled) {
        ReferenceEntry<K, V> referenceEntry = CustomConcurrentHashMap.nullEntry();
        nulled.setNextEvictable(referenceEntry);
        nulled.setPreviousEvictable(referenceEntry);
    }

    final Segment<K, V>[] newSegmentArray(int ssize) {
        return new Segment[ssize];
    }

    public void cleanUp() {
        for (Segment<K, V> segment : this.segments) {
            segment.cleanUp();
        }
    }

    @Override
    public boolean isEmpty() {
        int n2;
        long l2 = 0L;
        Segment<K, V>[] segmentArray = this.segments;
        for (n2 = 0; n2 < segmentArray.length; ++n2) {
            if (segmentArray[n2].count != 0) {
                return false;
            }
            l2 += (long)segmentArray[n2].modCount;
        }
        if (l2 != 0L) {
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                if (segmentArray[n2].count != 0) {
                    return false;
                }
                l2 -= (long)segmentArray[n2].modCount;
            }
            if (l2 != 0L) {
                return false;
            }
        }
        return true;
    }

    long longSize() {
        Segment<K, V>[] segmentArray = this.segments;
        long l2 = 0L;
        for (int i2 = 0; i2 < segmentArray.length; ++i2) {
            l2 += (long)segmentArray[i2].count;
        }
        return l2;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.longSize());
    }

    @Override
    public V get(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        int n2 = this.hash(key);
        return this.segmentFor(n2).get(key, n2);
    }

    V getOrCompute(K key) throws ExecutionException {
        int n2 = this.hash(Preconditions.checkNotNull(key));
        return this.segmentFor(n2).getOrCompute((K)key, n2, this.loader);
    }

    ReferenceEntry<K, V> getEntry(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        int n2 = this.hash(key);
        return this.segmentFor(n2).getEntry(key, n2);
    }

    ReferenceEntry<K, V> getLiveEntry(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        int n2 = this.hash(key);
        return this.segmentFor(n2).getLiveEntry(key, n2);
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        if (key == null) {
            return false;
        }
        int n2 = this.hash(key);
        return this.segmentFor(n2).containsKey(key, n2);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        if (value == null) {
            return false;
        }
        Segment<K, V>[] segmentArray = this.segments;
        long l2 = -1L;
        for (int i2 = 0; i2 < 3; ++i2) {
            long l3 = 0L;
            for (Segment segment : segmentArray) {
                int n2 = segment.count;
                AtomicReferenceArray atomicReferenceArray = segment.table;
                for (int i3 = 0; i3 < atomicReferenceArray.length(); ++i3) {
                    for (ReferenceEntry referenceEntry = atomicReferenceArray.get(i3); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                        V v2 = segment.getLiveValue(referenceEntry);
                        if (v2 == null || !this.valueEquivalence.equivalent(value, v2)) continue;
                        return true;
                    }
                }
                l3 += (long)segment.modCount;
            }
            if (l3 == l2) break;
            l2 = l3;
        }
        return false;
    }

    @Override
    public V put(K key, V value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        int n2 = this.hash(key);
        return this.segmentFor(n2).put(key, n2, value, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        int n2 = this.hash(key);
        return this.segmentFor(n2).put(key, n2, value, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m2) {
        for (Map.Entry<K, V> entry : m2.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        int n2 = this.hash(key);
        return this.segmentFor(n2).remove(key, n2);
    }

    @Override
    public boolean remove(@Nullable Object key, @Nullable Object value) {
        if (key == null || value == null) {
            return false;
        }
        int n2 = this.hash(key);
        return this.segmentFor(n2).remove(key, n2, value);
    }

    @Override
    public boolean replace(K key, @Nullable V oldValue, V newValue) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(newValue);
        if (oldValue == null) {
            return false;
        }
        int n2 = this.hash(key);
        return this.segmentFor(n2).replace(key, n2, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        int n2 = this.hash(key);
        return this.segmentFor(n2).replace(key, n2, value);
    }

    @Override
    public void clear() {
        for (Segment<K, V> segment : this.segments) {
            segment.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values != null ? values : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    Cache<K, V> cacheSerializationProxy() {
        return new SerializationProxy<K, V>(this.loader, this.keyStrength, this.valueStrength, this.keyEquivalence, this.valueEquivalence, this.expireAfterWriteNanos, this.expireAfterAccessNanos, this.maximumSize, this.concurrencyLevel, this.removalListener, this.ticker);
    }

    static final class SerializationProxy<K, V>
    extends ForwardingCache<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final CacheLoader<? super K, V> loader;
        final Strength keyStrength;
        final Strength valueStrength;
        final Equivalence<Object> keyEquivalence;
        final Equivalence<Object> valueEquivalence;
        final long expireAfterWriteNanos;
        final long expireAfterAccessNanos;
        final int maximumSize;
        final int concurrencyLevel;
        final RemovalListener<? super K, ? super V> removalListener;
        final Ticker ticker;
        transient Cache<K, V> delegate;

        SerializationProxy(CacheLoader<? super K, V> loader, Strength keyStrength, Strength valueStrength, Equivalence<Object> keyEquivalence, Equivalence<Object> valueEquivalence, long expireAfterWriteNanos, long expireAfterAccessNanos, int maximumSize, int concurrencyLevel, RemovalListener<? super K, ? super V> removalListener, Ticker ticker) {
            this.loader = loader;
            this.keyStrength = keyStrength;
            this.valueStrength = valueStrength;
            this.keyEquivalence = keyEquivalence;
            this.valueEquivalence = valueEquivalence;
            this.expireAfterWriteNanos = expireAfterWriteNanos;
            this.expireAfterAccessNanos = expireAfterAccessNanos;
            this.maximumSize = maximumSize;
            this.concurrencyLevel = concurrencyLevel;
            this.removalListener = removalListener;
            this.ticker = ticker;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder().setKeyStrength(this.keyStrength).setValueStrength(this.valueStrength).keyEquivalence(this.keyEquivalence).valueEquivalence(this.valueEquivalence).concurrencyLevel(this.concurrencyLevel);
            cacheBuilder.removalListener(this.removalListener);
            if (this.expireAfterWriteNanos > 0L) {
                cacheBuilder.expireAfterWrite(this.expireAfterWriteNanos, TimeUnit.NANOSECONDS);
            }
            if (this.expireAfterAccessNanos > 0L) {
                cacheBuilder.expireAfterAccess(this.expireAfterAccessNanos, TimeUnit.NANOSECONDS);
            }
            if (this.maximumSize != -1) {
                cacheBuilder.maximumSize(this.maximumSize);
            }
            if (this.ticker != Ticker.systemTicker()) {
                cacheBuilder.ticker(this.ticker);
            }
            this.delegate = cacheBuilder.build(this.loader);
        }

        private Object readResolve() {
            return this.delegate;
        }

        @Override
        protected Cache<K, V> delegate() {
            return this.delegate;
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o2;
            Object k2 = entry.getKey();
            if (k2 == null) {
                return false;
            }
            Object v2 = CustomConcurrentHashMap.this.get(k2);
            return v2 != null && CustomConcurrentHashMap.this.valueEquivalence.equivalent(entry.getValue(), v2);
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o2;
            Object k2 = entry.getKey();
            return k2 != null && CustomConcurrentHashMap.this.remove(k2, entry.getValue());
        }

        @Override
        public int size() {
            return CustomConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CustomConcurrentHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            CustomConcurrentHashMap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return CustomConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CustomConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o2) {
            return CustomConcurrentHashMap.this.containsValue(o2);
        }

        @Override
        public void clear() {
            CustomConcurrentHashMap.this.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return CustomConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CustomConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o2) {
            return CustomConcurrentHashMap.this.containsKey(o2);
        }

        @Override
        public boolean remove(Object o2) {
            return CustomConcurrentHashMap.this.remove(o2) != null;
        }

        @Override
        public void clear() {
            CustomConcurrentHashMap.this.clear();
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator {
        EntryIterator() {
        }

        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    final class WriteThroughEntry
    implements Map.Entry<K, V> {
        final K key;
        V value;

        WriteThroughEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this.key.equals(entry.getKey()) && this.value.equals(entry.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        @Override
        public V setValue(V newValue) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator {
        ValueIterator() {
        }

        public V next() {
            return this.nextEntry().getValue();
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator {
        KeyIterator() {
        }

        public K next() {
            return this.nextEntry().getKey();
        }
    }

    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        Segment<K, V> currentSegment;
        AtomicReferenceArray<ReferenceEntry<K, V>> currentTable;
        ReferenceEntry<K, V> nextEntry;
        WriteThroughEntry nextExternal;
        WriteThroughEntry lastReturned;

        HashIterator() {
            this.nextSegmentIndex = CustomConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        final void advance() {
            this.nextExternal = null;
            if (this.nextInChain()) {
                return;
            }
            if (this.nextInTable()) {
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                this.currentSegment = CustomConcurrentHashMap.this.segments[this.nextSegmentIndex--];
                if (this.currentSegment.count == 0) continue;
                this.currentTable = this.currentSegment.table;
                this.nextTableIndex = this.currentTable.length() - 1;
                if (!this.nextInTable()) continue;
                return;
            }
        }

        boolean nextInChain() {
            if (this.nextEntry != null) {
                this.nextEntry = this.nextEntry.getNext();
                while (this.nextEntry != null) {
                    if (this.advanceTo(this.nextEntry)) {
                        return true;
                    }
                    this.nextEntry = this.nextEntry.getNext();
                }
            }
            return false;
        }

        boolean nextInTable() {
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable.get(this.nextTableIndex--)) == null || !this.advanceTo(this.nextEntry) && !this.nextInChain()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean advanceTo(ReferenceEntry<K, V> entry) {
            try {
                Object k2 = entry.getKey();
                Object v2 = CustomConcurrentHashMap.this.getLiveValue(entry);
                if (v2 != null) {
                    this.nextExternal = new WriteThroughEntry(k2, v2);
                    boolean bl2 = true;
                    return bl2;
                }
                boolean bl3 = false;
                return bl3;
            }
            finally {
                this.currentSegment.postReadCleanup();
            }
        }

        public boolean hasNext() {
            return this.nextExternal != null;
        }

        WriteThroughEntry nextEntry() {
            if (this.nextExternal == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextExternal;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            Preconditions.checkState(this.lastReturned != null);
            CustomConcurrentHashMap.this.remove(this.lastReturned.getKey());
            this.lastReturned = null;
        }
    }

    static final class ExpirationQueue<K, V>
    extends AbstractQueue<ReferenceEntry<K, V>> {
        final ReferenceEntry<K, V> head = new AbstractReferenceEntry<K, V>(){
            ReferenceEntry<K, V> nextExpirable = this;
            ReferenceEntry<K, V> previousExpirable = this;

            @Override
            public long getExpirationTime() {
                return Long.MAX_VALUE;
            }

            @Override
            public void setExpirationTime(long time) {
            }

            @Override
            public ReferenceEntry<K, V> getNextExpirable() {
                return this.nextExpirable;
            }

            @Override
            public void setNextExpirable(ReferenceEntry<K, V> next) {
                this.nextExpirable = next;
            }

            @Override
            public ReferenceEntry<K, V> getPreviousExpirable() {
                return this.previousExpirable;
            }

            @Override
            public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
                this.previousExpirable = previous;
            }
        };

        ExpirationQueue() {
        }

        @Override
        public boolean offer(ReferenceEntry<K, V> entry) {
            CustomConcurrentHashMap.connectExpirables(entry.getPreviousExpirable(), entry.getNextExpirable());
            CustomConcurrentHashMap.connectExpirables(this.head.getPreviousExpirable(), entry);
            CustomConcurrentHashMap.connectExpirables(entry, this.head);
            return true;
        }

        @Override
        public ReferenceEntry<K, V> peek() {
            ReferenceEntry<K, V> referenceEntry = this.head.getNextExpirable();
            return referenceEntry == this.head ? null : referenceEntry;
        }

        @Override
        public ReferenceEntry<K, V> poll() {
            ReferenceEntry<K, V> referenceEntry = this.head.getNextExpirable();
            if (referenceEntry == this.head) {
                return null;
            }
            this.remove(referenceEntry);
            return referenceEntry;
        }

        @Override
        public boolean remove(Object o2) {
            ReferenceEntry referenceEntry = (ReferenceEntry)o2;
            ReferenceEntry referenceEntry2 = referenceEntry.getPreviousExpirable();
            ReferenceEntry referenceEntry3 = referenceEntry.getNextExpirable();
            CustomConcurrentHashMap.connectExpirables(referenceEntry2, referenceEntry3);
            CustomConcurrentHashMap.nullifyExpirable(referenceEntry);
            return referenceEntry3 != NullEntry.INSTANCE;
        }

        @Override
        public boolean contains(Object o2) {
            ReferenceEntry referenceEntry = (ReferenceEntry)o2;
            return referenceEntry.getNextExpirable() != NullEntry.INSTANCE;
        }

        @Override
        public boolean isEmpty() {
            return this.head.getNextExpirable() == this.head;
        }

        @Override
        public int size() {
            int n2 = 0;
            for (ReferenceEntry<K, V> referenceEntry = this.head.getNextExpirable(); referenceEntry != this.head; referenceEntry = referenceEntry.getNextExpirable()) {
                ++n2;
            }
            return n2;
        }

        @Override
        public void clear() {
            ReferenceEntry<K, V> referenceEntry = this.head.getNextExpirable();
            while (referenceEntry != this.head) {
                ReferenceEntry<K, V> referenceEntry2 = referenceEntry.getNextExpirable();
                CustomConcurrentHashMap.nullifyExpirable(referenceEntry);
                referenceEntry = referenceEntry2;
            }
            this.head.setNextExpirable(this.head);
            this.head.setPreviousExpirable(this.head);
        }

        @Override
        public Iterator<ReferenceEntry<K, V>> iterator() {
            return new AbstractLinkedIterator<ReferenceEntry<K, V>>((ReferenceEntry)this.peek()){

                @Override
                protected ReferenceEntry<K, V> computeNext(ReferenceEntry<K, V> previous) {
                    ReferenceEntry referenceEntry = previous.getNextExpirable();
                    return referenceEntry == head ? null : referenceEntry;
                }
            };
        }
    }

    static final class EvictionQueue<K, V>
    extends AbstractQueue<ReferenceEntry<K, V>> {
        final ReferenceEntry<K, V> head = new AbstractReferenceEntry<K, V>(){
            ReferenceEntry<K, V> nextEvictable = this;
            ReferenceEntry<K, V> previousEvictable = this;

            @Override
            public ReferenceEntry<K, V> getNextEvictable() {
                return this.nextEvictable;
            }

            @Override
            public void setNextEvictable(ReferenceEntry<K, V> next) {
                this.nextEvictable = next;
            }

            @Override
            public ReferenceEntry<K, V> getPreviousEvictable() {
                return this.previousEvictable;
            }

            @Override
            public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
                this.previousEvictable = previous;
            }
        };

        EvictionQueue() {
        }

        @Override
        public boolean offer(ReferenceEntry<K, V> entry) {
            CustomConcurrentHashMap.connectEvictables(entry.getPreviousEvictable(), entry.getNextEvictable());
            CustomConcurrentHashMap.connectEvictables(this.head.getPreviousEvictable(), entry);
            CustomConcurrentHashMap.connectEvictables(entry, this.head);
            return true;
        }

        @Override
        public ReferenceEntry<K, V> peek() {
            ReferenceEntry<K, V> referenceEntry = this.head.getNextEvictable();
            return referenceEntry == this.head ? null : referenceEntry;
        }

        @Override
        public ReferenceEntry<K, V> poll() {
            ReferenceEntry<K, V> referenceEntry = this.head.getNextEvictable();
            if (referenceEntry == this.head) {
                return null;
            }
            this.remove(referenceEntry);
            return referenceEntry;
        }

        @Override
        public boolean remove(Object o2) {
            ReferenceEntry referenceEntry = (ReferenceEntry)o2;
            ReferenceEntry referenceEntry2 = referenceEntry.getPreviousEvictable();
            ReferenceEntry referenceEntry3 = referenceEntry.getNextEvictable();
            CustomConcurrentHashMap.connectEvictables(referenceEntry2, referenceEntry3);
            CustomConcurrentHashMap.nullifyEvictable(referenceEntry);
            return referenceEntry3 != NullEntry.INSTANCE;
        }

        @Override
        public boolean contains(Object o2) {
            ReferenceEntry referenceEntry = (ReferenceEntry)o2;
            return referenceEntry.getNextEvictable() != NullEntry.INSTANCE;
        }

        @Override
        public boolean isEmpty() {
            return this.head.getNextEvictable() == this.head;
        }

        @Override
        public int size() {
            int n2 = 0;
            for (ReferenceEntry<K, V> referenceEntry = this.head.getNextEvictable(); referenceEntry != this.head; referenceEntry = referenceEntry.getNextEvictable()) {
                ++n2;
            }
            return n2;
        }

        @Override
        public void clear() {
            ReferenceEntry<K, V> referenceEntry = this.head.getNextEvictable();
            while (referenceEntry != this.head) {
                ReferenceEntry<K, V> referenceEntry2 = referenceEntry.getNextEvictable();
                CustomConcurrentHashMap.nullifyEvictable(referenceEntry);
                referenceEntry = referenceEntry2;
            }
            this.head.setNextEvictable(this.head);
            this.head.setPreviousEvictable(this.head);
        }

        @Override
        public Iterator<ReferenceEntry<K, V>> iterator() {
            return new AbstractLinkedIterator<ReferenceEntry<K, V>>((ReferenceEntry)this.peek()){

                @Override
                protected ReferenceEntry<K, V> computeNext(ReferenceEntry<K, V> previous) {
                    ReferenceEntry referenceEntry = previous.getNextEvictable();
                    return referenceEntry == head ? null : referenceEntry;
                }
            };
        }
    }

    static final class ComputingValueReference<K, V>
    implements ValueReference<K, V> {
        final CacheLoader<? super K, V> loader;
        @GuardedBy(value="ComputingValueReference.this")
        volatile ComputedValue<V> computedValue = null;

        public ComputingValueReference(CacheLoader<? super K, V> loader) {
            this.loader = loader;
        }

        @Override
        public boolean isComputingReference() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V waitForValue() throws ExecutionException {
            if (this.computedValue == null) {
                boolean bl2 = false;
                try {
                    ComputingValueReference computingValueReference = this;
                    synchronized (computingValueReference) {
                        while (this.computedValue == null) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                bl2 = true;
                            }
                        }
                    }
                }
                finally {
                    if (bl2) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            return this.computedValue.get();
        }

        @Override
        public void notifyNewValue(V newValue) {
            this.setComputedValue(new ComputedReference<V>(newValue));
        }

        V compute(K key, int hash) throws ExecutionException {
            ComputedValue computedValue;
            try {
                V v2 = this.loader.load(key);
                computedValue = v2 == null ? new ComputedNull<K, V>(this.loader, key) : new ComputedReference<V>(v2);
            }
            catch (RuntimeException runtimeException) {
                computedValue = new ComputedUncheckedException(runtimeException);
            }
            catch (Exception exception) {
                computedValue = new ComputedException(exception);
            }
            catch (Error error) {
                computedValue = new ComputedError(error);
            }
            this.setComputedValue(computedValue);
            return computedValue.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setComputedValue(ComputedValue<V> newValue) {
            ComputingValueReference computingValueReference = this;
            synchronized (computingValueReference) {
                if (this.computedValue == null) {
                    this.computedValue = newValue;
                    this.notifyAll();
                }
            }
        }

        @Override
        public V get() {
            return null;
        }

        @Override
        public ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> queue, ReferenceEntry<K, V> entry) {
            return this;
        }
    }

    private static final class ComputedNull<K, V>
    implements ComputedValue<V> {
        final String msg;

        public ComputedNull(CacheLoader<? super K, V> loader, K key) {
            this.msg = loader + " returned null for key " + key + ".";
        }

        @Override
        public V get() {
            throw new NullPointerException(this.msg);
        }
    }

    private static final class ComputedReference<V>
    implements ComputedValue<V> {
        final V value;

        ComputedReference(V value) {
            this.value = Preconditions.checkNotNull(value);
        }

        @Override
        public V get() {
            return this.value;
        }
    }

    private static final class ComputedError<V>
    implements ComputedValue<V> {
        final Error e;

        ComputedError(Error e2) {
            this.e = e2;
        }

        @Override
        public V get() {
            throw new ExecutionError(this.e);
        }
    }

    private static final class ComputedException<V>
    implements ComputedValue<V> {
        final Exception e;

        ComputedException(Exception e2) {
            this.e = e2;
        }

        @Override
        public V get() throws ExecutionException {
            throw new ExecutionException(this.e);
        }
    }

    private static final class ComputedUncheckedException<V>
    implements ComputedValue<V> {
        final RuntimeException e;

        ComputedUncheckedException(RuntimeException e2) {
            this.e = e2;
        }

        @Override
        public V get() {
            throw new UncheckedExecutionException(this.e);
        }
    }

    private static interface ComputedValue<V> {
        public V get() throws ExecutionException;
    }

    static class Segment<K, V>
    extends ReentrantLock {
        final CustomConcurrentHashMap<K, V> map;
        volatile int count;
        int modCount;
        int threshold;
        volatile AtomicReferenceArray<ReferenceEntry<K, V>> table;
        final int maxSegmentSize;
        final ReferenceQueue<K> keyReferenceQueue;
        final ReferenceQueue<V> valueReferenceQueue;
        final Queue<ReferenceEntry<K, V>> recencyQueue;
        final AtomicInteger readCount = new AtomicInteger();
        @GuardedBy(value="Segment.this")
        final Queue<ReferenceEntry<K, V>> evictionQueue;
        @GuardedBy(value="Segment.this")
        final Queue<ReferenceEntry<K, V>> expirationQueue;
        final AbstractCache.StatsCounter statsCounter;

        Segment(CustomConcurrentHashMap<K, V> map, int initialCapacity, int maxSegmentSize, AbstractCache.StatsCounter statsCounter) {
            this.map = map;
            this.maxSegmentSize = maxSegmentSize;
            this.statsCounter = statsCounter;
            this.initTable(this.newEntryArray(initialCapacity));
            this.keyReferenceQueue = map.usesKeyReferences() ? new ReferenceQueue() : null;
            this.valueReferenceQueue = map.usesValueReferences() ? new ReferenceQueue() : null;
            this.recencyQueue = map.evictsBySize() || map.expiresAfterAccess() ? new ConcurrentLinkedQueue() : CustomConcurrentHashMap.discardingQueue();
            this.evictionQueue = map.evictsBySize() ? new EvictionQueue() : CustomConcurrentHashMap.discardingQueue();
            this.expirationQueue = map.expires() ? new ExpirationQueue() : CustomConcurrentHashMap.discardingQueue();
        }

        AtomicReferenceArray<ReferenceEntry<K, V>> newEntryArray(int size) {
            return new AtomicReferenceArray<ReferenceEntry<K, V>>(size);
        }

        void initTable(AtomicReferenceArray<ReferenceEntry<K, V>> newTable) {
            this.threshold = newTable.length() * 3 / 4;
            if (this.threshold == this.maxSegmentSize) {
                ++this.threshold;
            }
            this.table = newTable;
        }

        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> newEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            return this.map.entryFactory.newEntry(this, key, hash, next);
        }

        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> copyEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
            ValueReference<K, V> valueReference = original.getValueReference();
            ReferenceEntry<K, V> referenceEntry = this.map.entryFactory.copyEntry(this, original, newNext);
            referenceEntry.setValueReference(valueReference.copyFor(this.valueReferenceQueue, referenceEntry));
            return referenceEntry;
        }

        @GuardedBy(value="Segment.this")
        void setValue(ReferenceEntry<K, V> entry, V value) {
            ValueReference<K, V> valueReference = entry.getValueReference();
            ValueReference<K, V> valueReference2 = this.map.valueStrength.referenceValue(this, entry, value);
            entry.setValueReference(valueReference2);
            this.recordWrite(entry);
            valueReference.notifyNewValue(value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        V getOrCompute(K key, int hash, CacheLoader<? super K, V> loader) throws ExecutionException {
            try {
                ComputingValueReference<? super K, V> computingValueReference;
                ReferenceEntry<Object, V> referenceEntry;
                V v2;
                do {
                    referenceEntry = null;
                    if (this.count != 0 && (referenceEntry = this.getEntry(key, hash)) != null && (v2 = this.getLiveValue(referenceEntry)) != null) {
                        this.recordRead(referenceEntry);
                        this.statsCounter.recordHit();
                        computingValueReference = (ComputingValueReference<? super K, V>)v2;
                        return (V)computingValueReference;
                    }
                    if (referenceEntry == null || !referenceEntry.getValueReference().isComputingReference()) {
                        boolean bl2;
                        block22: {
                            bl2 = true;
                            computingValueReference = null;
                            this.lock();
                            try {
                                this.preWriteCleanup();
                                int n2 = this.count - 1;
                                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                                int n3 = hash & atomicReferenceArray.length() - 1;
                                ReferenceEntry<K, V> referenceEntry2 = atomicReferenceArray.get(n3);
                                for (referenceEntry = referenceEntry2; referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                                    K k2 = referenceEntry.getKey();
                                    if (referenceEntry.getHash() != hash || k2 == null || !this.map.keyEquivalence.equivalent(key, k2)) continue;
                                    ValueReference<K, V> valueReference = referenceEntry.getValueReference();
                                    if (valueReference.isComputingReference()) {
                                        bl2 = false;
                                        break;
                                    }
                                    V v3 = referenceEntry.getValueReference().get();
                                    if (v3 == null) {
                                        this.enqueueNotification(k2, hash, v3, RemovalCause.COLLECTED);
                                    } else if (this.map.expires() && this.map.isExpired(referenceEntry)) {
                                        this.enqueueNotification(k2, hash, v3, RemovalCause.EXPIRED);
                                    } else {
                                        this.recordLockedRead(referenceEntry);
                                        this.statsCounter.recordHit();
                                        V v4 = v3;
                                        return v4;
                                    }
                                    this.evictionQueue.remove(referenceEntry);
                                    this.expirationQueue.remove(referenceEntry);
                                    this.count = n2;
                                    break;
                                }
                                if (!bl2) break block22;
                                computingValueReference = new ComputingValueReference<K, V>(loader);
                                if (referenceEntry == null) {
                                    referenceEntry = this.newEntry(key, hash, referenceEntry2);
                                    referenceEntry.setValueReference(computingValueReference);
                                    atomicReferenceArray.set(n3, referenceEntry);
                                } else {
                                    referenceEntry.setValueReference(computingValueReference);
                                }
                            }
                            finally {
                                this.unlock();
                                this.postWriteCleanup();
                            }
                        }
                        if (bl2) {
                            V v5 = this.compute(key, hash, referenceEntry, computingValueReference);
                            return v5;
                        }
                    }
                    Preconditions.checkState(!Thread.holdsLock(referenceEntry), "Recursive computation");
                } while ((v2 = referenceEntry.getValueReference().waitForValue()) == null);
                this.recordRead(referenceEntry);
                this.statsCounter.recordConcurrentMiss();
                computingValueReference = (ComputingValueReference<? super K, V>)v2;
                return (V)computingValueReference;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V compute(K key, int hash, ReferenceEntry<K, V> e2, ComputingValueReference<K, V> computingValueReference) throws ExecutionException {
            V v2 = null;
            long l2 = System.nanoTime();
            try {
                ReferenceEntry<K, V> referenceEntry = e2;
                synchronized (referenceEntry) {
                    v2 = computingValueReference.compute(key, hash);
                }
                long l3 = System.nanoTime();
                this.statsCounter.recordLoadSuccess(l3 - l2);
                Object var10_10 = this.put(key, hash, v2, true);
                if (var10_10 != null) {
                    this.enqueueNotification(key, hash, v2, RemovalCause.REPLACED);
                }
                V v3 = v2;
                return v3;
            }
            finally {
                if (v2 == null) {
                    long l4 = System.nanoTime();
                    this.statsCounter.recordLoadException(l4 - l2);
                    this.clearValue(key, hash, computingValueReference);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void tryDrainReferenceQueues() {
            if (this.tryLock()) {
                try {
                    this.drainReferenceQueues();
                }
                finally {
                    this.unlock();
                }
            }
        }

        @GuardedBy(value="Segment.this")
        void drainReferenceQueues() {
            if (this.map.usesKeyReferences()) {
                this.drainKeyReferenceQueue();
            }
            if (this.map.usesValueReferences()) {
                this.drainValueReferenceQueue();
            }
        }

        @GuardedBy(value="Segment.this")
        void drainKeyReferenceQueue() {
            Reference<K> reference;
            int n2 = 0;
            while ((reference = this.keyReferenceQueue.poll()) != null) {
                ReferenceEntry referenceEntry = (ReferenceEntry)((Object)reference);
                this.map.reclaimKey(referenceEntry);
                if (++n2 != 16) continue;
                break;
            }
        }

        @GuardedBy(value="Segment.this")
        void drainValueReferenceQueue() {
            Reference<V> reference;
            int n2 = 0;
            while ((reference = this.valueReferenceQueue.poll()) != null) {
                ValueReference valueReference = (ValueReference)((Object)reference);
                this.map.reclaimValue(valueReference);
                if (++n2 != 16) continue;
                break;
            }
        }

        void clearReferenceQueues() {
            if (this.map.usesKeyReferences()) {
                this.clearKeyReferenceQueue();
            }
            if (this.map.usesValueReferences()) {
                this.clearValueReferenceQueue();
            }
        }

        void clearKeyReferenceQueue() {
            while (this.keyReferenceQueue.poll() != null) {
            }
        }

        void clearValueReferenceQueue() {
            while (this.valueReferenceQueue.poll() != null) {
            }
        }

        void recordRead(ReferenceEntry<K, V> entry) {
            if (this.map.expiresAfterAccess()) {
                this.recordExpirationTime(entry, this.map.expireAfterAccessNanos);
            }
            this.recencyQueue.add(entry);
        }

        @GuardedBy(value="Segment.this")
        void recordLockedRead(ReferenceEntry<K, V> entry) {
            this.evictionQueue.add(entry);
            if (this.map.expiresAfterAccess()) {
                this.recordExpirationTime(entry, this.map.expireAfterAccessNanos);
                this.expirationQueue.add(entry);
            }
        }

        @GuardedBy(value="Segment.this")
        void recordWrite(ReferenceEntry<K, V> entry) {
            this.drainRecencyQueue();
            this.evictionQueue.add(entry);
            if (this.map.expires()) {
                long l2 = this.map.expiresAfterAccess() ? this.map.expireAfterAccessNanos : this.map.expireAfterWriteNanos;
                this.recordExpirationTime(entry, l2);
                this.expirationQueue.add(entry);
            }
        }

        @GuardedBy(value="Segment.this")
        void drainRecencyQueue() {
            ReferenceEntry<K, V> referenceEntry;
            while ((referenceEntry = this.recencyQueue.poll()) != null) {
                if (this.evictionQueue.contains(referenceEntry)) {
                    this.evictionQueue.add(referenceEntry);
                }
                if (!this.map.expiresAfterAccess() || !this.expirationQueue.contains(referenceEntry)) continue;
                this.expirationQueue.add(referenceEntry);
            }
        }

        void recordExpirationTime(ReferenceEntry<K, V> entry, long expirationNanos) {
            entry.setExpirationTime(this.map.ticker.read() + expirationNanos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void tryExpireEntries() {
            if (this.tryLock()) {
                try {
                    this.expireEntries();
                }
                finally {
                    this.unlock();
                }
            }
        }

        @GuardedBy(value="Segment.this")
        void expireEntries() {
            ReferenceEntry<K, V> referenceEntry;
            this.drainRecencyQueue();
            if (this.expirationQueue.isEmpty()) {
                return;
            }
            long l2 = this.map.ticker.read();
            while ((referenceEntry = this.expirationQueue.peek()) != null && this.map.isExpired(referenceEntry, l2)) {
                if (!this.removeEntry(referenceEntry, referenceEntry.getHash(), RemovalCause.EXPIRED)) {
                    throw new AssertionError();
                }
            }
        }

        void enqueueNotification(ReferenceEntry<K, V> entry, RemovalCause cause) {
            this.enqueueNotification(entry.getKey(), entry.getHash(), entry.getValueReference().get(), cause);
        }

        void enqueueNotification(@Nullable K key, int hash, @Nullable V value, RemovalCause cause) {
            if (cause.wasEvicted()) {
                this.statsCounter.recordEviction();
            }
            if (this.map.removalNotificationQueue != DISCARDING_QUEUE) {
                RemovalNotification<K, V> removalNotification = new RemovalNotification<K, V>(key, value, cause);
                this.map.removalNotificationQueue.offer(removalNotification);
            }
        }

        @GuardedBy(value="Segment.this")
        boolean evictEntries() {
            if (this.map.evictsBySize() && this.count >= this.maxSegmentSize) {
                this.drainRecencyQueue();
                ReferenceEntry<K, V> referenceEntry = this.evictionQueue.remove();
                if (!this.removeEntry(referenceEntry, referenceEntry.getHash(), RemovalCause.SIZE)) {
                    throw new AssertionError();
                }
                return true;
            }
            return false;
        }

        ReferenceEntry<K, V> getFirst(int hash) {
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
            return atomicReferenceArray.get(hash & atomicReferenceArray.length() - 1);
        }

        ReferenceEntry<K, V> getEntry(Object key, int hash) {
            for (ReferenceEntry<K, V> referenceEntry = this.getFirst(hash); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                if (referenceEntry.getHash() != hash) continue;
                K k2 = referenceEntry.getKey();
                if (k2 == null) {
                    this.tryDrainReferenceQueues();
                    continue;
                }
                if (!this.map.keyEquivalence.equivalent(key, k2)) continue;
                return referenceEntry;
            }
            return null;
        }

        ReferenceEntry<K, V> getLiveEntry(Object key, int hash) {
            ReferenceEntry<K, V> referenceEntry = this.getEntry(key, hash);
            if (referenceEntry == null) {
                return null;
            }
            if (this.map.expires() && this.map.isExpired(referenceEntry)) {
                this.tryExpireEntries();
                return null;
            }
            return referenceEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V get(Object key, int hash) {
            try {
                if (this.count != 0) {
                    ReferenceEntry<K, V> referenceEntry = this.getLiveEntry(key, hash);
                    if (referenceEntry == null) {
                        V v2 = null;
                        return v2;
                    }
                    V v3 = referenceEntry.getValueReference().get();
                    if (v3 != null) {
                        this.recordRead(referenceEntry);
                    } else {
                        this.tryDrainReferenceQueues();
                    }
                    V v4 = v3;
                    return v4;
                }
                V v5 = null;
                return v5;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean containsKey(Object key, int hash) {
            try {
                if (this.count != 0) {
                    ReferenceEntry<K, V> referenceEntry = this.getLiveEntry(key, hash);
                    if (referenceEntry == null) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    boolean bl3 = referenceEntry.getValueReference().get() != null;
                    return bl3;
                }
                boolean bl4 = false;
                return bl4;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        boolean containsValue(Object value) {
            try {
                if (this.count != 0) {
                    AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                    int n2 = atomicReferenceArray.length();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        for (ReferenceEntry<K, V> referenceEntry = atomicReferenceArray.get(i2); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                            V v2 = this.getLiveValue(referenceEntry);
                            if (v2 == null || !this.map.valueEquivalence.equivalent(value, v2)) continue;
                            boolean bl2 = true;
                            return bl2;
                        }
                    }
                }
                boolean bl3 = false;
                return bl3;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K key, int hash, V value, boolean onlyIfAbsent) {
            this.lock();
            try {
                K k2;
                ReferenceEntry<K, V> referenceEntry;
                ReferenceEntry<K, V> referenceEntry2;
                this.preWriteCleanup();
                int n2 = this.count + 1;
                if (n2 > this.threshold) {
                    this.expand();
                    n2 = this.count + 1;
                }
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                int n3 = hash & atomicReferenceArray.length() - 1;
                for (referenceEntry2 = referenceEntry = atomicReferenceArray.get(n3); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                    k2 = referenceEntry2.getKey();
                    if (referenceEntry2.getHash() != hash || k2 == null || !this.map.keyEquivalence.equivalent(key, k2)) continue;
                    ValueReference<K, V> valueReference = referenceEntry2.getValueReference();
                    V v2 = valueReference.get();
                    if (v2 == null) {
                        ++this.modCount;
                        this.setValue(referenceEntry2, value);
                        if (!valueReference.isComputingReference()) {
                            this.enqueueNotification(key, hash, v2, RemovalCause.COLLECTED);
                            n2 = this.count;
                        } else if (this.evictEntries()) {
                            n2 = this.count + 1;
                        }
                        this.count = n2;
                        V v3 = null;
                        return v3;
                    }
                    if (onlyIfAbsent) {
                        this.recordLockedRead(referenceEntry2);
                        V v4 = v2;
                        return v4;
                    }
                    ++this.modCount;
                    this.enqueueNotification(key, hash, v2, RemovalCause.REPLACED);
                    this.setValue(referenceEntry2, value);
                    V v5 = v2;
                    return v5;
                }
                ++this.modCount;
                referenceEntry2 = this.newEntry(key, hash, referenceEntry);
                this.setValue(referenceEntry2, value);
                atomicReferenceArray.set(n3, referenceEntry2);
                if (this.evictEntries()) {
                    n2 = this.count + 1;
                }
                this.count = n2;
                k2 = null;
                return (V)k2;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        @GuardedBy(value="Segment.this")
        void expand() {
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
            int n2 = atomicReferenceArray.length();
            if (n2 >= 0x40000000) {
                return;
            }
            int n3 = this.count;
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray2 = this.newEntryArray(n2 << 1);
            this.threshold = atomicReferenceArray2.length() * 3 / 4;
            int n4 = atomicReferenceArray2.length() - 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n5;
                ReferenceEntry<K, V> referenceEntry;
                ReferenceEntry<K, V> referenceEntry2 = atomicReferenceArray.get(i2);
                if (referenceEntry2 == null) continue;
                ReferenceEntry<K, V> referenceEntry3 = referenceEntry2.getNext();
                int n6 = referenceEntry2.getHash() & n4;
                if (referenceEntry3 == null) {
                    atomicReferenceArray2.set(n6, referenceEntry2);
                    continue;
                }
                ReferenceEntry<K, V> referenceEntry4 = referenceEntry2;
                int n7 = n6;
                for (referenceEntry = referenceEntry3; referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                    n5 = referenceEntry.getHash() & n4;
                    if (n5 == n7) continue;
                    n7 = n5;
                    referenceEntry4 = referenceEntry;
                }
                atomicReferenceArray2.set(n7, referenceEntry4);
                for (referenceEntry = referenceEntry2; referenceEntry != referenceEntry4; referenceEntry = referenceEntry.getNext()) {
                    if (this.isCollected(referenceEntry)) {
                        this.removeCollectedEntry(referenceEntry);
                        --n3;
                        continue;
                    }
                    n5 = referenceEntry.getHash() & n4;
                    ReferenceEntry<K, V> referenceEntry5 = atomicReferenceArray2.get(n5);
                    ReferenceEntry<K, V> referenceEntry6 = this.copyEntry(referenceEntry, referenceEntry5);
                    atomicReferenceArray2.set(n5, referenceEntry6);
                }
            }
            this.table = atomicReferenceArray2;
            this.count = n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(K key, int hash, V oldValue, V newValue) {
            this.lock();
            try {
                ReferenceEntry<K, V> referenceEntry;
                this.preWriteCleanup();
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                int n2 = hash & atomicReferenceArray.length() - 1;
                for (ReferenceEntry<K, V> referenceEntry2 = referenceEntry = atomicReferenceArray.get(n2); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                    K k2 = referenceEntry2.getKey();
                    if (referenceEntry2.getHash() != hash || k2 == null || !this.map.keyEquivalence.equivalent(key, k2)) continue;
                    ValueReference<K, V> valueReference = referenceEntry2.getValueReference();
                    V v2 = valueReference.get();
                    if (v2 == null) {
                        int n3;
                        if (this.isCollected(valueReference)) {
                            n3 = this.count - 1;
                            ++this.modCount;
                            this.enqueueNotification(k2, hash, v2, RemovalCause.COLLECTED);
                            ReferenceEntry<K, V> referenceEntry3 = this.removeFromChain(referenceEntry, referenceEntry2);
                            n3 = this.count - 1;
                            atomicReferenceArray.set(n2, referenceEntry3);
                            this.count = n3;
                        }
                        n3 = 0;
                        return n3 != 0;
                    }
                    if (this.map.valueEquivalence.equivalent(oldValue, v2)) {
                        ++this.modCount;
                        this.enqueueNotification(key, hash, v2, RemovalCause.REPLACED);
                        this.setValue(referenceEntry2, newValue);
                        boolean bl2 = true;
                        return bl2;
                    }
                    this.recordLockedRead(referenceEntry2);
                    boolean bl3 = false;
                    return bl3;
                }
                boolean bl4 = false;
                return bl4;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(K key, int hash, V newValue) {
            this.lock();
            try {
                ReferenceEntry<K, V> referenceEntry;
                ReferenceEntry<K, V> referenceEntry2;
                this.preWriteCleanup();
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                int n2 = hash & atomicReferenceArray.length() - 1;
                for (referenceEntry2 = referenceEntry = atomicReferenceArray.get(n2); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                    K k2 = referenceEntry2.getKey();
                    if (referenceEntry2.getHash() != hash || k2 == null || !this.map.keyEquivalence.equivalent(key, k2)) continue;
                    ValueReference<K, V> valueReference = referenceEntry2.getValueReference();
                    V v2 = valueReference.get();
                    if (v2 == null) {
                        if (this.isCollected(valueReference)) {
                            int n3 = this.count - 1;
                            ++this.modCount;
                            this.enqueueNotification(k2, hash, v2, RemovalCause.COLLECTED);
                            ReferenceEntry<K, V> referenceEntry3 = this.removeFromChain(referenceEntry, referenceEntry2);
                            n3 = this.count - 1;
                            atomicReferenceArray.set(n2, referenceEntry3);
                            this.count = n3;
                        }
                        V v3 = null;
                        return v3;
                    }
                    ++this.modCount;
                    this.enqueueNotification(key, hash, v2, RemovalCause.REPLACED);
                    this.setValue(referenceEntry2, newValue);
                    V v4 = v2;
                    return v4;
                }
                referenceEntry2 = null;
                return (V)referenceEntry2;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object key, int hash) {
            this.lock();
            try {
                ReferenceEntry<K, V> referenceEntry;
                ReferenceEntry<K, V> referenceEntry2;
                this.preWriteCleanup();
                int n2 = this.count - 1;
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                int n3 = hash & atomicReferenceArray.length() - 1;
                for (referenceEntry2 = referenceEntry = atomicReferenceArray.get(n3); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                    RemovalCause removalCause;
                    K k2 = referenceEntry2.getKey();
                    if (referenceEntry2.getHash() != hash || k2 == null || !this.map.keyEquivalence.equivalent(key, k2)) continue;
                    ValueReference<K, V> valueReference = referenceEntry2.getValueReference();
                    V v2 = valueReference.get();
                    if (v2 != null) {
                        removalCause = RemovalCause.EXPLICIT;
                    } else if (this.isCollected(valueReference)) {
                        removalCause = RemovalCause.COLLECTED;
                    } else {
                        V v3 = null;
                        return v3;
                    }
                    ++this.modCount;
                    this.enqueueNotification(k2, hash, v2, removalCause);
                    ReferenceEntry<K, V> referenceEntry3 = this.removeFromChain(referenceEntry, referenceEntry2);
                    n2 = this.count - 1;
                    atomicReferenceArray.set(n3, referenceEntry3);
                    this.count = n2;
                    V v4 = v2;
                    return v4;
                }
                referenceEntry2 = null;
                return (V)referenceEntry2;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean remove(Object key, int hash, Object value) {
            this.lock();
            try {
                ReferenceEntry<K, V> referenceEntry;
                this.preWriteCleanup();
                int n2 = this.count - 1;
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                int n3 = hash & atomicReferenceArray.length() - 1;
                for (ReferenceEntry<K, V> referenceEntry2 = referenceEntry = atomicReferenceArray.get(n3); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                    RemovalCause removalCause;
                    K k2 = referenceEntry2.getKey();
                    if (referenceEntry2.getHash() != hash || k2 == null || !this.map.keyEquivalence.equivalent(key, k2)) continue;
                    ValueReference<K, V> valueReference = referenceEntry2.getValueReference();
                    V v2 = valueReference.get();
                    if (this.map.valueEquivalence.equivalent(value, v2)) {
                        removalCause = RemovalCause.EXPLICIT;
                    } else if (this.isCollected(valueReference)) {
                        removalCause = RemovalCause.COLLECTED;
                    } else {
                        boolean bl2 = false;
                        return bl2;
                    }
                    ++this.modCount;
                    this.enqueueNotification(k2, hash, v2, removalCause);
                    ReferenceEntry<K, V> referenceEntry3 = this.removeFromChain(referenceEntry, referenceEntry2);
                    n2 = this.count - 1;
                    atomicReferenceArray.set(n3, referenceEntry3);
                    this.count = n2;
                    boolean bl3 = removalCause == RemovalCause.EXPLICIT;
                    return bl3;
                }
                boolean bl4 = false;
                return bl4;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    int n2;
                    AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                    if (this.map.removalNotificationQueue != DISCARDING_QUEUE) {
                        for (n2 = 0; n2 < atomicReferenceArray.length(); ++n2) {
                            for (ReferenceEntry<K, V> referenceEntry = atomicReferenceArray.get(n2); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                                if (referenceEntry.getValueReference().isComputingReference()) continue;
                                this.enqueueNotification(referenceEntry, RemovalCause.EXPLICIT);
                            }
                        }
                    }
                    for (n2 = 0; n2 < atomicReferenceArray.length(); ++n2) {
                        atomicReferenceArray.set(n2, null);
                    }
                    this.clearReferenceQueues();
                    this.evictionQueue.clear();
                    this.expirationQueue.clear();
                    this.readCount.set(0);
                    ++this.modCount;
                    this.count = 0;
                }
                finally {
                    this.unlock();
                    this.postWriteCleanup();
                }
            }
        }

        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> removeFromChain(ReferenceEntry<K, V> first, ReferenceEntry<K, V> entry) {
            this.evictionQueue.remove(entry);
            this.expirationQueue.remove(entry);
            int n2 = this.count;
            ReferenceEntry<K, V> referenceEntry = entry.getNext();
            for (ReferenceEntry<K, V> referenceEntry2 = first; referenceEntry2 != entry; referenceEntry2 = referenceEntry2.getNext()) {
                if (this.isCollected(referenceEntry2)) {
                    this.removeCollectedEntry(referenceEntry2);
                    --n2;
                    continue;
                }
                referenceEntry = this.copyEntry(referenceEntry2, referenceEntry);
            }
            this.count = n2;
            return referenceEntry;
        }

        void removeCollectedEntry(ReferenceEntry<K, V> entry) {
            this.enqueueNotification(entry, RemovalCause.COLLECTED);
            this.evictionQueue.remove(entry);
            this.expirationQueue.remove(entry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean reclaimKey(ReferenceEntry<K, V> entry, int hash) {
            this.lock();
            try {
                ReferenceEntry<K, V> referenceEntry;
                int n2 = this.count - 1;
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                int n3 = hash & atomicReferenceArray.length() - 1;
                for (ReferenceEntry<K, V> referenceEntry2 = referenceEntry = atomicReferenceArray.get(n3); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                    if (referenceEntry2 != entry) continue;
                    ++this.modCount;
                    this.enqueueNotification(referenceEntry2.getKey(), hash, referenceEntry2.getValueReference().get(), RemovalCause.COLLECTED);
                    ReferenceEntry<K, V> referenceEntry3 = this.removeFromChain(referenceEntry, referenceEntry2);
                    n2 = this.count - 1;
                    atomicReferenceArray.set(n3, referenceEntry3);
                    this.count = n2;
                    boolean bl2 = true;
                    return bl2;
                }
                boolean bl3 = false;
                return bl3;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean reclaimValue(K key, int hash, ValueReference<K, V> valueReference) {
            this.lock();
            try {
                ReferenceEntry<K, V> referenceEntry;
                int n2 = this.count - 1;
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                int n3 = hash & atomicReferenceArray.length() - 1;
                for (ReferenceEntry<K, V> referenceEntry2 = referenceEntry = atomicReferenceArray.get(n3); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                    K k2 = referenceEntry2.getKey();
                    if (referenceEntry2.getHash() != hash || k2 == null || !this.map.keyEquivalence.equivalent(key, k2)) continue;
                    ValueReference<K, V> valueReference2 = referenceEntry2.getValueReference();
                    if (valueReference2 == valueReference) {
                        ++this.modCount;
                        this.enqueueNotification(key, hash, valueReference.get(), RemovalCause.COLLECTED);
                        ReferenceEntry<K, V> referenceEntry3 = this.removeFromChain(referenceEntry, referenceEntry2);
                        n2 = this.count - 1;
                        atomicReferenceArray.set(n3, referenceEntry3);
                        this.count = n2;
                        boolean bl2 = true;
                        return bl2;
                    }
                    boolean bl3 = false;
                    return bl3;
                }
                boolean bl4 = false;
                return bl4;
            }
            finally {
                this.unlock();
                if (!this.isHeldByCurrentThread()) {
                    this.postWriteCleanup();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean clearValue(K key, int hash, ValueReference<K, V> valueReference) {
            this.lock();
            try {
                ReferenceEntry<K, V> referenceEntry;
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                int n2 = hash & atomicReferenceArray.length() - 1;
                for (ReferenceEntry<K, V> referenceEntry2 = referenceEntry = atomicReferenceArray.get(n2); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                    K k2 = referenceEntry2.getKey();
                    if (referenceEntry2.getHash() != hash || k2 == null || !this.map.keyEquivalence.equivalent(key, k2)) continue;
                    ValueReference<K, V> valueReference2 = referenceEntry2.getValueReference();
                    if (valueReference2 == valueReference) {
                        ReferenceEntry<K, V> referenceEntry3 = this.removeFromChain(referenceEntry, referenceEntry2);
                        atomicReferenceArray.set(n2, referenceEntry3);
                        boolean bl2 = true;
                        return bl2;
                    }
                    boolean bl3 = false;
                    return bl3;
                }
                boolean bl4 = false;
                return bl4;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        @GuardedBy(value="Segment.this")
        boolean removeEntry(ReferenceEntry<K, V> entry, int hash, RemovalCause cause) {
            ReferenceEntry<K, V> referenceEntry;
            int n2 = this.count - 1;
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
            int n3 = hash & atomicReferenceArray.length() - 1;
            for (ReferenceEntry<K, V> referenceEntry2 = referenceEntry = atomicReferenceArray.get(n3); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                if (referenceEntry2 != entry) continue;
                ++this.modCount;
                this.enqueueNotification(referenceEntry2.getKey(), hash, referenceEntry2.getValueReference().get(), cause);
                ReferenceEntry<K, V> referenceEntry3 = this.removeFromChain(referenceEntry, referenceEntry2);
                n2 = this.count - 1;
                atomicReferenceArray.set(n3, referenceEntry3);
                this.count = n2;
                return true;
            }
            return false;
        }

        boolean isCollected(ReferenceEntry<K, V> entry) {
            if (entry.getKey() == null) {
                return true;
            }
            return this.isCollected(entry.getValueReference());
        }

        boolean isCollected(ValueReference<K, V> valueReference) {
            if (valueReference.isComputingReference()) {
                return false;
            }
            return valueReference.get() == null;
        }

        V getLiveValue(ReferenceEntry<K, V> entry) {
            if (entry.getKey() == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            V v2 = entry.getValueReference().get();
            if (v2 == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            if (this.map.expires() && this.map.isExpired(entry)) {
                this.tryExpireEntries();
                return null;
            }
            return v2;
        }

        void postReadCleanup() {
            if ((this.readCount.incrementAndGet() & 0x3F) == 0) {
                this.cleanUp();
            }
        }

        @GuardedBy(value="Segment.this")
        void preWriteCleanup() {
            this.runLockedCleanup();
        }

        void postWriteCleanup() {
            this.runUnlockedCleanup();
        }

        void cleanUp() {
            this.runLockedCleanup();
            this.runUnlockedCleanup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runLockedCleanup() {
            if (this.tryLock()) {
                try {
                    this.drainReferenceQueues();
                    this.expireEntries();
                    this.readCount.set(0);
                }
                finally {
                    this.unlock();
                }
            }
        }

        void runUnlockedCleanup() {
            if (!this.isHeldByCurrentThread()) {
                this.map.processPendingNotifications();
            }
        }
    }

    static final class StrongValueReference<K, V>
    implements ValueReference<K, V> {
        final V referent;

        StrongValueReference(V referent) {
            this.referent = referent;
        }

        @Override
        public V get() {
            return this.referent;
        }

        @Override
        public ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> queue, ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public boolean isComputingReference() {
            return false;
        }

        @Override
        public V waitForValue() {
            return this.get();
        }

        @Override
        public void notifyNewValue(V newValue) {
        }
    }

    static final class SoftValueReference<K, V>
    extends SoftReference<V>
    implements ValueReference<K, V> {
        final ReferenceEntry<K, V> entry;

        SoftValueReference(ReferenceQueue<V> queue, V referent, ReferenceEntry<K, V> entry) {
            super(referent, queue);
            this.entry = entry;
        }

        @Override
        public ReferenceEntry<K, V> getEntry() {
            return this.entry;
        }

        @Override
        public void notifyNewValue(V newValue) {
            this.clear();
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> queue, ReferenceEntry<K, V> entry) {
            return new SoftValueReference<K, V>(queue, this.get(), entry);
        }

        @Override
        public boolean isComputingReference() {
            return false;
        }

        @Override
        public V waitForValue() {
            return (V)this.get();
        }
    }

    static final class WeakValueReference<K, V>
    extends WeakReference<V>
    implements ValueReference<K, V> {
        final ReferenceEntry<K, V> entry;

        WeakValueReference(ReferenceQueue<V> queue, V referent, ReferenceEntry<K, V> entry) {
            super(referent, queue);
            this.entry = entry;
        }

        @Override
        public ReferenceEntry<K, V> getEntry() {
            return this.entry;
        }

        @Override
        public void notifyNewValue(V newValue) {
            this.clear();
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> queue, ReferenceEntry<K, V> entry) {
            return new WeakValueReference<K, V>(queue, this.get(), entry);
        }

        @Override
        public boolean isComputingReference() {
            return false;
        }

        @Override
        public V waitForValue() {
            return (V)this.get();
        }
    }

    static final class WeakExpirableEvictableEntry<K, V>
    extends WeakEntry<K, V>
    implements ReferenceEntry<K, V> {
        volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextExpirable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousExpirable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextEvictable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousEvictable = CustomConcurrentHashMap.nullEntry();

        WeakExpirableEvictableEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(queue, key, hash, next);
        }

        @Override
        public long getExpirationTime() {
            return this.time;
        }

        @Override
        public void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            this.nextExpirable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            this.previousExpirable = previous;
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            this.nextEvictable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            this.previousEvictable = previous;
        }
    }

    static final class WeakEvictableEntry<K, V>
    extends WeakEntry<K, V>
    implements ReferenceEntry<K, V> {
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextEvictable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousEvictable = CustomConcurrentHashMap.nullEntry();

        WeakEvictableEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(queue, key, hash, next);
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            this.nextEvictable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            this.previousEvictable = previous;
        }
    }

    static final class WeakExpirableEntry<K, V>
    extends WeakEntry<K, V>
    implements ReferenceEntry<K, V> {
        volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextExpirable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousExpirable = CustomConcurrentHashMap.nullEntry();

        WeakExpirableEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(queue, key, hash, next);
        }

        @Override
        public long getExpirationTime() {
            return this.time;
        }

        @Override
        public void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            this.nextExpirable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            this.previousExpirable = previous;
        }
    }

    static class WeakEntry<K, V>
    extends WeakReference<K>
    implements ReferenceEntry<K, V> {
        final int hash;
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = CustomConcurrentHashMap.unset();

        WeakEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(key, queue);
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return (K)this.get();
        }

        @Override
        public long getExpirationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setExpirationTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            this.valueReference = valueReference;
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    static final class SoftExpirableEvictableEntry<K, V>
    extends SoftEntry<K, V>
    implements ReferenceEntry<K, V> {
        volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextExpirable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousExpirable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextEvictable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousEvictable = CustomConcurrentHashMap.nullEntry();

        SoftExpirableEvictableEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(queue, key, hash, next);
        }

        @Override
        public long getExpirationTime() {
            return this.time;
        }

        @Override
        public void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            this.nextExpirable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            this.previousExpirable = previous;
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            this.nextEvictable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            this.previousEvictable = previous;
        }
    }

    static final class SoftEvictableEntry<K, V>
    extends SoftEntry<K, V>
    implements ReferenceEntry<K, V> {
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextEvictable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousEvictable = CustomConcurrentHashMap.nullEntry();

        SoftEvictableEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(queue, key, hash, next);
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            this.nextEvictable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            this.previousEvictable = previous;
        }
    }

    static final class SoftExpirableEntry<K, V>
    extends SoftEntry<K, V>
    implements ReferenceEntry<K, V> {
        volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextExpirable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousExpirable = CustomConcurrentHashMap.nullEntry();

        SoftExpirableEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(queue, key, hash, next);
        }

        @Override
        public long getExpirationTime() {
            return this.time;
        }

        @Override
        public void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            this.nextExpirable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            this.previousExpirable = previous;
        }
    }

    static class SoftEntry<K, V>
    extends SoftReference<K>
    implements ReferenceEntry<K, V> {
        final int hash;
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = CustomConcurrentHashMap.unset();

        SoftEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(key, queue);
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return (K)this.get();
        }

        @Override
        public long getExpirationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setExpirationTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            this.valueReference = valueReference;
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    static final class StrongExpirableEvictableEntry<K, V>
    extends StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextExpirable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousExpirable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextEvictable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousEvictable = CustomConcurrentHashMap.nullEntry();

        StrongExpirableEvictableEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(key, hash, next);
        }

        @Override
        public long getExpirationTime() {
            return this.time;
        }

        @Override
        public void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            this.nextExpirable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            this.previousExpirable = previous;
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            this.nextEvictable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            this.previousEvictable = previous;
        }
    }

    static final class StrongEvictableEntry<K, V>
    extends StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextEvictable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousEvictable = CustomConcurrentHashMap.nullEntry();

        StrongEvictableEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(key, hash, next);
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            this.nextEvictable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            this.previousEvictable = previous;
        }
    }

    static final class StrongExpirableEntry<K, V>
    extends StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> nextExpirable = CustomConcurrentHashMap.nullEntry();
        @GuardedBy(value="Segment.this")
        ReferenceEntry<K, V> previousExpirable = CustomConcurrentHashMap.nullEntry();

        StrongExpirableEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(key, hash, next);
        }

        @Override
        public long getExpirationTime() {
            return this.time;
        }

        @Override
        public void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            this.nextExpirable = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            this.previousExpirable = previous;
        }
    }

    static class StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        final K key;
        final int hash;
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = CustomConcurrentHashMap.unset();

        StrongEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            this.key = key;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public long getExpirationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setExpirationTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            this.valueReference = valueReference;
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    static abstract class AbstractReferenceEntry<K, V>
    implements ReferenceEntry<K, V> {
        AbstractReferenceEntry() {
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getExpirationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setExpirationTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }
    }

    private static enum NullEntry implements ReferenceEntry<Object, Object>
    {
        INSTANCE;


        @Override
        public ValueReference<Object, Object> getValueReference() {
            return null;
        }

        @Override
        public void setValueReference(ValueReference<Object, Object> valueReference) {
        }

        @Override
        public ReferenceEntry<Object, Object> getNext() {
            return null;
        }

        @Override
        public int getHash() {
            return 0;
        }

        @Override
        public Object getKey() {
            return null;
        }

        @Override
        public long getExpirationTime() {
            return 0L;
        }

        @Override
        public void setExpirationTime(long time) {
        }

        @Override
        public ReferenceEntry<Object, Object> getNextExpirable() {
            return this;
        }

        @Override
        public void setNextExpirable(ReferenceEntry<Object, Object> next) {
        }

        @Override
        public ReferenceEntry<Object, Object> getPreviousExpirable() {
            return this;
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<Object, Object> previous) {
        }

        @Override
        public ReferenceEntry<Object, Object> getNextEvictable() {
            return this;
        }

        @Override
        public void setNextEvictable(ReferenceEntry<Object, Object> next) {
        }

        @Override
        public ReferenceEntry<Object, Object> getPreviousEvictable() {
            return this;
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<Object, Object> previous) {
        }
    }

    static interface ReferenceEntry<K, V> {
        public ValueReference<K, V> getValueReference();

        public void setValueReference(ValueReference<K, V> var1);

        public ReferenceEntry<K, V> getNext();

        public int getHash();

        public K getKey();

        public long getExpirationTime();

        public void setExpirationTime(long var1);

        public ReferenceEntry<K, V> getNextExpirable();

        public void setNextExpirable(ReferenceEntry<K, V> var1);

        public ReferenceEntry<K, V> getPreviousExpirable();

        public void setPreviousExpirable(ReferenceEntry<K, V> var1);

        public ReferenceEntry<K, V> getNextEvictable();

        public void setNextEvictable(ReferenceEntry<K, V> var1);

        public ReferenceEntry<K, V> getPreviousEvictable();

        public void setPreviousEvictable(ReferenceEntry<K, V> var1);
    }

    static interface ValueReference<K, V> {
        public V get();

        public V waitForValue() throws ExecutionException;

        public ReferenceEntry<K, V> getEntry();

        public ValueReference<K, V> copyFor(ReferenceQueue<V> var1, ReferenceEntry<K, V> var2);

        public void notifyNewValue(V var1);

        public boolean isComputingReference();
    }

    static enum EntryFactory {
        STRONG{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new StrongEntry<K, V>(key, hash, next);
            }
        }
        ,
        STRONG_EXPIRABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new StrongExpirableEntry<K, V>(key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> referenceEntry = super.copyEntry(segment, original, newNext);
                this.copyExpirableEntry(original, referenceEntry);
                return referenceEntry;
            }
        }
        ,
        STRONG_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new StrongEvictableEntry<K, V>(key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> referenceEntry = super.copyEntry(segment, original, newNext);
                this.copyEvictableEntry(original, referenceEntry);
                return referenceEntry;
            }
        }
        ,
        STRONG_EXPIRABLE_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new StrongExpirableEvictableEntry<K, V>(key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> referenceEntry = super.copyEntry(segment, original, newNext);
                this.copyExpirableEntry(original, referenceEntry);
                this.copyEvictableEntry(original, referenceEntry);
                return referenceEntry;
            }
        }
        ,
        SOFT{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new SoftEntry(segment.keyReferenceQueue, key, hash, next);
            }
        }
        ,
        SOFT_EXPIRABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new SoftExpirableEntry(segment.keyReferenceQueue, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> referenceEntry = super.copyEntry(segment, original, newNext);
                this.copyExpirableEntry(original, referenceEntry);
                return referenceEntry;
            }
        }
        ,
        SOFT_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new SoftEvictableEntry(segment.keyReferenceQueue, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> referenceEntry = super.copyEntry(segment, original, newNext);
                this.copyEvictableEntry(original, referenceEntry);
                return referenceEntry;
            }
        }
        ,
        SOFT_EXPIRABLE_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new SoftExpirableEvictableEntry(segment.keyReferenceQueue, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> referenceEntry = super.copyEntry(segment, original, newNext);
                this.copyExpirableEntry(original, referenceEntry);
                this.copyEvictableEntry(original, referenceEntry);
                return referenceEntry;
            }
        }
        ,
        WEAK{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new WeakEntry(segment.keyReferenceQueue, key, hash, next);
            }
        }
        ,
        WEAK_EXPIRABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new WeakExpirableEntry(segment.keyReferenceQueue, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> referenceEntry = super.copyEntry(segment, original, newNext);
                this.copyExpirableEntry(original, referenceEntry);
                return referenceEntry;
            }
        }
        ,
        WEAK_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new WeakEvictableEntry(segment.keyReferenceQueue, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> referenceEntry = super.copyEntry(segment, original, newNext);
                this.copyEvictableEntry(original, referenceEntry);
                return referenceEntry;
            }
        }
        ,
        WEAK_EXPIRABLE_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new WeakExpirableEvictableEntry(segment.keyReferenceQueue, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> referenceEntry = super.copyEntry(segment, original, newNext);
                this.copyExpirableEntry(original, referenceEntry);
                this.copyEvictableEntry(original, referenceEntry);
                return referenceEntry;
            }
        };

        static final int EXPIRABLE_MASK = 1;
        static final int EVICTABLE_MASK = 2;
        static final EntryFactory[][] factories;

        static EntryFactory getFactory(Strength keyStrength, boolean expireAfterWrite, boolean evictsBySize) {
            int n2 = (expireAfterWrite ? 1 : 0) | (evictsBySize ? 2 : 0);
            return factories[keyStrength.ordinal()][n2];
        }

        abstract <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> var1, K var2, int var3, @Nullable ReferenceEntry<K, V> var4);

        @GuardedBy(value="Segment.this")
        <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
            return this.newEntry(segment, original.getKey(), original.getHash(), newNext);
        }

        @GuardedBy(value="Segment.this")
        <K, V> void copyExpirableEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newEntry) {
            newEntry.setExpirationTime(original.getExpirationTime());
            CustomConcurrentHashMap.connectExpirables(original.getPreviousExpirable(), newEntry);
            CustomConcurrentHashMap.connectExpirables(newEntry, original.getNextExpirable());
            CustomConcurrentHashMap.nullifyExpirable(original);
        }

        @GuardedBy(value="Segment.this")
        <K, V> void copyEvictableEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newEntry) {
            CustomConcurrentHashMap.connectEvictables(original.getPreviousEvictable(), newEntry);
            CustomConcurrentHashMap.connectEvictables(newEntry, original.getNextEvictable());
            CustomConcurrentHashMap.nullifyEvictable(original);
        }

        static {
            factories = new EntryFactory[][]{{STRONG, STRONG_EXPIRABLE, STRONG_EVICTABLE, STRONG_EXPIRABLE_EVICTABLE}, {SOFT, SOFT_EXPIRABLE, SOFT_EVICTABLE, SOFT_EXPIRABLE_EVICTABLE}, {WEAK, WEAK_EXPIRABLE, WEAK_EVICTABLE, WEAK_EXPIRABLE_EVICTABLE}};
        }
    }

    static enum Strength {
        STRONG{

            @Override
            <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> entry, V value) {
                return new StrongValueReference(value);
            }

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalences.equals();
            }
        }
        ,
        SOFT{

            @Override
            <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> entry, V value) {
                return new SoftValueReference(segment.valueReferenceQueue, value, entry);
            }

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalences.identity();
            }
        }
        ,
        WEAK{

            @Override
            <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> entry, V value) {
                return new WeakValueReference(segment.valueReferenceQueue, value, entry);
            }

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalences.identity();
            }
        };


        abstract <K, V> ValueReference<K, V> referenceValue(Segment<K, V> var1, ReferenceEntry<K, V> var2, V var3);

        abstract Equivalence<Object> defaultEquivalence();
    }
}

