/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.collect.BstAggregate;
import com.timevale.esign.paas.guava.common.collect.BstBalancePolicy;
import com.timevale.esign.paas.guava.common.collect.BstMutationResult;
import com.timevale.esign.paas.guava.common.collect.BstNode;
import com.timevale.esign.paas.guava.common.collect.BstNodeFactory;
import com.timevale.esign.paas.guava.common.collect.BstOperations;
import com.timevale.esign.paas.guava.common.collect.BstSide;
import javax.annotation.Nullable;

@GwtCompatible
final class BstCountBasedBalancePolicies {
    private static final int SINGLE_ROTATE_RATIO = 4;
    private static final int SECOND_ROTATE_RATIO = 2;

    private BstCountBasedBalancePolicies() {
    }

    public static <N extends BstNode<?, N>> BstBalancePolicy<N> noRebalancePolicy(final BstAggregate<N> countAggregate) {
        Preconditions.checkNotNull(countAggregate);
        return new BstBalancePolicy<N>(){

            @Override
            public N balance(BstNodeFactory<N> nodeFactory, N source, @Nullable N left, @Nullable N right) {
                return Preconditions.checkNotNull(nodeFactory).createNode(source, left, right);
            }

            @Override
            @Nullable
            public N combine(BstNodeFactory<N> nodeFactory, @Nullable N left, @Nullable N right) {
                if (left == null) {
                    return right;
                }
                if (right == null) {
                    return left;
                }
                if (countAggregate.treeValue(left) > countAggregate.treeValue(right)) {
                    return nodeFactory.createNode(left, ((BstNode)left).childOrNull(BstSide.LEFT), this.combine(nodeFactory, ((BstNode)left).childOrNull(BstSide.RIGHT), right));
                }
                return nodeFactory.createNode(right, this.combine(nodeFactory, left, ((BstNode)right).childOrNull(BstSide.LEFT)), ((BstNode)right).childOrNull(BstSide.RIGHT));
            }
        };
    }

    public static <K, N extends BstNode<K, N>> BstBalancePolicy<N> singleRebalancePolicy(final BstAggregate<N> countAggregate) {
        Preconditions.checkNotNull(countAggregate);
        return new BstBalancePolicy<N>(){

            @Override
            public N balance(BstNodeFactory<N> nodeFactory, N source, @Nullable N left, @Nullable N right) {
                int n2;
                int n3 = countAggregate.treeValue(left);
                if (n3 + (n2 = countAggregate.treeValue(right)) > 1) {
                    if (n2 >= 4 * n3) {
                        return this.rotateL(nodeFactory, source, left, right);
                    }
                    if (n3 >= 4 * n2) {
                        return this.rotateR(nodeFactory, source, left, right);
                    }
                }
                return nodeFactory.createNode(source, left, right);
            }

            private N rotateL(BstNodeFactory<N> nodeFactory, N source, @Nullable N left, N right) {
                Preconditions.checkNotNull(right);
                Object n2 = ((BstNode)right).childOrNull(BstSide.LEFT);
                Object n3 = ((BstNode)right).childOrNull(BstSide.RIGHT);
                if (countAggregate.treeValue(n2) >= 2 * countAggregate.treeValue(n3)) {
                    right = this.singleR(nodeFactory, right, n2, n3);
                }
                return this.singleL(nodeFactory, source, left, right);
            }

            private N rotateR(BstNodeFactory<N> nodeFactory, N source, N left, @Nullable N right) {
                Preconditions.checkNotNull(left);
                Object n2 = ((BstNode)left).childOrNull(BstSide.RIGHT);
                Object n3 = ((BstNode)left).childOrNull(BstSide.LEFT);
                if (countAggregate.treeValue(n2) >= 2 * countAggregate.treeValue(n3)) {
                    left = this.singleL(nodeFactory, left, n3, n2);
                }
                return this.singleR(nodeFactory, source, left, right);
            }

            private N singleL(BstNodeFactory<N> nodeFactory, N source, @Nullable N left, N right) {
                Preconditions.checkNotNull(right);
                return nodeFactory.createNode(right, nodeFactory.createNode(source, left, ((BstNode)right).childOrNull(BstSide.LEFT)), ((BstNode)right).childOrNull(BstSide.RIGHT));
            }

            private N singleR(BstNodeFactory<N> nodeFactory, N source, N left, @Nullable N right) {
                Preconditions.checkNotNull(left);
                return nodeFactory.createNode(left, ((BstNode)left).childOrNull(BstSide.LEFT), nodeFactory.createNode(source, ((BstNode)left).childOrNull(BstSide.RIGHT), right));
            }

            @Override
            @Nullable
            public N combine(BstNodeFactory<N> nodeFactory, @Nullable N left, @Nullable N right) {
                Object n2;
                if (left == null) {
                    return right;
                }
                if (right == null) {
                    return left;
                }
                if (countAggregate.treeValue(left) > countAggregate.treeValue(right)) {
                    BstMutationResult bstMutationResult = BstOperations.extractMax(left, nodeFactory, this);
                    n2 = bstMutationResult.getOriginalTarget();
                    left = bstMutationResult.getChangedRoot();
                } else {
                    BstMutationResult bstMutationResult = BstOperations.extractMin(right, nodeFactory, this);
                    n2 = bstMutationResult.getOriginalTarget();
                    right = bstMutationResult.getChangedRoot();
                }
                return nodeFactory.createNode(n2, left, right);
            }
        };
    }

    public static <K, N extends BstNode<K, N>> BstBalancePolicy<N> fullRebalancePolicy(final BstAggregate<N> countAggregate) {
        Preconditions.checkNotNull(countAggregate);
        final BstBalancePolicy<N> bstBalancePolicy = BstCountBasedBalancePolicies.singleRebalancePolicy(countAggregate);
        return new BstBalancePolicy<N>(){

            @Override
            public N balance(BstNodeFactory<N> nodeFactory, N source, @Nullable N left, @Nullable N right) {
                int n2;
                if (left == null) {
                    return BstOperations.insertMin(right, source, nodeFactory, bstBalancePolicy);
                }
                if (right == null) {
                    return BstOperations.insertMax(left, source, nodeFactory, bstBalancePolicy);
                }
                int n3 = countAggregate.treeValue(left);
                if (4 * n3 <= (n2 = countAggregate.treeValue(right))) {
                    Object n4 = this.balance(nodeFactory, source, left, ((BstNode)right).childOrNull(BstSide.LEFT));
                    return bstBalancePolicy.balance(nodeFactory, right, n4, ((BstNode)right).childOrNull(BstSide.RIGHT));
                }
                if (4 * n2 <= n3) {
                    Object n5 = this.balance(nodeFactory, source, ((BstNode)left).childOrNull(BstSide.RIGHT), right);
                    return bstBalancePolicy.balance(nodeFactory, left, ((BstNode)left).childOrNull(BstSide.LEFT), n5);
                }
                return nodeFactory.createNode(source, left, right);
            }

            @Override
            @Nullable
            public N combine(BstNodeFactory<N> nodeFactory, @Nullable N left, @Nullable N right) {
                int n2;
                if (left == null) {
                    return right;
                }
                if (right == null) {
                    return left;
                }
                int n3 = countAggregate.treeValue(left);
                if (4 * n3 <= (n2 = countAggregate.treeValue(right))) {
                    Object n4 = this.combine(nodeFactory, left, ((BstNode)right).childOrNull(BstSide.LEFT));
                    return bstBalancePolicy.balance(nodeFactory, right, n4, ((BstNode)right).childOrNull(BstSide.RIGHT));
                }
                if (4 * n2 <= n3) {
                    Object n5 = this.combine(nodeFactory, ((BstNode)left).childOrNull(BstSide.RIGHT), right);
                    return bstBalancePolicy.balance(nodeFactory, left, ((BstNode)left).childOrNull(BstSide.LEFT), n5);
                }
                return bstBalancePolicy.combine(nodeFactory, left, right);
            }
        };
    }
}

