/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.annotations.GwtIncompatible;
import com.timevale.esign.paas.guava.common.collect.AbstractMapBasedMultiset;
import com.timevale.esign.paas.guava.common.collect.Iterables;
import com.timevale.esign.paas.guava.common.collect.Maps;
import com.timevale.esign.paas.guava.common.collect.Multisets;
import com.timevale.esign.paas.guava.common.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;

@GwtCompatible(serializable=true, emulated=true)
public final class HashMultiset<E>
extends AbstractMapBasedMultiset<E> {
    @GwtIncompatible(value="Not needed in emulated source.")
    private static final long serialVersionUID = 0L;

    public static <E> HashMultiset<E> create() {
        return new HashMultiset<E>();
    }

    public static <E> HashMultiset<E> create(int distinctElements) {
        return new HashMultiset<E>(distinctElements);
    }

    public static <E> HashMultiset<E> create(Iterable<? extends E> elements) {
        HashMultiset<E> hashMultiset = HashMultiset.create(Multisets.inferDistinctElements(elements));
        Iterables.addAll(hashMultiset, elements);
        return hashMultiset;
    }

    private HashMultiset() {
        super(new HashMap());
    }

    private HashMultiset(int distinctElements) {
        super(Maps.newHashMapWithExpectedSize(distinctElements));
    }

    @GwtIncompatible(value="java.io.ObjectOutputStream")
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMultiset(this, stream);
    }

    @GwtIncompatible(value="java.io.ObjectInputStream")
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int n2 = Serialization.readCount(stream);
        this.setBackingMap(Maps.newHashMapWithExpectedSize(n2));
        Serialization.populateMultiset(this, stream, n2);
    }
}

