/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.annotations.GwtIncompatible;
import com.timevale.esign.paas.guava.common.annotations.VisibleForTesting;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.collect.AbstractSetMultimap;
import com.timevale.esign.paas.guava.common.collect.ForwardingSet;
import com.timevale.esign.paas.guava.common.collect.Lists;
import com.timevale.esign.paas.guava.common.collect.Maps;
import com.timevale.esign.paas.guava.common.collect.Multimap;
import com.timevale.esign.paas.guava.common.collect.Serialization;
import com.timevale.esign.paas.guava.common.collect.Sets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true, emulated=true)
public final class LinkedHashMultimap<K, V>
extends AbstractSetMultimap<K, V> {
    private static final int DEFAULT_VALUES_PER_KEY = 8;
    @VisibleForTesting
    transient int expectedValuesPerKey = 8;
    transient Collection<Map.Entry<K, V>> linkedEntries;
    @GwtIncompatible(value="java serialization not supported")
    private static final long serialVersionUID = 0L;

    public static <K, V> LinkedHashMultimap<K, V> create() {
        return new LinkedHashMultimap<K, V>();
    }

    public static <K, V> LinkedHashMultimap<K, V> create(int expectedKeys, int expectedValuesPerKey) {
        return new LinkedHashMultimap<K, V>(expectedKeys, expectedValuesPerKey);
    }

    public static <K, V> LinkedHashMultimap<K, V> create(Multimap<? extends K, ? extends V> multimap) {
        return new LinkedHashMultimap<K, V>(multimap);
    }

    private LinkedHashMultimap() {
        super(new LinkedHashMap());
        this.linkedEntries = Sets.newLinkedHashSet();
    }

    private LinkedHashMultimap(int expectedKeys, int expectedValuesPerKey) {
        super(new LinkedHashMap(expectedKeys));
        Preconditions.checkArgument(expectedValuesPerKey >= 0);
        this.expectedValuesPerKey = expectedValuesPerKey;
        this.linkedEntries = new LinkedHashSet<Map.Entry<K, V>>((int)Math.min(0x40000000L, (long)expectedKeys * (long)expectedValuesPerKey));
    }

    private LinkedHashMultimap(Multimap<? extends K, ? extends V> multimap) {
        super(new LinkedHashMap(Maps.capacity(multimap.keySet().size())));
        this.linkedEntries = new LinkedHashSet<Map.Entry<K, V>>(Maps.capacity(multimap.size()));
        this.putAll(multimap);
    }

    @Override
    Set<V> createCollection() {
        return new LinkedHashSet(Maps.capacity(this.expectedValuesPerKey));
    }

    @Override
    Collection<V> createCollection(@Nullable K key) {
        return new SetDecorator(key, this.createCollection());
    }

    @Override
    Iterator<Map.Entry<K, V>> createEntryIterator() {
        final Iterator<Map.Entry<K, V>> iterator = this.linkedEntries.iterator();
        return new Iterator<Map.Entry<K, V>>(){
            Map.Entry<K, V> entry;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                this.entry = (Map.Entry)iterator.next();
                return this.entry;
            }

            @Override
            public void remove() {
                iterator.remove();
                LinkedHashMultimap.this.remove(this.entry.getKey(), this.entry.getValue());
            }
        };
    }

    @Override
    public Set<V> replaceValues(@Nullable K key, Iterable<? extends V> values) {
        return super.replaceValues((Object)key, (Iterable)values);
    }

    @Override
    public Set<Map.Entry<K, V>> entries() {
        return super.entries();
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    @GwtIncompatible(value="java.io.ObjectOutputStream")
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.expectedValuesPerKey);
        Serialization.writeMultimap(this, stream);
        for (Map.Entry<K, V> entry : this.linkedEntries) {
            stream.writeObject(entry.getKey());
            stream.writeObject(entry.getValue());
        }
    }

    @GwtIncompatible(value="java.io.ObjectInputStream")
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.expectedValuesPerKey = stream.readInt();
        int n2 = Serialization.readCount(stream);
        this.setMap(new LinkedHashMap(Maps.capacity(n2)));
        this.linkedEntries = new LinkedHashSet<Map.Entry<K, V>>(n2 * this.expectedValuesPerKey);
        Serialization.populateMultimap(this, stream, n2);
        this.linkedEntries.clear();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            Object object = stream.readObject();
            Object object2 = stream.readObject();
            this.linkedEntries.add(Maps.immutableEntry(object, object2));
        }
    }

    private class SetDecorator
    extends ForwardingSet<V> {
        final Set<V> delegate;
        final K key;

        SetDecorator(K key, Set<V> delegate) {
            this.delegate = delegate;
            this.key = key;
        }

        @Override
        protected Set<V> delegate() {
            return this.delegate;
        }

        <E> Map.Entry<K, E> createEntry(@Nullable E value) {
            return Maps.immutableEntry(this.key, value);
        }

        <E> Collection<Map.Entry<K, E>> createEntries(Collection<E> values) {
            ArrayList arrayList = Lists.newArrayListWithExpectedSize(values.size());
            for (E e2 : values) {
                arrayList.add(this.createEntry(e2));
            }
            return arrayList;
        }

        @Override
        public boolean add(@Nullable V value) {
            boolean bl2 = this.delegate.add(value);
            if (bl2) {
                LinkedHashMultimap.this.linkedEntries.add(this.createEntry(value));
            }
            return bl2;
        }

        @Override
        public boolean addAll(Collection<? extends V> values) {
            boolean bl2 = this.delegate.addAll(values);
            if (bl2) {
                LinkedHashMultimap.this.linkedEntries.addAll(this.createEntries(this.delegate()));
            }
            return bl2;
        }

        @Override
        public void clear() {
            for (Object v2 : this.delegate) {
                LinkedHashMultimap.this.linkedEntries.remove(this.createEntry(v2));
            }
            this.delegate.clear();
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator iterator = this.delegate.iterator();
            return new Iterator<V>(){
                V value;

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public V next() {
                    this.value = iterator.next();
                    return this.value;
                }

                @Override
                public void remove() {
                    iterator.remove();
                    LinkedHashMultimap.this.linkedEntries.remove(SetDecorator.this.createEntry(this.value));
                }
            };
        }

        @Override
        public boolean remove(@Nullable Object value) {
            boolean bl2 = this.delegate.remove(value);
            if (bl2) {
                LinkedHashMultimap.this.linkedEntries.remove(this.createEntry(value));
            }
            return bl2;
        }

        @Override
        public boolean removeAll(Collection<?> values) {
            boolean bl2 = this.delegate.removeAll(values);
            if (bl2) {
                LinkedHashMultimap.this.linkedEntries.removeAll(this.createEntries(values));
            }
            return bl2;
        }

        @Override
        public boolean retainAll(Collection<?> values) {
            boolean bl2 = false;
            Iterator iterator = this.delegate.iterator();
            while (iterator.hasNext()) {
                Object v2 = iterator.next();
                if (values.contains(v2)) continue;
                iterator.remove();
                LinkedHashMultimap.this.linkedEntries.remove(Maps.immutableEntry(this.key, v2));
                bl2 = true;
            }
            return bl2;
        }
    }
}

