/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.annotations.GwtIncompatible;
import com.timevale.esign.paas.guava.common.base.Objects;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.collect.AbstractMapEntry;
import com.timevale.esign.paas.guava.common.collect.Iterators;
import com.timevale.esign.paas.guava.common.collect.LinkedHashMultiset;
import com.timevale.esign.paas.guava.common.collect.ListMultimap;
import com.timevale.esign.paas.guava.common.collect.Lists;
import com.timevale.esign.paas.guava.common.collect.Maps;
import com.timevale.esign.paas.guava.common.collect.Multimap;
import com.timevale.esign.paas.guava.common.collect.Multiset;
import com.timevale.esign.paas.guava.common.collect.Multisets;
import com.timevale.esign.paas.guava.common.collect.Sets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true, emulated=true)
public class LinkedListMultimap<K, V>
implements ListMultimap<K, V>,
Serializable {
    private transient Node<K, V> head;
    private transient Node<K, V> tail;
    private transient Multiset<K> keyCount;
    private transient Map<K, Node<K, V>> keyToKeyHead;
    private transient Map<K, Node<K, V>> keyToKeyTail;
    private transient Set<K> keySet;
    private transient Multiset<K> keys;
    private transient List<V> valuesList;
    private transient List<Map.Entry<K, V>> entries;
    private transient Map<K, Collection<V>> map;
    @GwtIncompatible(value="java serialization not supported")
    private static final long serialVersionUID = 0L;

    public static <K, V> LinkedListMultimap<K, V> create() {
        return new LinkedListMultimap<K, V>();
    }

    public static <K, V> LinkedListMultimap<K, V> create(int expectedKeys) {
        return new LinkedListMultimap<K, V>(expectedKeys);
    }

    public static <K, V> LinkedListMultimap<K, V> create(Multimap<? extends K, ? extends V> multimap) {
        return new LinkedListMultimap<K, V>(multimap);
    }

    LinkedListMultimap() {
        this.keyCount = LinkedHashMultiset.create();
        this.keyToKeyHead = Maps.newHashMap();
        this.keyToKeyTail = Maps.newHashMap();
    }

    private LinkedListMultimap(int expectedKeys) {
        this.keyCount = LinkedHashMultiset.create(expectedKeys);
        this.keyToKeyHead = Maps.newHashMapWithExpectedSize(expectedKeys);
        this.keyToKeyTail = Maps.newHashMapWithExpectedSize(expectedKeys);
    }

    private LinkedListMultimap(Multimap<? extends K, ? extends V> multimap) {
        this(multimap.keySet().size());
        this.putAll(multimap);
    }

    private Node<K, V> addNode(@Nullable K key, @Nullable V value, @Nullable Node<K, V> nextSibling) {
        Node<K, V> node = new Node<K, V>(key, value);
        if (this.head == null) {
            this.tail = node;
            this.head = this.tail;
            this.keyToKeyHead.put(key, node);
            this.keyToKeyTail.put(key, node);
        } else if (nextSibling == null) {
            this.tail.next = node;
            node.previous = this.tail;
            Node<K, V> node2 = this.keyToKeyTail.get(key);
            if (node2 == null) {
                this.keyToKeyHead.put(key, node);
            } else {
                node2.nextSibling = node;
                node.previousSibling = node2;
            }
            this.keyToKeyTail.put(key, node);
            this.tail = node;
        } else {
            node.previous = nextSibling.previous;
            node.previousSibling = nextSibling.previousSibling;
            node.next = nextSibling;
            node.nextSibling = nextSibling;
            if (nextSibling.previousSibling == null) {
                this.keyToKeyHead.put(key, node);
            } else {
                nextSibling.previousSibling.nextSibling = node;
            }
            if (nextSibling.previous == null) {
                this.head = node;
            } else {
                nextSibling.previous.next = node;
            }
            nextSibling.previous = node;
            nextSibling.previousSibling = node;
        }
        this.keyCount.add(key);
        return node;
    }

    private void removeNode(Node<K, V> node) {
        if (node.previous != null) {
            node.previous.next = node.next;
        } else {
            this.head = node.next;
        }
        if (node.next != null) {
            node.next.previous = node.previous;
        } else {
            this.tail = node.previous;
        }
        if (node.previousSibling != null) {
            node.previousSibling.nextSibling = node.nextSibling;
        } else if (node.nextSibling != null) {
            this.keyToKeyHead.put(node.key, node.nextSibling);
        } else {
            this.keyToKeyHead.remove(node.key);
        }
        if (node.nextSibling != null) {
            node.nextSibling.previousSibling = node.previousSibling;
        } else if (node.previousSibling != null) {
            this.keyToKeyTail.put(node.key, node.previousSibling);
        } else {
            this.keyToKeyTail.remove(node.key);
        }
        this.keyCount.remove(node.key);
    }

    private void removeAllNodes(@Nullable Object key) {
        ValueForKeyIterator valueForKeyIterator = new ValueForKeyIterator(key);
        while (valueForKeyIterator.hasNext()) {
            valueForKeyIterator.next();
            valueForKeyIterator.remove();
        }
    }

    private static void checkElement(@Nullable Object node) {
        if (node == null) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public int size() {
        return this.keyCount.size();
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.keyToKeyHead.containsKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        NodeIterator nodeIterator = new NodeIterator();
        while (nodeIterator.hasNext()) {
            if (!Objects.equal(((Node)nodeIterator.next()).value, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntry(@Nullable Object key, @Nullable Object value) {
        ValueForKeyIterator valueForKeyIterator = new ValueForKeyIterator(key);
        while (valueForKeyIterator.hasNext()) {
            if (!Objects.equal(valueForKeyIterator.next(), value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean put(@Nullable K key, @Nullable V value) {
        this.addNode(key, value, null);
        return true;
    }

    @Override
    public boolean remove(@Nullable Object key, @Nullable Object value) {
        ValueForKeyIterator valueForKeyIterator = new ValueForKeyIterator(key);
        while (valueForKeyIterator.hasNext()) {
            if (!Objects.equal(valueForKeyIterator.next(), value)) continue;
            valueForKeyIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean putAll(@Nullable K key, Iterable<? extends V> values) {
        boolean bl2 = false;
        for (V v2 : values) {
            bl2 |= this.put(key, v2);
        }
        return bl2;
    }

    @Override
    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        boolean bl2 = false;
        for (Map.Entry<K, V> entry : multimap.entries()) {
            bl2 |= this.put(entry.getKey(), entry.getValue());
        }
        return bl2;
    }

    @Override
    public List<V> replaceValues(@Nullable K key, Iterable<? extends V> values) {
        List<V> list = this.getCopy(key);
        ValueForKeyIterator valueForKeyIterator = new ValueForKeyIterator(key);
        Iterator<V> iterator = values.iterator();
        while (valueForKeyIterator.hasNext() && iterator.hasNext()) {
            valueForKeyIterator.next();
            valueForKeyIterator.set(iterator.next());
        }
        while (valueForKeyIterator.hasNext()) {
            valueForKeyIterator.next();
            valueForKeyIterator.remove();
        }
        while (iterator.hasNext()) {
            valueForKeyIterator.add(iterator.next());
        }
        return list;
    }

    private List<V> getCopy(@Nullable Object key) {
        return Collections.unmodifiableList(Lists.newArrayList(new ValueForKeyIterator(key)));
    }

    @Override
    public List<V> removeAll(@Nullable Object key) {
        List<V> list = this.getCopy(key);
        this.removeAllNodes(key);
        return list;
    }

    @Override
    public void clear() {
        this.head = null;
        this.tail = null;
        this.keyCount.clear();
        this.keyToKeyHead.clear();
        this.keyToKeyTail.clear();
    }

    @Override
    public List<V> get(final @Nullable K key) {
        return new AbstractSequentialList<V>(){

            @Override
            public int size() {
                return LinkedListMultimap.this.keyCount.count(key);
            }

            @Override
            public ListIterator<V> listIterator(int index) {
                return new ValueForKeyIterator(key, index);
            }

            @Override
            public boolean removeAll(Collection<?> c2) {
                return Iterators.removeAll(this.iterator(), c2);
            }

            @Override
            public boolean retainAll(Collection<?> c2) {
                return Iterators.retainAll(this.iterator(), c2);
            }
        };
    }

    @Override
    public Set<K> keySet() {
        AbstractSet abstractSet = this.keySet;
        if (abstractSet == null) {
            this.keySet = abstractSet = new AbstractSet<K>(){

                @Override
                public int size() {
                    return LinkedListMultimap.this.keyCount.elementSet().size();
                }

                @Override
                public Iterator<K> iterator() {
                    return new DistinctKeyIterator();
                }

                @Override
                public boolean contains(Object key) {
                    return LinkedListMultimap.this.keyCount.contains(key);
                }

                @Override
                public boolean removeAll(Collection<?> c2) {
                    Preconditions.checkNotNull(c2);
                    return super.removeAll(c2);
                }
            };
        }
        return abstractSet;
    }

    @Override
    public Multiset<K> keys() {
        MultisetView multisetView = this.keys;
        if (multisetView == null) {
            this.keys = multisetView = new MultisetView();
        }
        return multisetView;
    }

    @Override
    public List<V> values() {
        AbstractSequentialList abstractSequentialList = this.valuesList;
        if (abstractSequentialList == null) {
            this.valuesList = abstractSequentialList = new AbstractSequentialList<V>(){

                @Override
                public int size() {
                    return LinkedListMultimap.this.keyCount.size();
                }

                @Override
                public ListIterator<V> listIterator(int index) {
                    final NodeIterator nodeIterator = new NodeIterator(index);
                    return new ListIterator<V>(){

                        @Override
                        public boolean hasNext() {
                            return nodeIterator.hasNext();
                        }

                        @Override
                        public V next() {
                            return ((Node)nodeIterator.next()).value;
                        }

                        @Override
                        public boolean hasPrevious() {
                            return nodeIterator.hasPrevious();
                        }

                        @Override
                        public V previous() {
                            return ((Node)nodeIterator.previous()).value;
                        }

                        @Override
                        public int nextIndex() {
                            return nodeIterator.nextIndex();
                        }

                        @Override
                        public int previousIndex() {
                            return nodeIterator.previousIndex();
                        }

                        @Override
                        public void remove() {
                            nodeIterator.remove();
                        }

                        @Override
                        public void set(V e2) {
                            nodeIterator.setValue(e2);
                        }

                        @Override
                        public void add(V e2) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
        return abstractSequentialList;
    }

    private static <K, V> Map.Entry<K, V> createEntry(final Node<K, V> node) {
        return new AbstractMapEntry<K, V>(){

            @Override
            public K getKey() {
                return node.key;
            }

            @Override
            public V getValue() {
                return node.value;
            }

            @Override
            public V setValue(V value) {
                Object v2 = node.value;
                node.value = value;
                return v2;
            }
        };
    }

    @Override
    public List<Map.Entry<K, V>> entries() {
        AbstractSequentialList abstractSequentialList = this.entries;
        if (abstractSequentialList == null) {
            this.entries = abstractSequentialList = new AbstractSequentialList<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return LinkedListMultimap.this.keyCount.size();
                }

                @Override
                public ListIterator<Map.Entry<K, V>> listIterator(int index) {
                    final NodeIterator nodeIterator = new NodeIterator(index);
                    return new ListIterator<Map.Entry<K, V>>(){

                        @Override
                        public boolean hasNext() {
                            return nodeIterator.hasNext();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            return LinkedListMultimap.createEntry((Node)nodeIterator.next());
                        }

                        @Override
                        public void remove() {
                            nodeIterator.remove();
                        }

                        @Override
                        public boolean hasPrevious() {
                            return nodeIterator.hasPrevious();
                        }

                        @Override
                        public Map.Entry<K, V> previous() {
                            return LinkedListMultimap.createEntry((Node)nodeIterator.previous());
                        }

                        @Override
                        public int nextIndex() {
                            return nodeIterator.nextIndex();
                        }

                        @Override
                        public int previousIndex() {
                            return nodeIterator.previousIndex();
                        }

                        @Override
                        public void set(Map.Entry<K, V> e2) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public void add(Map.Entry<K, V> e2) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
        return abstractSequentialList;
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        AbstractMap abstractMap = this.map;
        if (abstractMap == null) {
            this.map = abstractMap = new AbstractMap<K, Collection<V>>(){
                Set<Map.Entry<K, Collection<V>>> entrySet;

                @Override
                public Set<Map.Entry<K, Collection<V>>> entrySet() {
                    AsMapEntries asMapEntries = this.entrySet;
                    if (asMapEntries == null) {
                        this.entrySet = asMapEntries = new AsMapEntries();
                    }
                    return asMapEntries;
                }

                @Override
                public boolean containsKey(@Nullable Object key) {
                    return LinkedListMultimap.this.containsKey(key);
                }

                @Override
                public Collection<V> get(@Nullable Object key) {
                    Collection collection = LinkedListMultimap.this.get(key);
                    return collection.isEmpty() ? null : collection;
                }

                @Override
                public Collection<V> remove(@Nullable Object key) {
                    Collection collection = LinkedListMultimap.this.removeAll(key);
                    return collection.isEmpty() ? null : collection;
                }
            };
        }
        return abstractMap;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Multimap) {
            Multimap multimap = (Multimap)other;
            return ((Object)this.asMap()).equals(multimap.asMap());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.asMap()).hashCode();
    }

    public String toString() {
        return this.asMap().toString();
    }

    @GwtIncompatible(value="java.io.ObjectOutputStream")
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.size());
        for (Map.Entry entry : this.entries()) {
            stream.writeObject(entry.getKey());
            stream.writeObject(entry.getValue());
        }
    }

    @GwtIncompatible(value="java.io.ObjectInputStream")
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.keyCount = LinkedHashMultiset.create();
        this.keyToKeyHead = Maps.newHashMap();
        this.keyToKeyTail = Maps.newHashMap();
        int n2 = stream.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = stream.readObject();
            Object object2 = stream.readObject();
            this.put(object, object2);
        }
    }

    private class AsMapEntries
    extends AbstractSet<Map.Entry<K, Collection<V>>> {
        private AsMapEntries() {
        }

        @Override
        public int size() {
            return LinkedListMultimap.this.keyCount.elementSet().size();
        }

        @Override
        public Iterator<Map.Entry<K, Collection<V>>> iterator() {
            final DistinctKeyIterator distinctKeyIterator = new DistinctKeyIterator();
            return new Iterator<Map.Entry<K, Collection<V>>>(){

                @Override
                public boolean hasNext() {
                    return distinctKeyIterator.hasNext();
                }

                @Override
                public Map.Entry<K, Collection<V>> next() {
                    final Object e2 = distinctKeyIterator.next();
                    return new AbstractMapEntry<K, Collection<V>>(){

                        @Override
                        public K getKey() {
                            return e2;
                        }

                        @Override
                        public Collection<V> getValue() {
                            return LinkedListMultimap.this.get(e2);
                        }
                    };
                }

                @Override
                public void remove() {
                    distinctKeyIterator.remove();
                }
            };
        }
    }

    private class MultisetView
    extends AbstractCollection<K>
    implements Multiset<K> {
        private MultisetView() {
        }

        @Override
        public int size() {
            return LinkedListMultimap.this.keyCount.size();
        }

        @Override
        public Iterator<K> iterator() {
            final NodeIterator nodeIterator = new NodeIterator();
            return new Iterator<K>(){

                @Override
                public boolean hasNext() {
                    return nodeIterator.hasNext();
                }

                @Override
                public K next() {
                    return ((Node)nodeIterator.next()).key;
                }

                @Override
                public void remove() {
                    nodeIterator.remove();
                }
            };
        }

        @Override
        public int count(@Nullable Object key) {
            return LinkedListMultimap.this.keyCount.count(key);
        }

        @Override
        public int add(@Nullable K key, int occurrences) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int remove(@Nullable Object key, int occurrences) {
            Preconditions.checkArgument(occurrences >= 0);
            int n2 = this.count(key);
            ValueForKeyIterator valueForKeyIterator = new ValueForKeyIterator(key);
            while (occurrences-- > 0 && valueForKeyIterator.hasNext()) {
                valueForKeyIterator.next();
                valueForKeyIterator.remove();
            }
            return n2;
        }

        @Override
        public int setCount(K element, int count) {
            return Multisets.setCountImpl(this, element, count);
        }

        @Override
        public boolean setCount(K element, int oldCount, int newCount) {
            return Multisets.setCountImpl(this, element, oldCount, newCount);
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            return Iterators.removeAll(this.iterator(), c2);
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            return Iterators.retainAll(this.iterator(), c2);
        }

        @Override
        public Set<K> elementSet() {
            return LinkedListMultimap.this.keySet();
        }

        @Override
        public Set<Multiset.Entry<K>> entrySet() {
            return new AbstractSet<Multiset.Entry<K>>(){

                @Override
                public int size() {
                    return LinkedListMultimap.this.keyCount.elementSet().size();
                }

                @Override
                public Iterator<Multiset.Entry<K>> iterator() {
                    final DistinctKeyIterator distinctKeyIterator = new DistinctKeyIterator();
                    return new Iterator<Multiset.Entry<K>>(){

                        @Override
                        public boolean hasNext() {
                            return distinctKeyIterator.hasNext();
                        }

                        @Override
                        public Multiset.Entry<K> next() {
                            final Object e2 = distinctKeyIterator.next();
                            return new Multisets.AbstractEntry<K>(){

                                @Override
                                public K getElement() {
                                    return e2;
                                }

                                @Override
                                public int getCount() {
                                    return LinkedListMultimap.this.keyCount.count(e2);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            distinctKeyIterator.remove();
                        }
                    };
                }
            };
        }

        @Override
        public boolean equals(@Nullable Object object) {
            return ((Object)LinkedListMultimap.this.keyCount).equals(object);
        }

        @Override
        public int hashCode() {
            return ((Object)LinkedListMultimap.this.keyCount).hashCode();
        }

        @Override
        public String toString() {
            return ((Object)LinkedListMultimap.this.keyCount).toString();
        }
    }

    private class ValueForKeyIterator
    implements ListIterator<V> {
        final Object key;
        int nextIndex;
        Node<K, V> next;
        Node<K, V> current;
        Node<K, V> previous;

        ValueForKeyIterator(Object key) {
            this.key = key;
            this.next = (Node)LinkedListMultimap.this.keyToKeyHead.get(key);
        }

        public ValueForKeyIterator(Object key, int index) {
            int n2 = LinkedListMultimap.this.keyCount.count(key);
            Preconditions.checkPositionIndex(index, n2);
            if (index >= n2 / 2) {
                this.previous = (Node)LinkedListMultimap.this.keyToKeyTail.get(key);
                this.nextIndex = n2;
                while (index++ < n2) {
                    this.previous();
                }
            } else {
                this.next = (Node)LinkedListMultimap.this.keyToKeyHead.get(key);
                while (index-- > 0) {
                    this.next();
                }
            }
            this.key = key;
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public V next() {
            LinkedListMultimap.checkElement(this.next);
            this.current = this.next;
            this.previous = this.current;
            this.next = this.next.nextSibling;
            ++this.nextIndex;
            return this.current.value;
        }

        @Override
        public boolean hasPrevious() {
            return this.previous != null;
        }

        @Override
        public V previous() {
            LinkedListMultimap.checkElement(this.previous);
            this.current = this.previous;
            this.next = this.current;
            this.previous = this.previous.previousSibling;
            --this.nextIndex;
            return this.current.value;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.current != null);
            if (this.current != this.next) {
                this.previous = this.current.previousSibling;
                --this.nextIndex;
            } else {
                this.next = this.current.nextSibling;
            }
            LinkedListMultimap.this.removeNode(this.current);
            this.current = null;
        }

        @Override
        public void set(V value) {
            Preconditions.checkState(this.current != null);
            this.current.value = value;
        }

        @Override
        public void add(V value) {
            this.previous = LinkedListMultimap.this.addNode(this.key, value, this.next);
            ++this.nextIndex;
            this.current = null;
        }
    }

    private class DistinctKeyIterator
    implements Iterator<K> {
        final Set<K> seenKeys;
        Node<K, V> next;
        Node<K, V> current;

        private DistinctKeyIterator() {
            this.seenKeys = Sets.newHashSetWithExpectedSize(LinkedListMultimap.this.keySet().size());
            this.next = LinkedListMultimap.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public K next() {
            LinkedListMultimap.checkElement(this.next);
            this.current = this.next;
            this.seenKeys.add(this.current.key);
            do {
                this.next = this.next.next;
            } while (this.next != null && !this.seenKeys.add(this.next.key));
            return this.current.key;
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.current != null);
            LinkedListMultimap.this.removeAllNodes(this.current.key);
            this.current = null;
        }
    }

    private class NodeIterator
    implements ListIterator<Node<K, V>> {
        int nextIndex;
        Node<K, V> next;
        Node<K, V> current;
        Node<K, V> previous;

        NodeIterator() {
            this.next = LinkedListMultimap.this.head;
        }

        NodeIterator(int index) {
            int n2 = LinkedListMultimap.this.size();
            Preconditions.checkPositionIndex(index, n2);
            if (index >= n2 / 2) {
                this.previous = LinkedListMultimap.this.tail;
                this.nextIndex = n2;
                while (index++ < n2) {
                    this.previous();
                }
            } else {
                this.next = LinkedListMultimap.this.head;
                while (index-- > 0) {
                    this.next();
                }
            }
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Node<K, V> next() {
            LinkedListMultimap.checkElement(this.next);
            this.current = this.next;
            this.previous = this.current;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.current;
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.current != null);
            if (this.current != this.next) {
                this.previous = this.current.previous;
                --this.nextIndex;
            } else {
                this.next = this.current.next;
            }
            LinkedListMultimap.this.removeNode(this.current);
            this.current = null;
        }

        @Override
        public boolean hasPrevious() {
            return this.previous != null;
        }

        @Override
        public Node<K, V> previous() {
            LinkedListMultimap.checkElement(this.previous);
            this.current = this.previous;
            this.next = this.current;
            this.previous = this.previous.previous;
            --this.nextIndex;
            return this.current;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void set(Node<K, V> e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Node<K, V> e2) {
            throw new UnsupportedOperationException();
        }

        void setValue(V value) {
            Preconditions.checkState(this.current != null);
            this.current.value = value;
        }
    }

    private static final class Node<K, V> {
        final K key;
        V value;
        Node<K, V> next;
        Node<K, V> previous;
        Node<K, V> nextSibling;
        Node<K, V> previousSibling;

        Node(@Nullable K key, @Nullable V value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

