/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.Beta;
import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.base.Predicate;
import com.timevale.esign.paas.guava.common.collect.BoundType;
import com.timevale.esign.paas.guava.common.collect.ContiguousSet;
import com.timevale.esign.paas.guava.common.collect.Cut;
import com.timevale.esign.paas.guava.common.collect.DiscreteDomain;
import com.timevale.esign.paas.guava.common.collect.EmptyContiguousSet;
import com.timevale.esign.paas.guava.common.collect.Iterables;
import com.timevale.esign.paas.guava.common.collect.Ordering;
import com.timevale.esign.paas.guava.common.collect.Ranges;
import com.timevale.esign.paas.guava.common.collect.RegularContiguousSet;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import javax.annotation.Nullable;

@GwtCompatible
@Beta
public final class Range<C extends Comparable>
implements Predicate<C>,
Serializable {
    final Cut<C> lowerBound;
    final Cut<C> upperBound;
    private static final long serialVersionUID = 0L;

    Range(Cut<C> lowerBound, Cut<C> upperBound) {
        if (lowerBound.compareTo(upperBound) > 0) {
            throw new IllegalArgumentException("Invalid range: " + Range.toString(lowerBound, upperBound));
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public boolean hasLowerBound() {
        return this.lowerBound != Cut.belowAll();
    }

    public C lowerEndpoint() {
        return this.lowerBound.endpoint();
    }

    public BoundType lowerBoundType() {
        return this.lowerBound.typeAsLowerBound();
    }

    public boolean hasUpperBound() {
        return this.upperBound != Cut.aboveAll();
    }

    public C upperEndpoint() {
        return this.upperBound.endpoint();
    }

    public BoundType upperBoundType() {
        return this.upperBound.typeAsUpperBound();
    }

    public boolean isEmpty() {
        return this.lowerBound.equals(this.upperBound);
    }

    public boolean contains(C value) {
        Preconditions.checkNotNull(value);
        return this.lowerBound.isLessThan(value) && !this.upperBound.isLessThan(value);
    }

    @Override
    public boolean apply(C input) {
        return this.contains(input);
    }

    public boolean containsAll(Iterable<? extends C> values) {
        if (Iterables.isEmpty(values)) {
            return true;
        }
        if (values instanceof SortedSet) {
            SortedSet<? extends C> sortedSet = Range.cast(values);
            Object object = sortedSet.comparator();
            if (Ordering.natural().equals(object) || object == null) {
                return this.contains((Comparable)sortedSet.first()) && this.contains((Comparable)sortedSet.last());
            }
        }
        for (Object object : values) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    public boolean encloses(Range<C> other) {
        return this.lowerBound.compareTo(other.lowerBound) <= 0 && this.upperBound.compareTo(other.upperBound) >= 0;
    }

    public Range<C> intersection(Range<C> other) {
        Cut<C> cut = Ordering.natural().max(this.lowerBound, other.lowerBound);
        Cut<C> cut2 = Ordering.natural().min(this.upperBound, other.upperBound);
        return Ranges.create(cut, cut2);
    }

    public boolean isConnected(Range<C> other) {
        return this.lowerBound.compareTo(other.upperBound) <= 0 && other.lowerBound.compareTo(this.upperBound) <= 0;
    }

    public Range<C> span(Range<C> other) {
        Cut<C> cut = Ordering.natural().min(this.lowerBound, other.lowerBound);
        Cut<C> cut2 = Ordering.natural().max(this.upperBound, other.upperBound);
        return Ranges.create(cut, cut2);
    }

    @GwtCompatible(serializable=false)
    public ContiguousSet<C> asSet(DiscreteDomain<C> domain) {
        Preconditions.checkNotNull(domain);
        Range<C> range = this;
        try {
            if (!this.hasLowerBound()) {
                range = range.intersection(Ranges.atLeast(domain.minValue()));
            }
            if (!this.hasUpperBound()) {
                range = range.intersection(Ranges.atMost(domain.maxValue()));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException(noSuchElementException);
        }
        boolean bl2 = range.isEmpty() || Range.compareOrThrow(this.lowerBound.leastValueAbove(domain), this.upperBound.greatestValueBelow(domain)) > 0;
        return bl2 ? new EmptyContiguousSet<C>(domain) : new RegularContiguousSet<C>(range, domain);
    }

    public Range<C> canonical(DiscreteDomain<C> domain) {
        Preconditions.checkNotNull(domain);
        Cut<C> cut = this.lowerBound.canonical(domain);
        Cut<C> cut2 = this.upperBound.canonical(domain);
        return cut == this.lowerBound && cut2 == this.upperBound ? this : Ranges.create(cut, cut2);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof Range) {
            Range range = (Range)object;
            return this.lowerBound.equals(range.lowerBound) && this.upperBound.equals(range.upperBound);
        }
        return false;
    }

    public int hashCode() {
        return this.lowerBound.hashCode() * 31 + this.upperBound.hashCode();
    }

    public String toString() {
        return Range.toString(this.lowerBound, this.upperBound);
    }

    private static String toString(Cut<?> lowerBound, Cut<?> upperBound) {
        StringBuilder stringBuilder = new StringBuilder(16);
        lowerBound.describeAsLowerBound(stringBuilder);
        stringBuilder.append('\u2025');
        upperBound.describeAsUpperBound(stringBuilder);
        return stringBuilder.toString();
    }

    private static <T> SortedSet<T> cast(Iterable<T> iterable) {
        return (SortedSet)iterable;
    }

    static int compareOrThrow(Comparable left, Comparable right) {
        return left.compareTo(right);
    }
}

