/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.eventbus;

import com.timevale.esign.paas.guava.common.collect.HashMultimap;
import com.timevale.esign.paas.guava.common.collect.Multimap;
import com.timevale.esign.paas.guava.common.eventbus.AllowConcurrentEvents;
import com.timevale.esign.paas.guava.common.eventbus.EventHandler;
import com.timevale.esign.paas.guava.common.eventbus.HandlerFindingStrategy;
import com.timevale.esign.paas.guava.common.eventbus.Subscribe;
import com.timevale.esign.paas.guava.common.eventbus.SynchronizedEventHandler;
import java.lang.reflect.Method;

class AnnotatedHandlerFinder
implements HandlerFindingStrategy {
    AnnotatedHandlerFinder() {
    }

    @Override
    public Multimap<Class<?>, EventHandler> findAllHandlers(Object listener) {
        HashMultimap<Class<?>, EventHandler> hashMultimap = HashMultimap.create();
        for (Class<?> clazz = listener.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getMethods()) {
                Subscribe subscribe = method.getAnnotation(Subscribe.class);
                if (subscribe == null) continue;
                Class<?>[] classArray = method.getParameterTypes();
                if (classArray.length != 1) {
                    throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation, but requires " + classArray.length + " arguments.  Event handler methods " + "must require a single argument.");
                }
                Class<?> clazz2 = classArray[0];
                EventHandler eventHandler = AnnotatedHandlerFinder.makeHandler(listener, method);
                hashMultimap.put(clazz2, eventHandler);
            }
        }
        return hashMultimap;
    }

    private static EventHandler makeHandler(Object listener, Method method) {
        EventHandler eventHandler = AnnotatedHandlerFinder.methodIsDeclaredThreadSafe(method) ? new EventHandler(listener, method) : new SynchronizedEventHandler(listener, method);
        return eventHandler;
    }

    private static boolean methodIsDeclaredThreadSafe(Method method) {
        return method.getAnnotation(AllowConcurrentEvents.class) != null;
    }
}

