/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.io;

import com.timevale.esign.paas.guava.common.annotations.Beta;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.io.AppendableWriter;
import com.timevale.esign.paas.guava.common.io.Closeables;
import com.timevale.esign.paas.guava.common.io.InputSupplier;
import com.timevale.esign.paas.guava.common.io.LineProcessor;
import com.timevale.esign.paas.guava.common.io.LineReader;
import com.timevale.esign.paas.guava.common.io.MultiReader;
import com.timevale.esign.paas.guava.common.io.OutputSupplier;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Beta
public final class CharStreams {
    private static final int BUF_SIZE = 2048;

    private CharStreams() {
    }

    public static InputSupplier<StringReader> newReaderSupplier(final String value) {
        Preconditions.checkNotNull(value);
        return new InputSupplier<StringReader>(){

            @Override
            public StringReader getInput() {
                return new StringReader(value);
            }
        };
    }

    public static InputSupplier<InputStreamReader> newReaderSupplier(final InputSupplier<? extends InputStream> in, final Charset charset) {
        Preconditions.checkNotNull(in);
        Preconditions.checkNotNull(charset);
        return new InputSupplier<InputStreamReader>(){

            @Override
            public InputStreamReader getInput() throws IOException {
                return new InputStreamReader((InputStream)in.getInput(), charset);
            }
        };
    }

    public static OutputSupplier<OutputStreamWriter> newWriterSupplier(final OutputSupplier<? extends OutputStream> out, final Charset charset) {
        Preconditions.checkNotNull(out);
        Preconditions.checkNotNull(charset);
        return new OutputSupplier<OutputStreamWriter>(){

            @Override
            public OutputStreamWriter getOutput() throws IOException {
                return new OutputStreamWriter((OutputStream)out.getOutput(), charset);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <W extends Appendable & Closeable> void write(CharSequence from, OutputSupplier<W> to) throws IOException {
        Preconditions.checkNotNull(from);
        boolean bl2 = true;
        Appendable appendable = (Appendable)to.getOutput();
        try {
            appendable.append(from);
            bl2 = false;
        }
        finally {
            Closeables.close((Closeable)((Object)appendable), bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Readable & Closeable, W extends Appendable & Closeable> long copy(InputSupplier<R> from, OutputSupplier<W> to) throws IOException {
        boolean bl2 = true;
        Readable readable = (Readable)from.getInput();
        try {
            long l2;
            Appendable appendable = (Appendable)to.getOutput();
            try {
                long l3 = CharStreams.copy(readable, appendable);
                bl2 = false;
                l2 = l3;
            }
            catch (Throwable throwable) {
                Closeables.close((Closeable)((Object)appendable), bl2);
                throw throwable;
            }
            Closeables.close((Closeable)((Object)appendable), bl2);
            return l2;
        }
        finally {
            Closeables.close((Closeable)((Object)readable), bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Readable & Closeable> long copy(InputSupplier<R> from, Appendable to) throws IOException {
        boolean bl2 = true;
        Readable readable = (Readable)from.getInput();
        try {
            long l2 = CharStreams.copy(readable, to);
            bl2 = false;
            long l3 = l2;
            return l3;
        }
        finally {
            Closeables.close((Closeable)((Object)readable), bl2);
        }
    }

    public static long copy(Readable from, Appendable to) throws IOException {
        int n2;
        CharBuffer charBuffer = CharBuffer.allocate(2048);
        long l2 = 0L;
        while ((n2 = from.read(charBuffer)) != -1) {
            charBuffer.flip();
            to.append(charBuffer, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static String toString(Readable r2) throws IOException {
        return CharStreams.toStringBuilder(r2).toString();
    }

    public static <R extends Readable & Closeable> String toString(InputSupplier<R> supplier) throws IOException {
        return CharStreams.toStringBuilder(supplier).toString();
    }

    private static StringBuilder toStringBuilder(Readable r2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        CharStreams.copy(r2, (Appendable)stringBuilder);
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <R extends Readable & Closeable> StringBuilder toStringBuilder(InputSupplier<R> supplier) throws IOException {
        boolean bl2 = true;
        Readable readable = (Readable)supplier.getInput();
        try {
            StringBuilder stringBuilder = CharStreams.toStringBuilder(readable);
            bl2 = false;
            StringBuilder stringBuilder2 = stringBuilder;
            return stringBuilder2;
        }
        finally {
            Closeables.close((Closeable)((Object)readable), bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Readable & Closeable> String readFirstLine(InputSupplier<R> supplier) throws IOException {
        boolean bl2 = true;
        Readable readable = (Readable)supplier.getInput();
        try {
            String string = new LineReader(readable).readLine();
            bl2 = false;
            String string2 = string;
            return string2;
        }
        finally {
            Closeables.close((Closeable)((Object)readable), bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Readable & Closeable> List<String> readLines(InputSupplier<R> supplier) throws IOException {
        boolean bl2 = true;
        Readable readable = (Readable)supplier.getInput();
        try {
            List<String> list = CharStreams.readLines(readable);
            bl2 = false;
            List<String> list2 = list;
            return list2;
        }
        finally {
            Closeables.close((Closeable)((Object)readable), bl2);
        }
    }

    public static List<String> readLines(Readable r2) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        LineReader lineReader = new LineReader(r2);
        while ((string = lineReader.readLine()) != null) {
            arrayList.add(string);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Readable & Closeable, T> T readLines(InputSupplier<R> supplier, LineProcessor<T> callback) throws IOException {
        boolean bl2 = true;
        Readable readable = (Readable)supplier.getInput();
        try {
            String string;
            LineReader lineReader = new LineReader(readable);
            while ((string = lineReader.readLine()) != null && callback.processLine(string)) {
            }
            bl2 = false;
        }
        finally {
            Closeables.close((Closeable)((Object)readable), bl2);
        }
        return callback.getResult();
    }

    public static InputSupplier<Reader> join(final Iterable<? extends InputSupplier<? extends Reader>> suppliers) {
        return new InputSupplier<Reader>(){

            @Override
            public Reader getInput() throws IOException {
                return new MultiReader(suppliers.iterator());
            }
        };
    }

    public static InputSupplier<Reader> join(InputSupplier<? extends Reader> ... suppliers) {
        return CharStreams.join(Arrays.asList(suppliers));
    }

    public static void skipFully(Reader reader, long n2) throws IOException {
        while (n2 > 0L) {
            long l2 = reader.skip(n2);
            if (l2 == 0L) {
                if (reader.read() == -1) {
                    throw new EOFException();
                }
                --n2;
                continue;
            }
            n2 -= l2;
        }
    }

    public static Writer asWriter(Appendable target) {
        if (target instanceof Writer) {
            return (Writer)target;
        }
        return new AppendableWriter(target);
    }
}

