/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.primitives;

import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

@GwtCompatible
public final class Floats {
    public static final int BYTES = 4;

    private Floats() {
    }

    public static int hashCode(float value) {
        return Float.valueOf(value).hashCode();
    }

    public static int compare(float a2, float b2) {
        return Float.compare(a2, b2);
    }

    public static boolean isFinite(float value) {
        return Float.NEGATIVE_INFINITY < value & value < Float.POSITIVE_INFINITY;
    }

    public static boolean contains(float[] array, float target) {
        for (float f2 : array) {
            if (f2 != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(float[] array, float target) {
        return Floats.indexOf(array, target, 0, array.length);
    }

    private static int indexOf(float[] array, float target, int start, int end) {
        for (int i2 = start; i2 < end; ++i2) {
            if (array[i2] != target) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(float[] array, float[] target) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < array.length - target.length + 1; ++i2) {
            for (int i3 = 0; i3 < target.length; ++i3) {
                if (array[i2 + i3] != target[i3]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(float[] array, float target) {
        return Floats.lastIndexOf(array, target, 0, array.length);
    }

    private static int lastIndexOf(float[] array, float target, int start, int end) {
        for (int i2 = end - 1; i2 >= start; --i2) {
            if (array[i2] != target) continue;
            return i2;
        }
        return -1;
    }

    public static float min(float ... array) {
        Preconditions.checkArgument(array.length > 0);
        float f2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            f2 = Math.min(f2, array[i2]);
        }
        return f2;
    }

    public static float max(float ... array) {
        Preconditions.checkArgument(array.length > 0);
        float f2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            f2 = Math.max(f2, array[i2]);
        }
        return f2;
    }

    public static float[] concat(float[] ... arrays) {
        int n2 = 0;
        for (float[] fArray : arrays) {
            n2 += fArray.length;
        }
        float[] fArray = new float[n2];
        int n3 = 0;
        for (float[] fArray2 : arrays) {
            System.arraycopy(fArray2, 0, fArray, n3, fArray2.length);
            n3 += fArray2.length;
        }
        return fArray;
    }

    public static float[] ensureCapacity(float[] array, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array.length < minLength ? Floats.copyOf(array, minLength + padding) : array;
    }

    private static float[] copyOf(float[] original, int length) {
        float[] fArray = new float[length];
        System.arraycopy(original, 0, fArray, 0, Math.min(original.length, length));
        return fArray;
    }

    public static String join(String separator, float ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(array.length * 12);
        stringBuilder.append(array[0]);
        for (int i2 = 1; i2 < array.length; ++i2) {
            stringBuilder.append(separator).append(array[i2]);
        }
        return stringBuilder.toString();
    }

    public static Comparator<float[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static float[] toArray(Collection<Float> collection) {
        if (collection instanceof FloatArrayAsList) {
            return ((FloatArrayAsList)collection).toFloatArray();
        }
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = ((Float)Preconditions.checkNotNull(objectArray[i2])).floatValue();
        }
        return fArray;
    }

    public static List<Float> asList(float ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new FloatArrayAsList(backingArray);
    }

    @GwtCompatible
    private static class FloatArrayAsList
    extends AbstractList<Float>
    implements Serializable,
    RandomAccess {
        final float[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        FloatArrayAsList(float[] array) {
            this(array, 0, array.length);
        }

        FloatArrayAsList(float[] array, int start, int end) {
            this.array = array;
            this.start = start;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Float get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return Float.valueOf(this.array[this.start + index]);
        }

        @Override
        public boolean contains(Object target) {
            return target instanceof Float && Floats.indexOf(this.array, ((Float)target).floatValue(), this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object target) {
            int n2;
            if (target instanceof Float && (n2 = Floats.indexOf(this.array, ((Float)target).floatValue(), this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            int n2;
            if (target instanceof Float && (n2 = Floats.lastIndexOf(this.array, ((Float)target).floatValue(), this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Float set(int index, Float element) {
            Preconditions.checkElementIndex(index, this.size());
            float f2 = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element).floatValue();
            return Float.valueOf(f2);
        }

        @Override
        public List<Float> subList(int fromIndex, int toIndex) {
            int n2 = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, n2);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new FloatArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof FloatArrayAsList) {
                FloatArrayAsList floatArrayAsList = (FloatArrayAsList)object;
                int n2 = this.size();
                if (floatArrayAsList.size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == floatArrayAsList.array[floatArrayAsList.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = 31 * n2 + Floats.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 12);
            stringBuilder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                stringBuilder.append(", ").append(this.array[i2]);
            }
            return stringBuilder.append(']').toString();
        }

        float[] toFloatArray() {
            int n2 = this.size();
            float[] fArray = new float[n2];
            System.arraycopy(this.array, this.start, fArray, 0, n2);
            return fArray;
        }
    }

    private static enum LexicographicalComparator implements Comparator<float[]>
    {
        INSTANCE;


        @Override
        public int compare(float[] left, float[] right) {
            int n2 = Math.min(left.length, right.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = Floats.compare(left[i2], right[i2]);
                if (n3 == 0) continue;
                return n3;
            }
            return left.length - right.length;
        }
    }
}

