/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.primitives;

import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import java.util.Comparator;

@GwtCompatible
public final class SignedBytes {
    public static final byte MAX_POWER_OF_TWO = 64;

    private SignedBytes() {
    }

    public static byte checkedCast(long value) {
        byte by2 = (byte)value;
        Preconditions.checkArgument((long)by2 == value, "Out of range: %s", value);
        return by2;
    }

    public static byte saturatedCast(long value) {
        if (value > 127L) {
            return 127;
        }
        if (value < -128L) {
            return -128;
        }
        return (byte)value;
    }

    public static int compare(byte a2, byte b2) {
        return a2 - b2;
    }

    public static byte min(byte ... array) {
        Preconditions.checkArgument(array.length > 0);
        byte by2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] >= by2) continue;
            by2 = array[i2];
        }
        return by2;
    }

    public static byte max(byte ... array) {
        Preconditions.checkArgument(array.length > 0);
        byte by2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] <= by2) continue;
            by2 = array[i2];
        }
        return by2;
    }

    public static String join(String separator, byte ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(array.length * 5);
        stringBuilder.append(array[0]);
        for (int i2 = 1; i2 < array.length; ++i2) {
            stringBuilder.append(separator).append(array[i2]);
        }
        return stringBuilder.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    private static enum LexicographicalComparator implements Comparator<byte[]>
    {
        INSTANCE;


        @Override
        public int compare(byte[] left, byte[] right) {
            int n2 = Math.min(left.length, right.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = SignedBytes.compare(left[i2], right[i2]);
                if (n3 == 0) continue;
                return n3;
            }
            return left.length - right.length;
        }
    }
}

