/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.primitives;

import com.timevale.esign.paas.guava.common.annotations.Beta;
import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.primitives.Longs;
import java.math.BigInteger;
import java.util.Comparator;

@Beta
@GwtCompatible
public final class UnsignedLongs {
    public static final long MAX_VALUE = -1L;
    private static final long[] maxValueDivs = new long[37];
    private static final int[] maxValueMods = new int[37];
    private static final int[] maxSafeDigits = new int[37];

    private UnsignedLongs() {
    }

    private static long flip(long a2) {
        return a2 ^ Long.MIN_VALUE;
    }

    public static int compare(long a2, long b2) {
        return Longs.compare(UnsignedLongs.flip(a2), UnsignedLongs.flip(b2));
    }

    public static long min(long ... array) {
        Preconditions.checkArgument(array.length > 0);
        long l2 = UnsignedLongs.flip(array[0]);
        for (int i2 = 1; i2 < array.length; ++i2) {
            long l3 = UnsignedLongs.flip(array[i2]);
            if (l3 >= l2) continue;
            l2 = l3;
        }
        return UnsignedLongs.flip(l2);
    }

    public static long max(long ... array) {
        Preconditions.checkArgument(array.length > 0);
        long l2 = UnsignedLongs.flip(array[0]);
        for (int i2 = 1; i2 < array.length; ++i2) {
            long l3 = UnsignedLongs.flip(array[i2]);
            if (l3 <= l2) continue;
            l2 = l3;
        }
        return UnsignedLongs.flip(l2);
    }

    public static String join(String separator, long ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(array.length * 5);
        stringBuilder.append(array[0]);
        for (int i2 = 1; i2 < array.length; ++i2) {
            stringBuilder.append(separator).append(UnsignedLongs.toString(array[i2]));
        }
        return stringBuilder.toString();
    }

    public static Comparator<long[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static long divide(long dividend, long divisor) {
        long l2;
        if (divisor < 0L) {
            if (UnsignedLongs.compare(dividend, divisor) < 0) {
                return 0L;
            }
            return 1L;
        }
        if (dividend >= 0L) {
            return dividend / divisor;
        }
        long l3 = dividend - (l2 = (dividend >>> 1) / divisor << 1) * divisor;
        return l2 + (long)(UnsignedLongs.compare(l3, divisor) >= 0 ? 1 : 0);
    }

    public static long remainder(long dividend, long divisor) {
        long l2;
        if (divisor < 0L) {
            if (UnsignedLongs.compare(dividend, divisor) < 0) {
                return dividend;
            }
            return dividend - divisor;
        }
        if (dividend >= 0L) {
            return dividend % divisor;
        }
        long l3 = (dividend >>> 1) / divisor << 1;
        return l2 - (UnsignedLongs.compare(l2 = dividend - l3 * divisor, divisor) >= 0 ? divisor : 0L);
    }

    public static long parseUnsignedLong(String s2) {
        return UnsignedLongs.parseUnsignedLong(s2, 10);
    }

    public static long parseUnsignedLong(String s2, int radix) {
        Preconditions.checkNotNull(s2);
        if (s2.length() == 0) {
            throw new NumberFormatException("empty string");
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("illegal radix:" + radix);
        }
        int n2 = maxSafeDigits[radix] - 1;
        long l2 = 0L;
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            int n3 = Character.digit(s2.charAt(i2), radix);
            if (n3 == -1) {
                throw new NumberFormatException(s2);
            }
            if (i2 > n2 && UnsignedLongs.overflowInParse(l2, n3, radix)) {
                throw new NumberFormatException("Too large for unsigned long: " + s2);
            }
            l2 = l2 * (long)radix + (long)n3;
        }
        return l2;
    }

    private static boolean overflowInParse(long current, int digit, int radix) {
        if (current >= 0L) {
            if (current < maxValueDivs[radix]) {
                return false;
            }
            if (current > maxValueDivs[radix]) {
                return true;
            }
            return digit > maxValueMods[radix];
        }
        return true;
    }

    public static String toString(long x2) {
        return UnsignedLongs.toString(x2, 10);
    }

    public static String toString(long x2, int radix) {
        Preconditions.checkArgument(radix >= 2 && radix <= 36, "radix (%s) must be between Character.MIN_RADIX and Character.MAX_RADIX", radix);
        if (x2 == 0L) {
            return "0";
        }
        char[] cArray = new char[64];
        int n2 = cArray.length;
        if (x2 < 0L) {
            long l2 = x2 >>> 32;
            long l3 = (x2 & 0xFFFFFFFFL) + (l2 % (long)radix << 32);
            l2 /= (long)radix;
            while (l3 > 0L || l2 > 0L) {
                cArray[--n2] = Character.forDigit((int)(l3 % (long)radix), radix);
                l3 = l3 / (long)radix + (l2 % (long)radix << 32);
                l2 /= (long)radix;
            }
        } else {
            while (x2 > 0L) {
                cArray[--n2] = Character.forDigit((int)(x2 % (long)radix), radix);
                x2 /= (long)radix;
            }
        }
        return new String(cArray, n2, cArray.length - n2);
    }

    static {
        BigInteger bigInteger = new BigInteger("10000000000000000", 16);
        for (int i2 = 2; i2 <= 36; ++i2) {
            UnsignedLongs.maxValueDivs[i2] = UnsignedLongs.divide(-1L, i2);
            UnsignedLongs.maxValueMods[i2] = (int)UnsignedLongs.remainder(-1L, i2);
            UnsignedLongs.maxSafeDigits[i2] = bigInteger.toString(i2).length() - 1;
        }
    }

    static enum LexicographicalComparator implements Comparator<long[]>
    {
        INSTANCE;


        @Override
        public int compare(long[] left, long[] right) {
            int n2 = Math.min(left.length, right.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                if (left[i2] == right[i2]) continue;
                return UnsignedLongs.compare(left[i2], right[i2]);
            }
            return left.length - right.length;
        }
    }
}

