/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.util.concurrent;

import com.timevale.esign.paas.guava.common.annotations.Beta;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.base.Throwables;
import com.timevale.esign.paas.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

@Beta
public final class Monitor {
    private final ReentrantLock lock;
    private final ArrayList<Guard> activeGuards = Lists.newArrayListWithCapacity(1);

    public Monitor() {
        this(false);
    }

    public Monitor(boolean fair) {
        this.lock = new ReentrantLock(fair);
    }

    public void enter() {
        this.lock.lock();
    }

    public void enterInterruptibly() throws InterruptedException {
        this.lock.lockInterruptibly();
    }

    public boolean enter(long time, TimeUnit unit) {
        long l2;
        ReentrantLock reentrantLock = this.lock;
        long l3 = System.nanoTime();
        long l4 = l2 = unit.toNanos(time);
        boolean bl2 = false;
        while (true) {
            try {
                boolean bl3 = reentrantLock.tryLock(l4, TimeUnit.NANOSECONDS);
                return bl3;
            }
            catch (InterruptedException interruptedException) {
                bl2 = true;
                l4 = l2 - (System.nanoTime() - l3);
                continue;
            }
            break;
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean enterInterruptibly(long time, TimeUnit unit) throws InterruptedException {
        return this.lock.tryLock(time, unit);
    }

    public boolean tryEnter() {
        return this.lock.tryLock();
    }

    public void enterWhen(Guard guard) throws InterruptedException {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        boolean bl2 = reentrantLock.isHeldByCurrentThread();
        reentrantLock.lockInterruptibly();
        try {
            this.waitInterruptibly(guard, bl2);
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw Throwables.propagate(throwable);
        }
    }

    public void enterWhenUninterruptibly(Guard guard) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        boolean bl2 = reentrantLock.isHeldByCurrentThread();
        reentrantLock.lock();
        try {
            this.waitUninterruptibly(guard, bl2);
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw Throwables.propagate(throwable);
        }
    }

    public boolean enterWhen(Guard guard, long time, TimeUnit unit) throws InterruptedException {
        boolean bl2;
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        boolean bl3 = reentrantLock.isHeldByCurrentThread();
        long l2 = System.nanoTime();
        if (!reentrantLock.tryLock(time, unit)) {
            return false;
        }
        try {
            long l3 = unit.toNanos(time) - (System.nanoTime() - l2);
            bl2 = this.waitInterruptibly(guard, l3, bl3);
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw Throwables.propagate(throwable);
        }
        if (bl2) {
            return true;
        }
        reentrantLock.unlock();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean enterWhenUninterruptibly(Guard guard, long time, TimeUnit unit) {
        long l2;
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        boolean bl2 = reentrantLock.isHeldByCurrentThread();
        long l3 = System.nanoTime();
        long l4 = l2 = unit.toNanos(time);
        boolean bl3 = false;
        try {
            boolean bl4;
            while (true) {
                try {
                    if (!reentrantLock.tryLock(l4, TimeUnit.NANOSECONDS)) {
                        boolean bl5 = false;
                        return bl5;
                    }
                }
                catch (InterruptedException interruptedException) {
                    bl3 = true;
                    continue;
                }
                finally {
                    l4 = l2 - (System.nanoTime() - l3);
                    continue;
                }
                break;
            }
            try {
                bl4 = this.waitUninterruptibly(guard, l4, bl2);
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw Throwables.propagate(throwable);
            }
            if (bl4) {
                boolean bl6 = true;
                return bl6;
            }
            reentrantLock.unlock();
            boolean bl7 = false;
            return bl7;
        }
        finally {
            if (bl3) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean enterIf(Guard guard) {
        boolean bl2;
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            bl2 = guard.isSatisfied();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw Throwables.propagate(throwable);
        }
        if (bl2) {
            return true;
        }
        reentrantLock.unlock();
        return false;
    }

    public boolean enterIfInterruptibly(Guard guard) throws InterruptedException {
        boolean bl2;
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            bl2 = guard.isSatisfied();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw Throwables.propagate(throwable);
        }
        if (bl2) {
            return true;
        }
        reentrantLock.unlock();
        return false;
    }

    public boolean enterIf(Guard guard, long time, TimeUnit unit) {
        boolean bl2;
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        if (!this.enter(time, unit)) {
            return false;
        }
        try {
            bl2 = guard.isSatisfied();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw Throwables.propagate(throwable);
        }
        if (bl2) {
            return true;
        }
        reentrantLock.unlock();
        return false;
    }

    public boolean enterIfInterruptibly(Guard guard, long time, TimeUnit unit) throws InterruptedException {
        boolean bl2;
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        if (!reentrantLock.tryLock(time, unit)) {
            return false;
        }
        try {
            bl2 = guard.isSatisfied();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw Throwables.propagate(throwable);
        }
        if (bl2) {
            return true;
        }
        reentrantLock.unlock();
        return false;
    }

    public boolean tryEnterIf(Guard guard) {
        boolean bl2;
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        if (!reentrantLock.tryLock()) {
            return false;
        }
        try {
            bl2 = guard.isSatisfied();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw Throwables.propagate(throwable);
        }
        if (bl2) {
            return true;
        }
        reentrantLock.unlock();
        return false;
    }

    @GuardedBy(value="lock")
    public void waitFor(Guard guard) throws InterruptedException {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.waitInterruptibly(guard, true);
    }

    @GuardedBy(value="lock")
    public void waitForUninterruptibly(Guard guard) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.waitUninterruptibly(guard, true);
    }

    @GuardedBy(value="lock")
    public boolean waitFor(Guard guard, long time, TimeUnit unit) throws InterruptedException {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.waitInterruptibly(guard, unit.toNanos(time), true);
    }

    @GuardedBy(value="lock")
    public boolean waitForUninterruptibly(Guard guard, long time, TimeUnit unit) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.waitUninterruptibly(guard, unit.toNanos(time), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="lock")
    public void leave() {
        ReentrantLock reentrantLock = this.lock;
        if (!reentrantLock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        try {
            this.signalConditionsOfSatisfiedGuards(null);
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reevaluateGuards() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            this.signalConditionsOfSatisfiedGuards(null);
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public boolean isFair() {
        return this.lock.isFair();
    }

    public boolean isOccupied() {
        return this.lock.isLocked();
    }

    public boolean isOccupiedByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }

    public int getOccupiedDepth() {
        return this.lock.getHoldCount();
    }

    public int getQueueLength() {
        return this.lock.getQueueLength();
    }

    public boolean hasQueuedThreads() {
        return this.lock.hasQueuedThreads();
    }

    public boolean hasQueuedThread(Thread thread) {
        return this.lock.hasQueuedThread(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWaiters(Guard guard) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        this.lock.lock();
        try {
            boolean bl2 = guard.waiterCount > 0;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWaitQueueLength(Guard guard) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        this.lock.lock();
        try {
            int n2 = guard.waiterCount;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @GuardedBy(value="lock")
    private void signalConditionsOfSatisfiedGuards(@Nullable Guard interruptedGuard) {
        ArrayList<Guard> arrayList = this.activeGuards;
        int n2 = arrayList.size();
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                Guard guard = arrayList.get(i2);
                if (guard == interruptedGuard && guard.waiterCount == 1 || !guard.isSatisfied()) continue;
                guard.condition.signal();
                return;
            }
        }
        catch (Throwable throwable) {
            for (int i3 = 0; i3 < n2; ++i3) {
                Guard guard = arrayList.get(i3);
                guard.condition.signalAll();
            }
            throw Throwables.propagate(throwable);
        }
    }

    @GuardedBy(value="lock")
    private void incrementWaiters(Guard guard) {
        int n2;
        if ((n2 = guard.waiterCount++) == 0) {
            this.activeGuards.add(guard);
        }
    }

    @GuardedBy(value="lock")
    private void decrementWaiters(Guard guard) {
        int n2;
        if ((n2 = --guard.waiterCount) == 0) {
            this.activeGuards.remove(guard);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="lock")
    private void waitInterruptibly(Guard guard, boolean signalBeforeWaiting) throws InterruptedException {
        if (!guard.isSatisfied()) {
            if (signalBeforeWaiting) {
                this.signalConditionsOfSatisfiedGuards(null);
            }
            this.incrementWaiters(guard);
            try {
                Condition condition = guard.condition;
                do {
                    try {
                        condition.await();
                    }
                    catch (InterruptedException interruptedException) {
                        try {
                            this.signalConditionsOfSatisfiedGuards(guard);
                        }
                        catch (Throwable throwable) {
                            Thread.currentThread().interrupt();
                            throw Throwables.propagate(throwable);
                        }
                        throw interruptedException;
                    }
                } while (!guard.isSatisfied());
            }
            finally {
                this.decrementWaiters(guard);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="lock")
    private void waitUninterruptibly(Guard guard, boolean signalBeforeWaiting) {
        if (!guard.isSatisfied()) {
            if (signalBeforeWaiting) {
                this.signalConditionsOfSatisfiedGuards(null);
            }
            this.incrementWaiters(guard);
            try {
                Condition condition = guard.condition;
                do {
                    condition.awaitUninterruptibly();
                } while (!guard.isSatisfied());
            }
            finally {
                this.decrementWaiters(guard);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="lock")
    private boolean waitInterruptibly(Guard guard, long remainingNanos, boolean signalBeforeWaiting) throws InterruptedException {
        if (!guard.isSatisfied()) {
            if (signalBeforeWaiting) {
                this.signalConditionsOfSatisfiedGuards(null);
            }
            this.incrementWaiters(guard);
            try {
                Condition condition = guard.condition;
                do {
                    if (remainingNanos <= 0L) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    try {
                        remainingNanos = condition.awaitNanos(remainingNanos);
                    }
                    catch (InterruptedException interruptedException) {
                        try {
                            this.signalConditionsOfSatisfiedGuards(guard);
                        }
                        catch (Throwable throwable) {
                            Thread.currentThread().interrupt();
                            throw Throwables.propagate(throwable);
                        }
                        throw interruptedException;
                    }
                } while (!guard.isSatisfied());
            }
            finally {
                this.decrementWaiters(guard);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="lock")
    private boolean waitUninterruptibly(Guard guard, long timeoutNanos, boolean signalBeforeWaiting) {
        if (!guard.isSatisfied()) {
            long l2 = System.nanoTime();
            if (signalBeforeWaiting) {
                this.signalConditionsOfSatisfiedGuards(null);
            }
            boolean bl2 = false;
            try {
                this.incrementWaiters(guard);
                try {
                    Condition condition = guard.condition;
                    long l3 = timeoutNanos;
                    do {
                        if (l3 <= 0L) {
                            boolean bl3 = false;
                            return bl3;
                        }
                        try {
                            l3 = condition.awaitNanos(l3);
                        }
                        catch (InterruptedException interruptedException) {
                            try {
                                this.signalConditionsOfSatisfiedGuards(guard);
                            }
                            catch (Throwable throwable) {
                                Thread.currentThread().interrupt();
                                throw Throwables.propagate(throwable);
                            }
                            bl2 = true;
                            l3 = timeoutNanos - (System.nanoTime() - l2);
                        }
                    } while (!guard.isSatisfied());
                }
                finally {
                    this.decrementWaiters(guard);
                }
            }
            finally {
                if (bl2) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return true;
    }

    @Beta
    public static abstract class Guard {
        final Monitor monitor;
        final Condition condition;
        @GuardedBy(value="monitor.lock")
        int waiterCount = 0;

        protected Guard(Monitor monitor) {
            this.monitor = Preconditions.checkNotNull(monitor, "monitor");
            this.condition = monitor.lock.newCondition();
        }

        public abstract boolean isSatisfied();

        public final boolean equals(Object other) {
            return this == other;
        }

        public final int hashCode() {
            return super.hashCode();
        }
    }
}

