/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.util.concurrent;

import com.timevale.esign.paas.guava.common.annotations.Beta;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@Beta
public final class Uninterruptibles {
    public static void awaitUninterruptibly(CountDownLatch latch) {
        boolean bl2 = false;
        while (true) {
            try {
                latch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                bl2 = true;
                continue;
            }
            break;
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static boolean awaitUninterruptibly(CountDownLatch latch, long timeout, TimeUnit unit) {
        boolean bl2 = false;
        try {
            long l2 = unit.toNanos(timeout);
            long l3 = System.nanoTime() + l2;
            while (true) {
                try {
                    boolean bl3 = latch.await(l2, TimeUnit.NANOSECONDS);
                    return bl3;
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    l2 = l3 - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void joinUninterruptibly(Thread toJoin) {
        boolean bl2 = false;
        while (true) {
            try {
                toJoin.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                bl2 = true;
                continue;
            }
            break;
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <V> V getUninterruptibly(Future<V> future) throws ExecutionException {
        boolean bl2 = false;
        while (true) {
            try {
                V v2 = future.get();
                return v2;
            }
            catch (InterruptedException interruptedException) {
                bl2 = true;
                continue;
            }
            break;
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <V> V getUninterruptibly(Future<V> future, long timeout, TimeUnit unit) throws ExecutionException, TimeoutException {
        boolean bl2 = false;
        try {
            long l2 = unit.toNanos(timeout);
            long l3 = System.nanoTime() + l2;
            while (true) {
                V v2;
                try {
                    v2 = future.get(l2, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    l2 = l3 - System.nanoTime();
                    continue;
                }
                return v2;
            }
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void joinUninterruptibly(Thread toJoin, long timeout, TimeUnit unit) {
        Preconditions.checkNotNull(toJoin);
        boolean bl2 = false;
        try {
            long l2 = unit.toNanos(timeout);
            long l3 = System.nanoTime() + l2;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.timedJoin(toJoin, l2);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    l2 = l3 - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <E> E takeUninterruptibly(BlockingQueue<E> queue) {
        boolean bl2 = false;
        while (true) {
            try {
                E e2 = queue.take();
                return e2;
            }
            catch (InterruptedException interruptedException) {
                bl2 = true;
                continue;
            }
            break;
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <E> void putUninterruptibly(BlockingQueue<E> queue, E element) {
        boolean bl2 = false;
        while (true) {
            try {
                queue.put(element);
                return;
            }
            catch (InterruptedException interruptedException) {
                bl2 = true;
                continue;
            }
            break;
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void sleepUninterruptibly(long sleepFor, TimeUnit unit) {
        boolean bl2 = false;
        try {
            long l2 = unit.toNanos(sleepFor);
            long l3 = System.nanoTime() + l2;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.sleep(l2);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    l2 = l3 - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Uninterruptibles() {
    }
}

