/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.seal.sdk.factory;

import com.timevale.esign.paas.seal.sdk.drawer.ImageDrawer;
import com.timevale.esign.paas.seal.sdk.drawer.impl.BusinessEllipseImageDrawer;
import com.timevale.esign.paas.seal.sdk.drawer.impl.DefaultEllipseImageDrawer;
import com.timevale.esign.paas.seal.sdk.drawer.impl.DoubleEllipseImageDrawer;
import com.timevale.esign.paas.seal.sdk.drawer.impl.HkEllipseImageDrawer;
import com.timevale.esign.paas.seal.sdk.drawer.impl.RectImageDrawer;
import com.timevale.esign.paas.seal.sdk.enums.DrawRuleTypeEnum;
import com.timevale.esign.paas.seal.sdk.enums.DrawerTypeEnum;
import com.timevale.esign.paas.seal.sdk.enums.SealTypeEnum;
import com.timevale.esign.paas.seal.sdk.exception.SealSdkException;
import com.timevale.esign.paas.seal.sdk.request.generator.RequestGenerator;
import com.timevale.esign.paas.seal.sdk.request.generator.impl.BusinessEllipseImageRequestGenerator;
import com.timevale.esign.paas.seal.sdk.request.generator.impl.DoubleEllipseImageRequestGenerator;
import com.timevale.esign.paas.seal.sdk.request.generator.impl.EllipseImageRequestGenerator;
import com.timevale.esign.paas.seal.sdk.request.generator.impl.HkEllipseRequestGenerator;
import com.timevale.esign.paas.seal.sdk.request.generator.impl.RectImageRequestGenerator;

public class DrawerFactory {
    private DrawerFactory() {
    }

    public static ImageDrawer getImageDrawer(SealTypeEnum sealTypeEnum, DrawRuleTypeEnum drawRuleTypeEnum) {
        if (sealTypeEnum == null) {
            throw new SealSdkException("\u5165\u53c2 sealTypeEnum \u4e3a\u7a7a");
        }
        DrawerTypeEnum drawerTypeEnum = sealTypeEnum.getDrawerType();
        if (DrawerTypeEnum.ELLIPSE.equals((Object)drawerTypeEnum)) {
            if (DrawRuleTypeEnum.BUSINESS.equals((Object)drawRuleTypeEnum)) {
                return BusinessEllipseImageDrawerFactory.instance;
            }
            return DefaultEllipseImageDrawerFactory.instance;
        }
        if (DrawerTypeEnum.DOUBLE_ELLIPSE.equals((Object)drawerTypeEnum)) {
            if (DrawRuleTypeEnum.HONG_KONG.equals((Object)drawRuleTypeEnum)) {
                return HkEllipseImageDrawerFactory.instance;
            }
            return DoubleEllipseImageDrawerFactory.instance;
        }
        return RectImageDrawerFactory.instance;
    }

    public static RequestGenerator getGenerator(SealTypeEnum sealTypeEnum, DrawRuleTypeEnum drawRuleTypeEnum) {
        if (sealTypeEnum == null) {
            throw new SealSdkException("\u5165\u53c2 sealTypeEnum \u4e3a\u7a7a");
        }
        DrawerTypeEnum drawerTypeEnum = sealTypeEnum.getDrawerType();
        if (DrawerTypeEnum.ELLIPSE.equals((Object)drawerTypeEnum)) {
            if (DrawRuleTypeEnum.BUSINESS.equals((Object)drawRuleTypeEnum)) {
                return BusinessEllipseImageRequestGeneratorFactory.instance;
            }
            return EllipseImageRequestGeneratorFactory.instance;
        }
        if (DrawerTypeEnum.DOUBLE_ELLIPSE.equals((Object)drawerTypeEnum)) {
            if (DrawRuleTypeEnum.HONG_KONG.equals((Object)drawRuleTypeEnum)) {
                return HkEllipseRequestGeneratorFactory.instance;
            }
            return DoubleEllipseImageRequestGeneratorFactory.instance;
        }
        return RectImageRequestGeneratorFactory.instance;
    }

    private static class HkEllipseRequestGeneratorFactory {
        private static final HkEllipseRequestGenerator instance = new HkEllipseRequestGenerator();

        private HkEllipseRequestGeneratorFactory() {
        }
    }

    private static class RectImageRequestGeneratorFactory {
        private static final RectImageRequestGenerator instance = new RectImageRequestGenerator();

        private RectImageRequestGeneratorFactory() {
        }
    }

    private static class BusinessEllipseImageRequestGeneratorFactory {
        private static final BusinessEllipseImageRequestGenerator instance = new BusinessEllipseImageRequestGenerator();

        private BusinessEllipseImageRequestGeneratorFactory() {
        }
    }

    private static class EllipseImageRequestGeneratorFactory {
        private static final EllipseImageRequestGenerator instance = new EllipseImageRequestGenerator();

        private EllipseImageRequestGeneratorFactory() {
        }
    }

    private static class DoubleEllipseImageRequestGeneratorFactory {
        private static final DoubleEllipseImageRequestGenerator instance = new DoubleEllipseImageRequestGenerator();

        private DoubleEllipseImageRequestGeneratorFactory() {
        }
    }

    private static class HkEllipseImageDrawerFactory {
        private static final HkEllipseImageDrawer instance = new HkEllipseImageDrawer();

        private HkEllipseImageDrawerFactory() {
        }
    }

    private static class RectImageDrawerFactory {
        private static final RectImageDrawer instance = new RectImageDrawer();

        private RectImageDrawerFactory() {
        }
    }

    private static class DoubleEllipseImageDrawerFactory {
        private static final DoubleEllipseImageDrawer instance = new DoubleEllipseImageDrawer();

        private DoubleEllipseImageDrawerFactory() {
        }
    }

    private static class BusinessEllipseImageDrawerFactory {
        private static final BusinessEllipseImageDrawer instance = new BusinessEllipseImageDrawer();

        private BusinessEllipseImageDrawerFactory() {
        }
    }

    private static class DefaultEllipseImageDrawerFactory {
        private static final DefaultEllipseImageDrawer instance = new DefaultEllipseImageDrawer();

        private DefaultEllipseImageDrawerFactory() {
        }
    }
}

