/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.bean.bean;

import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.seal.sdk.util.StringUtils;
import com.timevale.esign.paas.tech.constant.ErrorException;
import com.timevale.esign.paas.tech.util.StringCheckUtil;
import com.timevale.esign.paas.tech.util.ValidationUtil;

public abstract class AccountBean {
    private String name;
    private Boolean encrypt;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getEncrypt() {
        return this.encrypt;
    }

    public void setEncrypt(Boolean encrypt) {
        this.encrypt = encrypt;
    }

    public void check() throws SuperException {
        ValidationUtil.check(StringUtils.isBlank(this.getName()), ErrorException.ADD_ACCOUNT_ERROR.e("name\u4e0d\u80fd\u4e3a\u7a7a"));
        ValidationUtil.check(StringCheckUtil.containsSpecialChars(this.getName()) || StringCheckUtil.containsRarelyUsedWords(this.getName()) != false, ErrorException.ADD_ACCOUNT_ERROR.e("name\u5b58\u5728\u7279\u6b8a\u5b57\u7b26\u6216\u751f\u50fb\u5b57"));
    }

    public void checkUpdate() throws SuperException {
        ValidationUtil.check(StringUtils.isBlank(this.getName()), ErrorException.UPDATE_ACCOUNT_ERROR.e("name\u4e0d\u80fd\u4e3a\u7a7a"));
        ValidationUtil.check(StringCheckUtil.containsSpecialChars(this.getName()) || StringCheckUtil.containsRarelyUsedWords(this.getName()) != false, ErrorException.UPDATE_ACCOUNT_ERROR.e("name\u5b58\u5728\u7279\u6b8a\u5b57\u7b26\u6216\u751f\u50fb\u5b57"));
    }
}

