/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.bean.bean;

import com.timevale.esign.paas.esign.utils.IOUtil;
import com.timevale.esign.paas.esign.utils.StringUtil;
import com.timevale.esign.paas.esign.utils.exception.ErrorsDiscriptor;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.tech.bean.bean.AbstractSignPdfBean;
import com.timevale.esign.paas.tech.common.checker.IParametersValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class SignPDFFileBean
extends AbstractSignPdfBean
implements IParametersValidator {
    private String srcPdfFile;
    private InputStream fileStream;
    private byte[] bytes;

    public String getSrcPdfFile() {
        return this.srcPdfFile;
    }

    public void setSrcPdfFile(String srcPdfFile) {
        this.srcPdfFile = srcPdfFile;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public int validator() {
        if (StringUtil.isNull(this.srcPdfFile)) {
            return ErrorsDiscriptor.EmptyInputSpec.code();
        }
        if (StringUtil.isNull(this.getDstPdfFile())) {
            return ErrorsDiscriptor.EmptyInputSpec.code();
        }
        return ErrorsDiscriptor.Success.code();
    }

    @Override
    public InputStream getSrcStream() throws SuperException {
        if (this.fileStream == null) {
            try {
                if (this.srcPdfFile == null) {
                    throw ErrorsDiscriptor.MissingArgumentsSpec.e("pdf\u6e90\u6587\u4ef6\u4e3a\u7a7a");
                }
                this.fileStream = new FileInputStream(new File(this.srcPdfFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw ErrorsDiscriptor.Sign_SourcePdfLoadFailed.e();
            }
        }
        return this.fileStream;
    }

    @Override
    public byte[] getBytes() throws SuperException {
        if (this.bytes == null) {
            try {
                this.bytes = IOUtil.readStreamAsByteArray(this.getSrcStream());
            }
            catch (IOException iOException) {
                throw ErrorsDiscriptor.InternalServiceTaken.e(iOException.getMessage());
            }
            finally {
                this.closeInputStream();
            }
        }
        return this.bytes;
    }

    @Override
    public void closeInputStream() {
        if (null != this.fileStream) {
            try {
                this.fileStream.close();
                this.fileStream = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected String getSrcFileName() {
        return this.srcPdfFile;
    }
}

