/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.bean.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.seal.sdk.util.StringUtils;
import com.timevale.esign.paas.tech.constant.ErrorException;
import com.timevale.esign.paas.tech.enums.AccountTypeEnum;
import com.timevale.esign.paas.tech.enums.AllIdNoTypeEnum;
import com.timevale.esign.paas.tech.util.ValidationUtil;

@JsonIgnoreProperties(ignoreUnknown=true)
public class QueryAccountInfoParam {
    private String idNo;
    private AllIdNoTypeEnum idNoType;
    private AccountTypeEnum type;
    private Boolean encrypt;

    public String getIdNo() {
        return this.idNo;
    }

    public void setIdNo(String idNo) {
        this.idNo = idNo;
    }

    public AllIdNoTypeEnum getIdNoType() {
        return this.idNoType;
    }

    public void setIdNoType(AllIdNoTypeEnum idNoType) {
        this.idNoType = idNoType;
    }

    public AccountTypeEnum getType() {
        return this.type;
    }

    public void setType(AccountTypeEnum type) {
        this.type = type;
    }

    public Boolean getEncrypt() {
        return this.encrypt;
    }

    public void setEncrypt(Boolean encrypt) {
        this.encrypt = encrypt;
    }

    public void check() throws SuperException {
        ValidationUtil.check(StringUtils.isBlank(this.idNo), ErrorException.QUERY_ACCOUNT_ERROR.e("idNo\u4e0d\u80fd\u4e3a\u7a7a"));
        ValidationUtil.check(this.idNoType == null, ErrorException.QUERY_ACCOUNT_ERROR.e("idNoType\u4e0d\u80fd\u4e3a\u7a7a"));
        ValidationUtil.check(this.type == null, ErrorException.QUERY_ACCOUNT_ERROR.e("type\u4e0d\u80fd\u4e3a\u7a7a"));
        if (AccountTypeEnum.PERSON.equals((Object)this.type)) {
            ValidationUtil.check(!AllIdNoTypeEnum.personIdNoTypes().contains((Object)this.idNoType), ErrorException.QUERY_ACCOUNT_ERROR.e("idNoType\u975e\u4e2a\u4eba\u8bc1\u4ef6\u7c7b\u578b"));
        }
        if (AccountTypeEnum.ORGAN.equals((Object)this.type)) {
            ValidationUtil.check(!AllIdNoTypeEnum.orgCodeTypes().contains((Object)this.idNoType), ErrorException.QUERY_ACCOUNT_ERROR.e("idNoType\u975e\u4f01\u4e1a\u8bc1\u4ef6\u7c7b\u578b"));
        }
    }
}

